/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap.authenticator;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.providers.ldap.authenticator.LdapShaPasswordEncoder;

public class LdapShaPasswordEncoderTests {
    LdapShaPasswordEncoder sha;

    @Before
    public void setUp() throws Exception {
        this.sha = new LdapShaPasswordEncoder();
    }

    @Test
    public void invalidPasswordFails() {
        Assert.assertFalse((boolean)this.sha.isPasswordValid("{SHA}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "wrongpassword", null));
    }

    @Test
    public void invalidSaltedPasswordFails() {
        Assert.assertFalse((boolean)this.sha.isPasswordValid("{SSHA}25ro4PKC8jhQZ26jVsozhX/xaP0suHgX", "wrongpassword", null));
        Assert.assertFalse((boolean)this.sha.isPasswordValid("{SSHA}PQy2j+6n5ytA+YlAKkM8Fh4p6u2JxfVd", "wrongpassword", null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonByteArraySaltThrowsException() {
        this.sha.encodePassword("password", (Object)"AStringNotAByteArray");
    }

    @Test
    public void validPasswordSucceeds() {
        this.sha.setForceLowerCasePrefix(false);
        Assert.assertTrue((boolean)this.sha.isPasswordValid("{SHA}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "boabspasswurd", null));
        Assert.assertTrue((boolean)this.sha.isPasswordValid("{sha}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "boabspasswurd", null));
        this.sha.setForceLowerCasePrefix(true);
        Assert.assertTrue((boolean)this.sha.isPasswordValid("{SHA}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "boabspasswurd", null));
        Assert.assertTrue((boolean)this.sha.isPasswordValid("{sha}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "boabspasswurd", null));
    }

    @Test
    public void validSaltedPasswordSucceeds() {
        this.sha.setForceLowerCasePrefix(false);
        Assert.assertTrue((boolean)this.sha.isPasswordValid("{SSHA}25ro4PKC8jhQZ26jVsozhX/xaP0suHgX", "boabspasswurd", null));
        Assert.assertTrue((boolean)this.sha.isPasswordValid("{ssha}PQy2j+6n5ytA+YlAKkM8Fh4p6u2JxfVd", "boabspasswurd", null));
        this.sha.setForceLowerCasePrefix(true);
        Assert.assertTrue((boolean)this.sha.isPasswordValid("{SSHA}25ro4PKC8jhQZ26jVsozhX/xaP0suHgX", "boabspasswurd", null));
        Assert.assertTrue((boolean)this.sha.isPasswordValid("{ssha}PQy2j+6n5ytA+YlAKkM8Fh4p6u2JxfVd", "boabspasswurd", null));
    }

    @Test
    public void correctPrefixCaseIsUsed() {
        this.sha.setForceLowerCasePrefix(false);
        Assert.assertEquals((Object)"{SHA}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", (Object)this.sha.encodePassword("boabspasswurd", null));
        Assert.assertTrue((boolean)this.sha.encodePassword("somepassword", (Object)"salt".getBytes()).startsWith("{SSHA}"));
        this.sha.setForceLowerCasePrefix(true);
        Assert.assertEquals((Object)"{sha}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", (Object)this.sha.encodePassword("boabspasswurd", null));
        Assert.assertTrue((boolean)this.sha.encodePassword("somepassword", (Object)"salt".getBytes()).startsWith("{ssha}"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidPrefixIsRejected() {
        this.sha.isPasswordValid("{MD9}xxxxxxxxxx", "somepassword", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void malformedPrefixIsRejected() {
        this.sha.isPasswordValid("{SSHA25ro4PKC8jhQZ26jVsozhX/xaP0suHgX", "somepassword", null);
    }
}

