/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import javax.naming.Name;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ldap.SpringSecurityAuthenticationSource;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.userdetails.ldap.LdapUserDetailsImpl;
import org.springframework.security.util.AuthorityUtils;

public class SpringSecurityAuthenticationSourceTests {
    @Before
    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void principalAndCredentialsAreEmptyWithNoAuthentication() {
        SpringSecurityAuthenticationSource source = new SpringSecurityAuthenticationSource();
        Assert.assertEquals((Object)"", (Object)source.getPrincipal());
        Assert.assertEquals((Object)"", (Object)source.getCredentials());
    }

    @Test
    public void principalIsEmptyForAnonymousUser() {
        SpringSecurityAuthenticationSource source = new SpringSecurityAuthenticationSource();
        SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("key", (Object)"anonUser", AuthorityUtils.commaSeparatedStringToAuthorityArray((String)"ignored")));
        Assert.assertEquals((Object)"", (Object)source.getPrincipal());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPrincipalRejectsNonLdapUserDetailsObject() {
        SpringSecurityAuthenticationSource source = new SpringSecurityAuthenticationSource();
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken(new Object(), "password"));
        source.getPrincipal();
    }

    @Test
    public void expectedCredentialsAreReturned() {
        SpringSecurityAuthenticationSource source = new SpringSecurityAuthenticationSource();
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken(new Object(), "password"));
        Assert.assertEquals((Object)"password", (Object)source.getCredentials());
    }

    @Test
    public void expectedPrincipalIsReturned() {
        LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence();
        user.setUsername("joe");
        user.setDn((Name)new DistinguishedName("uid=joe,ou=users"));
        SpringSecurityAuthenticationSource source = new SpringSecurityAuthenticationSource();
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken(user.createUserDetails(), null));
        Assert.assertEquals((Object)"uid=joe, ou=users", (Object)source.getPrincipal());
    }
}

