/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class UserServiceBeanDefinitionParserTests {
    private AbstractXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
    }

    @Test
    public void userServiceWithValidPropertiesFileWorksSuccessfully() {
        this.setContext("<user-service id='service' properties='classpath:org/springframework/security/config/users.properties'/>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        userService.loadUserByUsername("bob");
        userService.loadUserByUsername("joe");
    }

    @Test
    public void userServiceWithEmbeddedUsersWorksSuccessfully() {
        this.setContext("<user-service id='service'>    <user name='joe' password='joespassword' authorities='ROLE_A'/></user-service>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        userService.loadUserByUsername("joe");
    }

    @Test
    public void disabledAndEmbeddedFlagsAreSupported() {
        this.setContext("<user-service id='service'>    <user name='joe' password='joespassword' authorities='ROLE_A' locked='true'/>    <user name='bob' password='bobspassword' authorities='ROLE_A' disabled='true'/></user-service>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        UserDetails joe = userService.loadUserByUsername("joe");
        Assert.assertFalse((boolean)joe.isAccountNonLocked());
        UserDetails bob = userService.loadUserByUsername("bob");
        Assert.assertFalse((boolean)bob.isEnabled());
    }

    @Test(expected=FatalBeanException.class)
    public void userWithBothPropertiesAndEmbeddedUsersThrowsException() {
        this.setContext("<user-service id='service' properties='doesntmatter.props'>    <user name='joe' password='joespassword' authorities='ROLE_A'/></user-service>");
        UserDetailsService userService = (UserDetailsService)this.appContext.getBean("service");
        userService.loadUserByUsername("joe");
    }

    @Test(expected=FatalBeanException.class)
    public void multipleTopLevelUseWithoutIdThrowsException() {
        this.setContext("<user-service properties='classpath:org/springframework/security/config/users.properties'/><user-service properties='classpath:org/springframework/security/config/users.properties'/>");
    }

    @Test(expected=FatalBeanException.class)
    public void userServiceWithMissingPropertiesFileThrowsException() {
        this.setContext("<user-service id='service' properties='classpath:doesntexist.properties'/>");
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }
}

