/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.utils;

import com.tonbeller.wcf.utils.SoftException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;

public class JDK13Utils {
    private static final Class[] encodeParamTypes = new Class[]{String.class, String.class};

    private JDK13Utils() {
    }

    public static String urlEncode(String s, String enc) throws UnsupportedEncodingException {
        try {
            Method m = URLEncoder.class.getMethod("encode", encodeParamTypes);
            return (String)m.invoke(null, (Object[])new String[]{s, enc});
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            throw new SoftException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SoftException(e);
        }
        catch (IllegalAccessException e) {
            throw new SoftException(e);
        }
        catch (InvocationTargetException e) {
            Throwable x = e.getTargetException();
            if (x instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)x;
            }
            throw new SoftException(e);
        }
        return URLEncoder.encode(s);
    }

    public static Locale getLocale(String lang) {
        return new Locale(lang, lang.toUpperCase());
    }

    public static Throwable getCause(Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable prev = e;
        if (e instanceof JspException) {
            e = ((JspException)e).getRootCause();
        } else if (e instanceof ServletException) {
            e = ((ServletException)e).getRootCause();
        } else {
            try {
                Method m = e.getClass().getMethod("getCause", new Class[0]);
                e = (Throwable)m.invoke((Object)e, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (e == prev) {
            return null;
        }
        return e;
    }
}

