/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.filter;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJob;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.filter.BaseSearchFilter;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ScheduleFilter
extends BaseSearchFilter {
    public void applyRestrictions(String type, ExecutionContext context, SearchCriteria criteria) {
        String scheduleFilter;
        SearchAttributes searchAttributes = this.getSearchAttributes(context);
        User user = null;
        if (context.getAttributes() != null) {
            for (Object o : context.getAttributes()) {
                if (!(o instanceof User)) continue;
                user = (User)o;
            }
        }
        if (searchAttributes != null && searchAttributes.getState() != null && (scheduleFilter = searchAttributes.getState().getCustomFiltersMap().get("scheduleFilter")) != null && !scheduleFilter.equals("scheduleFilter-anySchedule")) {
            if (scheduleFilter.equals("scheduleFilter-scheduled")) {
                this.createCriteria(criteria, user, true, false);
            } else if (scheduleFilter.equals("scheduleFilter-scheduledByMe")) {
                this.createCriteria(criteria, user, true, true);
            } else if (scheduleFilter.equals("scheduleFilter-notScheduled")) {
                this.createCriteria(criteria, user, false, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createCriteria(SearchCriteria criteria, User user, boolean scheduled, boolean scheduledByUser) {
        SearchCriteria uriCriteria = SearchCriteria.forClass(PersistentReportJob.class);
        if (scheduledByUser) {
            this.addOwnerCriteria(uriCriteria, user);
        }
        uriCriteria.addProjection((Projection)Projections.property((String)"source.reportUnitURI"));
        List uriList = this.getHibernateTemplate().findByCriteria((DetachedCriteria)uriCriteria);
        if (!uriList.isEmpty()) {
            SearchCriteria idCriteria = SearchCriteria.forClass(RepoResource.class);
            Disjunction disjunction = Restrictions.disjunction();
            String alias = idCriteria.getAlias("parent", "p");
            for (Object o : uriList) {
                String uri = (String)o;
                disjunction.add(this.getResourceCriterion(alias, uri));
            }
            idCriteria.add((Criterion)disjunction);
            idCriteria.addProjection((Projection)Projections.id());
            List idList = this.getHibernateTemplate().findByCriteria((DetachedCriteria)idCriteria);
            if (idList.isEmpty()) throw new RuntimeException("No resources found for URI list " + uriList);
            if (scheduled) {
                criteria.add(Restrictions.in((String)"id", (Collection)idList));
                return;
            } else {
                criteria.add(Restrictions.not((Criterion)Restrictions.in((String)"id", (Collection)idList)));
            }
            return;
        } else {
            if (!scheduled && !scheduledByUser) return;
            criteria.add(Restrictions.isNull((String)"id"));
        }
    }

    protected void addOwnerCriteria(SearchCriteria criteria, User user) {
        String alias = criteria.getAlias("owner", "o");
        criteria.add((Criterion)Restrictions.eq((String)(alias + ".username"), (Object)user.getUsername()));
    }

    private Criterion getResourceCriterion(String alias, String uri) {
        int lastSlashPos = uri.lastIndexOf("/");
        String folderUri = uri.substring(0, lastSlashPos);
        String resourceName = uri.substring(lastSlashPos + 1);
        if (folderUri.length() == 0) {
            folderUri = "/";
        }
        return Restrictions.and((Criterion)Restrictions.eq((String)"name", (Object)resourceName), (Criterion)Restrictions.eq((String)(alias + ".URI"), (Object)folderUri));
    }
}

