/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.filter;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.filter.BaseSearchFilter;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.service.RepositorySearchCriteria;
import com.jaspersoft.jasperserver.war.common.RoleAccessUrisResolver;
import com.jaspersoft.jasperserver.war.common.UriDescriptor;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class FolderFilter
extends BaseSearchFilter {
    private RoleAccessUrisResolver roleAccessUrisResolver;

    public void setRoleAccessUrisResolver(RoleAccessUrisResolver roleAccessUrisResolver) {
        this.roleAccessUrisResolver = roleAccessUrisResolver;
    }

    public void applyRestrictions(String type, ExecutionContext context, SearchCriteria criteria) {
        SearchMode searchMode = null;
        String folderUri = null;
        SearchAttributes searchAttributes = this.getSearchAttributes(context);
        if (searchAttributes != null) {
            searchMode = searchAttributes.getMode();
            folderUri = searchAttributes.getState() != null ? searchAttributes.getState().getFolderUri() : null;
        } else {
            RepositorySearchCriteria searchCriteria = this.getTypedAttribute(context, RepositorySearchCriteria.class);
            if (searchCriteria != null) {
                searchMode = searchCriteria.getSearchMode();
                folderUri = searchCriteria.getFolderUri();
            }
        }
        if (folderUri != null) {
            String absoluteUri = this.roleAccessUrisResolver.getAbsoluteUri(folderUri);
            String alias = criteria.getAlias("parent", "p");
            if (SearchMode.BROWSE == searchMode) {
                criteria.add((Criterion)Restrictions.eq((String)(alias + ".URI"), (Object)absoluteUri));
            } else {
                this.addSearchModeFolderRestrictions(criteria, absoluteUri, alias);
            }
            this.addRoleAccessUrlsRestrictions(criteria);
        }
    }

    protected String createSubFoldersLikeUri(String folderUri) {
        return folderUri.endsWith("/") ? folderUri + "%" : folderUri + "/" + "%";
    }

    protected void addSearchModeFolderRestrictions(SearchCriteria criteria, String folderUri, String alias) {
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)(alias + ".URI"), (Object)this.createSubFoldersLikeUri(folderUri)), (Criterion)Restrictions.eq((String)(alias + ".URI"), (Object)folderUri)));
    }

    private void addRoleAccessUrlsRestrictions(SearchCriteria criteria) {
        String alias = criteria.getAlias("parent", "p");
        for (UriDescriptor uriDescriptor : this.roleAccessUrisResolver.getRestrictedUris()) {
            String uri = uriDescriptor.isAbsolute() ? uriDescriptor.getUri() : this.roleAccessUrisResolver.getAbsoluteUri(uriDescriptor.getUri());
            criteria.add((Criterion)Restrictions.ne((String)(alias + ".URI"), (Object)uri));
            String childrenUrlsExp = uri.endsWith("/") ? uri + "%" : uri + "/" + "%";
            criteria.add(Restrictions.not((Criterion)Restrictions.like((String)(alias + ".URI"), (Object)childrenUrlsExp)));
        }
    }
}

