/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.query;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.util.JSON;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;

public class MongoDbQueryWrapper {
    private static final Logger logger = Logger.getLogger(MongoDbQueryWrapper.class);
    public static final String FIND_QUERY_KEY = "findQuery";
    public static final String FIND_QUERY_REGEXP_KEY = "findQueryRegEx";
    public static final String FIND_FIELDS_KEY = "findFields";
    public static final String SORT_KEY = "sort";
    public static final String LIMIT_KEY = "limit";
    public static final String COLLECTION_NAME_KEY = "collectionName";
    public static final String ROWS_TO_PROCESS_KEY = "rowsToProcess";
    public static final String MAP_REDUCE_KEY = "mapReduce";
    public static final String MAP_KEY = "map";
    public static final String REDUCE_KEY = "reduce";
    public static final String OUT_KEY = "out";
    private static final String OUT_DB_KEY = "db";
    private static final String FINALIZE_KEY = "finalize";
    private static final String RUN_COMMAND_KEY = "runCommand";
    private static final String RESULT_KEY = "result";
    public DBCursor iterator;
    public DBObject queryObject;
    public int rowsToProcess = 5;
    private MongoDbConnection connection;
    private Map<String, Object> parameters;
    public List<?> commandResults;

    public MongoDbQueryWrapper(String queryString, MongoDbConnection connection, Map<String, Object> parameters) throws JRException {
        this.connection = connection;
        this.parameters = parameters;
        this.processQuery(queryString);
    }

    public void processQuery(String queryString) throws JRException {
        Integer value;
        logger.info((Object)"Processing mongoDB query");
        if (queryString.startsWith("\"")) {
            queryString = queryString.substring(1, queryString.length());
        }
        if (queryString.endsWith("\"")) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        Object parseResult = JSON.parse((String)queryString);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query: " + queryString));
        }
        if (!(parseResult instanceof DBObject)) {
            throw new JRException("Unsupported type: " + parseResult.getClass().getName());
        }
        this.queryObject = (DBObject)parseResult;
        this.fixQueryObject(this.queryObject, this.parameters);
        if (this.queryObject.containsField(RUN_COMMAND_KEY)) {
            this.runCommand(this.queryObject.removeField(RUN_COMMAND_KEY));
        } else {
            this.createIterator();
        }
        if (this.queryObject.containsField(ROWS_TO_PROCESS_KEY) && (value = this.processInteger(this.queryObject.get(ROWS_TO_PROCESS_KEY))) != null) {
            this.rowsToProcess = value;
        }
        if (this.rowsToProcess == 0) {
            this.rowsToProcess = Integer.MAX_VALUE;
        }
    }

    private Object fixQueryObject(DBObject queryObjectToFix, Map<String, Object> reportParameters) {
        String key2;
        Set keySet = queryObjectToFix.keySet();
        if (keySet.size() == 1 && reportParameters.containsKey(key2 = (String)keySet.iterator().next()) && queryObjectToFix.get(key2) == null) {
            return reportParameters.get(key2);
        }
        for (String key2 : queryObjectToFix.keySet()) {
            Object value = queryObjectToFix.get(key2);
            if (!(value instanceof DBObject)) continue;
            queryObjectToFix.put(key2, this.fixQueryObject((DBObject)value, reportParameters));
        }
        return queryObjectToFix;
    }

    private void runCommand(Object commandValue) throws JRException {
        CommandResult commandResult;
        if (!(commandValue instanceof DBObject)) {
            throw new JRException("Command must be a valid BSON object");
        }
        DBObject commandObject = (DBObject)commandValue;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Command object: " + commandObject));
        }
        if (!(commandResult = this.connection.getMongoDatabase().command(commandObject)).ok()) {
            throw new JRException(commandResult.getErrorMessage());
        }
        Object resultObject = commandResult.get(RESULT_KEY);
        if (resultObject == null) {
            throw new JRException("No results");
        }
        this.commandResults = (List)resultObject;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result List: " + resultObject));
        }
    }

    private void createIterator() throws JRException {
        Object value;
        if (!this.queryObject.containsField(COLLECTION_NAME_KEY)) {
            throw new JRException("\"collectionName\" must be part of the query object");
        }
        DBObject findQueryObject = (DBObject)this.queryObject.get(FIND_QUERY_KEY);
        if (findQueryObject == null) {
            findQueryObject = new BasicDBObject();
        }
        if (this.queryObject.containsField(FIND_QUERY_REGEXP_KEY)) {
            DBObject regExpObject = (DBObject)this.queryObject.get(FIND_QUERY_REGEXP_KEY);
            for (String key : regExpObject.keySet()) {
                value = (String)regExpObject.get(key);
                if (!((String)value).startsWith("/")) {
                    throw new JRException("Regular expressions must start with: /");
                }
                value = ((String)value).substring(1, ((String)value).length());
                if (!((String)value).contains("/")) {
                    throw new JRException("No ending symbol found: /");
                }
                int index = ((String)value).lastIndexOf("/");
                String flags = null;
                if (index == ((String)value).length() - 1) {
                    value = ((String)value).substring(0, index);
                } else {
                    flags = ((String)value).substring(index + 1, ((String)value).length());
                    value = ((String)value).substring(0, index);
                }
                findQueryObject.put(key, (Object)Pattern.compile(String.valueOf(flags != null ? "(?" + flags + ")" : "") + (String)value));
            }
        }
        DBCollection collection = this.connection.getMongoDatabase().getCollectionFromString((String)this.queryObject.removeField(COLLECTION_NAME_KEY));
        if (this.queryObject.containsField(MAP_REDUCE_KEY)) {
            value = this.queryObject.removeField(MAP_REDUCE_KEY);
            if (!(value instanceof DBObject)) {
                logger.error((Object)"MapReduce value must be a valid JSON object");
            } else {
                MapReduceOutput mapReduceOutput;
                DBCollection mapReduceCollection;
                Object finalizeObject;
                DBObject mapReduceObject = (DBObject)value;
                String map = this.validateProperty(mapReduceObject, MAP_KEY);
                String reduce = this.validateProperty(mapReduceObject, REDUCE_KEY);
                Object outObject = mapReduceObject.get(OUT_KEY);
                if (outObject == null) {
                    throw new JRException("\"out\" cannot be null");
                }
                String collectionName = null;
                Object outDb = null;
                MapReduceCommand.OutputType outputType = null;
                boolean hasOutputType = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Out object: " + outObject + ". Type: " + outObject.getClass().getName()));
                }
                if (outObject instanceof String) {
                    collectionName = String.valueOf(outObject);
                } else if (outObject instanceof DBObject) {
                    DBObject outDbObject = (DBObject)outObject;
                    outDb = outDbObject.removeField(OUT_DB_KEY);
                    Iterator keysIterator = outDbObject.keySet().iterator();
                    String type = null;
                    if (!keysIterator.hasNext()) {
                        throw new JRException("\"out\" object cannot be empty");
                    }
                    type = (String)keysIterator.next();
                    collectionName = String.valueOf(outDbObject.get(type));
                    type = type.toUpperCase();
                    outputType = MapReduceCommand.OutputType.valueOf((String)type);
                    if (outputType == null) {
                        throw new JRException("Unknow output type: " + type);
                    }
                    hasOutputType = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("outobject: " + outDbObject));
                        logger.debug((Object)("collectionName: " + collectionName));
                        logger.debug((Object)("outputType: " + outputType));
                    }
                } else {
                    throw new JRException("Unsupported type for \"out\": " + outObject.getClass().getName());
                }
                MapReduceCommand mapReduceCommand = new MapReduceCommand(collection, map, reduce, collectionName, hasOutputType ? outputType : MapReduceCommand.OutputType.REPLACE, null);
                if (outDb != null) {
                    mapReduceCommand.setOutputDB(String.valueOf(outDb));
                }
                if ((finalizeObject = mapReduceObject.removeField(FINALIZE_KEY)) != null) {
                    mapReduceCommand.setFinalize(String.valueOf(finalizeObject));
                }
                if ((mapReduceCollection = (mapReduceOutput = collection.mapReduce(mapReduceCommand)).getOutputCollection()) != null) {
                    collection = mapReduceCollection;
                }
            }
        }
        this.iterator = collection.find(findQueryObject, (DBObject)this.queryObject.get(FIND_FIELDS_KEY));
        if (this.queryObject.containsField(SORT_KEY)) {
            this.iterator = this.iterator.sort((DBObject)this.queryObject.get(SORT_KEY));
        }
        if (this.queryObject.containsField(LIMIT_KEY) && (value = this.processInteger(this.queryObject.get(LIMIT_KEY))) != null) {
            this.iterator = this.iterator.limit(((Integer)value).intValue());
        }
    }

    private Integer processInteger(Object value) {
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return Integer.parseInt((String)value);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String validateProperty(DBObject object, String name) throws JRException {
        Object value = object.get(name);
        if (value == null) {
            throw new JRException(String.valueOf(name) + " can't be null");
        }
        return String.valueOf(value);
    }
}

