/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.ObjectPermissionImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.PermissionsService;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.utils.JAXBList;
import com.jaspersoft.jasperserver.rest.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.AccessDeniedException;
import org.springframework.stereotype.Service;

@Service(value="restPermissionService")
public class RESTPermission
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTPermission.class);
    @Resource(name="rolesToDisablePermissionEditForEveryone")
    private List<String> rolesToDisablePermissionEditForEveryone;
    @Resource(name="rolesToDisablePermissionEditForNonSuperuser")
    private List<String> rolesToDisablePermissionEditForNonSuperuser;
    @Resource
    private PermissionsService permissionsService;
    @Resource
    private ResourcesManagementRemoteService resourcesManagementRemoteService;

    public void setPermissionsService(PermissionsService permissionsService) {
        this.permissionsService = permissionsService;
    }

    public void setResourcesManagementRemoteService(ResourcesManagementRemoteService resourcesManagementRemoteService) {
        this.resourcesManagementRemoteService = resourcesManagementRemoteService;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String res = this.restUtils.extractRepositoryUri(req.getPathInfo());
        try {
            List permissions = this.permissionsService.getPermissions(res);
            this.restUtils.setStatusAndBody(200, resp, this.generatePermissionUsingJaxb(permissions));
        }
        catch (RemoteException e) {
            throw new ServiceException(500, ((Object)((Object)e)).getClass().getName() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
        }
    }

    private String generatePermissionUsingJaxb(List<ObjectPermission> permissions) {
        try {
            StringWriter sw = new StringWriter();
            JAXBList<ObjectPermission> lst = new JAXBList<ObjectPermission>(permissions);
            Marshaller m = this.restUtils.getMarshaller(JAXBList.class, ObjectPermissionImpl.class, UserImpl.class, RoleImpl.class);
            m.marshal(lst, (Writer)sw);
            if (log.isDebugEnabled()) {
                log.debug((Object)("finished marshaling permissions: " + lst.size()));
            }
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        this.doPut(req, resp);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            JAXBList perm = (JAXBList)this.restUtils.unmarshal((InputStream)req.getInputStream(), JAXBList.class, ObjectPermissionImpl.class, UserImpl.class, RoleImpl.class);
            for (int i = 0; i < perm.size(); ++i) {
                if (this.isValidObjectPermission((ObjectPermission)perm.get(i)) && this.canUpdateObjectPermissions((ObjectPermission)perm.get(i))) {
                    try {
                        this.permissionsService.putPermission((ObjectPermission)perm.get(i));
                        continue;
                    }
                    catch (RemoteException e) {
                        throw new ServiceException(500, ((Object)((Object)e)).getClass().getName() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
                    }
                }
                if (((ObjectPermission)perm.get(i)).getPermissionRecipient() instanceof User) {
                    throw new AccessDeniedException("could not set permissions for: " + ((User)((ObjectPermission)perm.get(i)).getPermissionRecipient()).getUsername());
                }
                throw new AccessDeniedException("could not set permissions for: " + ((Role)((ObjectPermission)perm.get(i)).getPermissionRecipient()).getRoleName());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("finished PUT permissions " + perm.size() + " permissions were added"));
            }
            this.restUtils.setStatusAndBody(200, resp, "");
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(400, "please check the request job descriptor");
        }
        catch (IOException e) {
            throw new ServiceException(400, "please check the request job descriptor");
        }
        catch (JAXBException e) {
            throw new ServiceException(400, "please check the request job descriptor");
        }
    }

    private boolean isValidObjectPermission(ObjectPermission objectPermission) {
        return this.resourcesManagementRemoteService.locateResource(objectPermission.getURI().replace("repo:", "")) != null;
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        List permissions;
        String res = this.restUtils.extractRepositoryUri(req.getPathInfo());
        try {
            permissions = this.permissionsService.getPermissions(res);
        }
        catch (RemoteException e) {
            throw new ServiceException(500, ((Object)((Object)e)).getClass().getName() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
        }
        LinkedList rolesThatCantBeDeleted = new LinkedList();
        LinkedList usersThatCantBeDeleted = new LinkedList();
        String roles = req.getParameter("roles");
        String users = req.getParameter("users");
        if (roles != null && !"".equals(roles) || users != null && !"".equals(users)) {
            List<String> rolesToDelete = Utils.stringToList(roles != null ? roles : "", ",");
            List<String> usersToDelete = Utils.stringToList(users != null ? users : "", ",");
            if (log.isDebugEnabled()) {
                log.debug((Object)("roles to delete: " + rolesToDelete.size() + " users to delete: " + usersToDelete.size()));
            }
            for (String roleName : rolesToDelete) {
                if (this.canUpdateRolePermissions(roleName)) continue;
                throw new AccessDeniedException("could not set permissions for: " + roleName);
            }
            for (String userName : usersToDelete) {
                if (this.canUpdateUserPermissions(userName)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("removed user: " + userName + " from the delete permission request"));
                }
                throw new AccessDeniedException("could not set permissions for: " + userName);
            }
            for (ObjectPermission op : permissions) {
                Object permissionRecipient = op.getPermissionRecipient();
                if ((!(permissionRecipient instanceof Role) || !rolesToDelete.contains(((Role)permissionRecipient).getRoleName())) && (!(permissionRecipient instanceof User) || !usersToDelete.contains(((User)permissionRecipient).getUsername()))) continue;
                try {
                    this.permissionsService.deletePermission(op);
                }
                catch (RemoteException e) {
                    throw new ServiceException(500, ((Object)((Object)e)).getClass().getName() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
                }
            }
        } else {
            throw new ServiceException(400, "users or roles must be specified");
        }
        this.restUtils.setStatusAndBody(200, resp, "");
    }

    private boolean canUpdateObjectPermissions(ObjectPermission objectPermission) {
        if (objectPermission.getPermissionRecipient() instanceof User) {
            User user = (User)objectPermission.getPermissionRecipient();
            if (!this.restUtils.getCurrentlyLoggedUserDetails().getUsername().equals(user.getUsername())) {
                return true;
            }
        }
        if (objectPermission.getPermissionRecipient() instanceof Role) {
            Role role = (Role)objectPermission.getPermissionRecipient();
            if (this.restUtils.isCurrentlyLoggedUserHasSuperUserRole() && !this.rolesToDisablePermissionEditForEveryone.contains(role.getRoleName()) || !this.rolesToDisablePermissionEditForEveryone.contains(role.getRoleName()) && !this.rolesToDisablePermissionEditForNonSuperuser.contains(role.getRoleName())) {
                return true;
            }
        }
        return false;
    }

    private boolean canUpdateRolePermissions(String roleName) {
        return this.restUtils.isCurrentlyLoggedUserHasSuperUserRole() && !this.rolesToDisablePermissionEditForEveryone.contains(roleName) || !this.rolesToDisablePermissionEditForEveryone.contains(roleName) && !this.rolesToDisablePermissionEditForNonSuperuser.contains(roleName);
    }

    private boolean canUpdateUserPermissions(String userName) {
        return !this.restUtils.getCurrentlyLoggedUserDetails().getUsername().equals(userName);
    }

    public List<String> getRolesToDisablePermissionEditForEveryone() {
        return this.rolesToDisablePermissionEditForEveryone;
    }

    public void setRolesToDisablePermissionEditForEveryone(List<String> rolesToDisablePermissionEditForEveryone) {
        this.rolesToDisablePermissionEditForEveryone = rolesToDisablePermissionEditForEveryone;
    }

    public List<String> getRolesToDisablePermissionEditForNonSuperuser() {
        return this.rolesToDisablePermissionEditForNonSuperuser;
    }

    public void setRolesToDisablePermissionEditForNonSuperuser(List<String> rolesToDisablePermissionEditForNonSuperuser) {
        this.rolesToDisablePermissionEditForNonSuperuser = rolesToDisablePermissionEditForNonSuperuser;
    }
}

