/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.RESTServlet;
import com.jaspersoft.jasperserver.ws.axis2.scheduling.ReportSchedulerService;
import com.jaspersoft.jasperserver.ws.scheduling.JobSummary;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="restJobSummarySchedService")
public class RESTJobSummary
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTServlet.class);
    @Resource(name="concreteReportSchedulerService")
    private ReportSchedulerService reportSchedulerService;
    @Resource
    private ResourcesManagementRemoteService resourcesManagementRemoteService;

    public void setResourcesManagementRemoteService(ResourcesManagementRemoteService resourcesManagementRemoteService) {
        this.resourcesManagementRemoteService = resourcesManagementRemoteService;
    }

    public ResourcesManagementRemoteService getResourcesManagementRemoteService() {
        return this.resourcesManagementRemoteService;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String url = this.restUtils.extractRepositoryUri(req.getPathInfo());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting job summary for " + url));
        }
        if (url == null) {
            throw new ServiceException(400, "malformed url: " + url);
        }
        if (this.isValidUri(url)) {
            JobSummary[] summaries = new JobSummary[]{};
            try {
                summaries = this.reportSchedulerService.getReportJobs(url);
            }
            catch (AxisFault axisFault) {
                throw new ServiceException(404, "could not locate jobs for report in uri: " + url + axisFault.getLocalizedMessage());
            }
            if (summaries == null) {
                this.restUtils.setStatusAndBody(200, resp, "");
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found " + summaries.length + "job summaries for report: " + req.getPathInfo()));
                }
                this.restUtils.setStatusAndBody(200, resp, this.generateSummeryReport(summaries));
            }
        } else {
            throw new ServiceException(400, "bad report uri");
        }
    }

    private String generateSummeryReport(JobSummary[] summaries) throws ServiceException {
        try {
            StringWriter sw = new StringWriter();
            sw.append("<jobs>");
            for (int i = 0; i < summaries.length; ++i) {
                this.restUtils.getMarshaller(JobSummary.class).marshal((Object)summaries[i], (Writer)sw);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("finished marshaling job: " + summaries[i].getId()));
            }
            sw.append("</jobs>");
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    protected boolean isValidUri(String reportUri) {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.resourcesManagementRemoteService.locateResource(reportUri);
        return resource != null && resource.getResourceType().equals(ReportUnit.class.getName());
    }

    public void setReportSchedulerService(ReportSchedulerService reportSchedulerService) {
        this.reportSchedulerService = reportSchedulerService;
    }
}

