/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.io.PrintStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.SSORealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public class HashUserRealm
implements UserRealm,
SSORealm {
    public static final String __SSO = "org.mortbay.http.SSO";
    private String _realmName;
    private String _config;
    protected HashMap _users = new HashMap();
    protected HashMap _roles = new HashMap(7);
    private SSORealm _ssoRealm;

    public HashUserRealm() {
    }

    public HashUserRealm(String name) {
        this._realmName = name;
    }

    public HashUserRealm(String name, String config) throws IOException {
        this._realmName = name;
        this.setConfig(config);
    }

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String config) throws IOException {
        this._config = config;
        this._users.clear();
        this._roles.clear();
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Load " + this + " from " + config));
        }
        Properties properties = new Properties();
        Resource resource = Resource.newResource(config);
        properties.load(resource.getInputStream());
        Iterator<Map.Entry<Object, Object>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String username = entry.getKey().toString().trim();
            String credentials = entry.getValue().toString().trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            this.put(username, credentials);
            if (roles == null || roles.length() <= 0) continue;
            StringTokenizer tok = new StringTokenizer(roles, ", ");
            while (tok.hasMoreTokens()) {
                this.addUserToRole(username, tok.nextToken());
            }
        }
    }

    public void setName(String name) {
        this._realmName = name;
    }

    public String getName() {
        return this._realmName;
    }

    public Principal getPrincipal(String username) {
        return (Principal)this._users.get(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String username, Object credentials, Request request) {
        KnownUser user;
        HashUserRealm hashUserRealm = this;
        synchronized (hashUserRealm) {
            user = (KnownUser)this._users.get(username);
        }
        if (user == null) {
            return null;
        }
        if (user.authenticate(credentials)) {
            return user;
        }
        return null;
    }

    public void disassociate(Principal user) {
    }

    public Principal pushRole(Principal user, String role) {
        if (user == null) {
            user = new User();
        }
        return new WrappedUser(user, role);
    }

    public Principal popRole(Principal user) {
        WrappedUser wu = (WrappedUser)user;
        return wu.getUserPrincipal();
    }

    public synchronized Object put(Object name, Object credentials) {
        if (credentials instanceof Principal) {
            return this._users.put(name.toString(), credentials);
        }
        if (credentials instanceof Password) {
            return this._users.put(name, new KnownUser(name.toString(), (Password)credentials));
        }
        if (credentials != null) {
            return this._users.put(name, new KnownUser(name.toString(), Credential.getCredential(credentials.toString())));
        }
        return null;
    }

    public synchronized void addUserToRole(String userName, String roleName) {
        HashSet<String> userSet = (HashSet<String>)this._roles.get(roleName);
        if (userSet == null) {
            userSet = new HashSet<String>(11);
            this._roles.put(roleName, userSet);
        }
        userSet.add(userName);
    }

    public boolean reauthenticate(Principal user) {
        return ((User)user).isAuthenticated();
    }

    public synchronized boolean isUserInRole(Principal user, String roleName) {
        if (user instanceof WrappedUser) {
            return ((WrappedUser)user).isUserInRole(roleName);
        }
        if (user == null || !(user instanceof User) || ((User)user).getUserRealm() != this) {
            return false;
        }
        HashSet userSet = (HashSet)this._roles.get(roleName);
        return userSet != null && userSet.contains(user.getName());
    }

    public void logout(Principal user) {
    }

    public String toString() {
        return "Realm[" + this._realmName + "]==" + this._users.keySet();
    }

    public void dump(PrintStream out) {
        out.println(this + ":");
        out.println(super.toString());
        out.println(this._roles);
    }

    public SSORealm getSSORealm() {
        return this._ssoRealm;
    }

    public void setSSORealm(SSORealm ssoRealm) {
        this._ssoRealm = ssoRealm;
    }

    public Credential getSingleSignOn(Request request, Response response) {
        if (this._ssoRealm != null) {
            return this._ssoRealm.getSingleSignOn(request, response);
        }
        return null;
    }

    public void setSingleSignOn(Request request, Response response, Principal principal, Credential credential) {
        if (this._ssoRealm != null) {
            this._ssoRealm.setSingleSignOn(request, response, principal, credential);
        }
    }

    public void clearSingleSignOn(String username) {
        if (this._ssoRealm != null) {
            this._ssoRealm.clearSingleSignOn(username);
        }
    }

    private class WrappedUser
    extends User {
        private Principal user;
        private String role;

        WrappedUser(Principal user, String role) {
            this.user = user;
            this.role = role;
        }

        Principal getUserPrincipal() {
            return this.user;
        }

        public String getName() {
            return "role:" + this.role;
        }

        public boolean isAuthenticated() {
            return true;
        }

        public boolean isUserInRole(String role) {
            return this.role.equals(role);
        }
    }

    private class KnownUser
    extends User {
        private String _userName;
        private Credential _cred;

        KnownUser(String name, Credential credential) {
            this._userName = name;
            this._cred = credential;
        }

        boolean authenticate(Object credentials) {
            return this._cred != null && this._cred.check(credentials);
        }

        public String getName() {
            return this._userName;
        }

        public boolean isAuthenticated() {
            return true;
        }
    }

    private class User
    implements Principal {
        List roles = null;

        private User() {
        }

        private UserRealm getUserRealm() {
            return HashUserRealm.this;
        }

        public String getName() {
            return "Anonymous";
        }

        public boolean isAuthenticated() {
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

