/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.fop.pdf.PDFObject;

public class PDFNumber
extends PDFObject {
    private Number number;
    private static final String BASE_FORMAT = "0.################";
    private static final ThreadLocal[] DECIMAL_FORMAT_CACHE = new DecimalFormatThreadLocal[17];

    public Number getNumber() {
        return this.number;
    }

    public void setNumber(Number number) {
        this.number = number;
    }

    public static String doubleOut(Double doubleDown) {
        return PDFNumber.doubleOut((double)doubleDown);
    }

    public static String doubleOut(double doubleDown) {
        return PDFNumber.doubleOut(doubleDown, 6);
    }

    public static String doubleOut(double doubleDown, int dec) {
        if (dec < 0 || dec >= DECIMAL_FORMAT_CACHE.length) {
            throw new IllegalArgumentException("Parameter dec must be between 1 and " + (DECIMAL_FORMAT_CACHE.length + 1));
        }
        DecimalFormat df = (DecimalFormat)DECIMAL_FORMAT_CACHE[dec].get();
        return df.format(doubleDown);
    }

    protected String toPDFString() {
        if (this.getNumber() == null) {
            throw new IllegalArgumentException("The number of this PDFNumber must not be empty");
        }
        StringBuffer sb = new StringBuffer(64);
        if (this.hasObjectNumber()) {
            sb.append(this.getObjectID());
        }
        sb.append(this.getNumber().toString());
        if (this.hasObjectNumber()) {
            sb.append("\nendobj\n");
        }
        return sb.toString();
    }

    static {
        int c = DECIMAL_FORMAT_CACHE.length;
        for (int i = 0; i < c; ++i) {
            PDFNumber.DECIMAL_FORMAT_CACHE[i] = new DecimalFormatThreadLocal(i);
        }
    }

    private static class DecimalFormatThreadLocal
    extends ThreadLocal {
        private int dec;

        public DecimalFormatThreadLocal(int dec) {
            this.dec = dec;
        }

        protected synchronized Object initialValue() {
            String s = "0";
            if (this.dec > 0) {
                s = PDFNumber.BASE_FORMAT.substring(0, this.dec + 2);
            }
            DecimalFormat df = new DecimalFormat(s, new DecimalFormatSymbols(Locale.US));
            return df;
        }
    }
}

