/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.List;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FontFamilyProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;

public final class CommonFont {
    private static final PropertyCache cache = new PropertyCache();
    private final CachedCommonFont cachedCommonFont;
    public final Length fontSize;
    public final Numeric fontSizeAdjust;

    private CommonFont(CachedCommonFont ccf, Length fontSize, Numeric fontSizeAdjust) {
        this.cachedCommonFont = ccf;
        this.fontSize = fontSize;
        this.fontSizeAdjust = fontSizeAdjust;
    }

    public static CommonFont getInstance(PropertyList pList) throws PropertyException {
        FontFamilyProperty fontFamily = (FontFamilyProperty)pList.get(92);
        EnumProperty fontSelectionStrategy = (EnumProperty)pList.get(93);
        EnumProperty fontStretch = (EnumProperty)pList.get(96);
        EnumProperty fontStyle = (EnumProperty)pList.get(97);
        EnumProperty fontVariant = (EnumProperty)pList.get(98);
        EnumProperty fontWeight = (EnumProperty)pList.get(99);
        CachedCommonFont cachedCommonFont = CachedCommonFont.getInstance(fontFamily, fontSelectionStrategy, fontStretch, fontStyle, fontVariant, fontWeight);
        Numeric fontSizeAdjust = pList.get(95).getNumeric();
        Length fontSize = pList.get(94).getLength();
        CommonFont cf = new CommonFont(cachedCommonFont, fontSize, fontSizeAdjust);
        if (fontSize.isAbsolute() && fontSizeAdjust.isAbsolute()) {
            return cache.fetch(cf);
        }
        return cf;
    }

    public String getFirstFontFamily() {
        return this.cachedCommonFont.getFirstFontFamily();
    }

    public int getFontSelectionStrategy() {
        return this.cachedCommonFont.fontSelectionStrategy.getEnum();
    }

    public int getFontStretch() {
        return this.cachedCommonFont.fontStretch.getEnum();
    }

    public int getFontStyle() {
        return this.cachedCommonFont.fontStyle.getEnum();
    }

    public int getFontVariant() {
        return this.cachedCommonFont.fontVariant.getEnum();
    }

    public int getFontWeight() {
        return this.cachedCommonFont.fontWeight.getEnum();
    }

    public FontTriplet[] getFontState(FontInfo fontInfo) {
        String style;
        int font_weight;
        switch (this.cachedCommonFont.fontWeight.getEnum()) {
            case 169: {
                font_weight = 100;
                break;
            }
            case 170: {
                font_weight = 200;
                break;
            }
            case 171: {
                font_weight = 300;
                break;
            }
            case 172: {
                font_weight = 400;
                break;
            }
            case 173: {
                font_weight = 500;
                break;
            }
            case 174: {
                font_weight = 600;
                break;
            }
            case 175: {
                font_weight = 700;
                break;
            }
            case 176: {
                font_weight = 800;
                break;
            }
            case 177: {
                font_weight = 900;
                break;
            }
            default: {
                font_weight = 400;
            }
        }
        switch (this.cachedCommonFont.fontStyle.getEnum()) {
            case 164: {
                style = "italic";
                break;
            }
            case 165: {
                style = "oblique";
                break;
            }
            case 166: {
                style = "backslant";
                break;
            }
            default: {
                style = "normal";
            }
        }
        FontTriplet[] triplets = fontInfo.fontLookup(this.cachedCommonFont.getFontFamily(), style, font_weight);
        return triplets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CommonFont) {
            CommonFont cf = (CommonFont)o;
            return cf.cachedCommonFont == this.cachedCommonFont && cf.fontSize == this.fontSize && cf.fontSizeAdjust == this.fontSizeAdjust;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.cachedCommonFont.hashCode();
        hash = 37 * hash + this.fontSize.hashCode();
        hash = 37 * hash + this.fontSizeAdjust.hashCode();
        return hash;
    }

    protected static final class CachedCommonFont {
        private static final PropertyCache cache = new PropertyCache();
        private int hash = 0;
        private final FontFamilyProperty fontFamily;
        private final EnumProperty fontSelectionStrategy;
        private final EnumProperty fontStretch;
        private final EnumProperty fontStyle;
        private final EnumProperty fontVariant;
        private final EnumProperty fontWeight;

        private CachedCommonFont(FontFamilyProperty fontFamily, EnumProperty fontSelectionStrategy, EnumProperty fontStretch, EnumProperty fontStyle, EnumProperty fontVariant, EnumProperty fontWeight) {
            this.fontFamily = fontFamily;
            this.fontSelectionStrategy = fontSelectionStrategy;
            this.fontStretch = fontStretch;
            this.fontStyle = fontStyle;
            this.fontVariant = fontVariant;
            this.fontWeight = fontWeight;
        }

        private static final CachedCommonFont getInstance(FontFamilyProperty fontFamily, EnumProperty fontSelectionStrategy, EnumProperty fontStretch, EnumProperty fontStyle, EnumProperty fontVariant, EnumProperty fontWeight) {
            return cache.fetch(new CachedCommonFont(fontFamily, fontSelectionStrategy, fontStretch, fontStyle, fontVariant, fontWeight));
        }

        private String getFirstFontFamily() {
            return ((Property)this.fontFamily.list.get(0)).getString();
        }

        private String[] getFontFamily() {
            List lst = this.fontFamily.getList();
            String[] fontFamily = new String[lst.size()];
            int c = lst.size();
            for (int i = 0; i < c; ++i) {
                fontFamily[i] = ((Property)lst.get(i)).getString();
            }
            return fontFamily;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CachedCommonFont) {
                CachedCommonFont ccf = (CachedCommonFont)o;
                return ccf.fontFamily == this.fontFamily && ccf.fontSelectionStrategy == this.fontSelectionStrategy && ccf.fontStretch == this.fontStretch && ccf.fontStyle == this.fontStyle && ccf.fontVariant == this.fontVariant && ccf.fontWeight == this.fontWeight;
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                int hash = 17;
                hash = 37 * hash + (this.fontFamily == null ? 0 : this.fontFamily.hashCode());
                hash = 37 * hash + (this.fontSelectionStrategy == null ? 0 : this.fontSelectionStrategy.hashCode());
                hash = 37 * hash + (this.fontStretch == null ? 0 : this.fontStretch.hashCode());
                hash = 37 * hash + (this.fontStyle == null ? 0 : this.fontStyle.hashCode());
                hash = 37 * hash + (this.fontVariant == null ? 0 : this.fontVariant.hashCode());
                this.hash = hash = 37 * hash + (this.fontStretch == null ? 0 : this.fontStretch.hashCode());
            }
            return this.hash;
        }
    }
}

