/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.render.awt.viewer.Renderable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class InputHandler
implements ErrorListener,
Renderable {
    protected File sourcefile = null;
    private File stylesheet = null;
    private Vector xsltParams = null;
    protected Log log = LogFactory.getLog((Class)InputHandler.class);

    public InputHandler(File xmlfile, File xsltfile, Vector params) {
        this.sourcefile = xmlfile;
        this.stylesheet = xsltfile;
        this.xsltParams = params;
    }

    public InputHandler(File fofile) {
        this.sourcefile = fofile;
    }

    public void renderTo(FOUserAgent userAgent, String outputFormat, OutputStream out) throws FOPException {
        FopFactory factory = userAgent.getFactory();
        Fop fop = out != null ? factory.newFop(outputFormat, userAgent, out) : factory.newFop(outputFormat, userAgent);
        if (fop.getUserAgent().getBaseURL() == null) {
            String baseURL = null;
            try {
                baseURL = new File(this.sourcefile.getAbsolutePath()).getParentFile().toURL().toExternalForm();
            }
            catch (Exception e) {
                baseURL = "";
            }
            fop.getUserAgent().setBaseURL(baseURL);
        }
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        this.transformTo(res);
    }

    public void renderTo(FOUserAgent userAgent, String outputFormat) throws FOPException {
        this.renderTo(userAgent, outputFormat, null);
    }

    public void transformTo(OutputStream out) throws FOPException {
        StreamResult res = new StreamResult(out);
        this.transformTo(res);
    }

    protected Source createMainSource() {
        Source result;
        try {
            InputSource is = new InputSource(new FileInputStream(this.sourcefile));
            is.setSystemId(this.sourcefile.toURI().toASCIIString());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/namespaces", true);
            spf.setFeature("http://apache.org/xml/features/xinclude", true);
            XMLReader xr = spf.newSAXParser().getXMLReader();
            result = new SAXSource(xr, is);
        }
        catch (SAXException e) {
            result = new StreamSource(this.sourcefile);
        }
        catch (IOException e) {
            result = new StreamSource(this.sourcefile);
        }
        catch (ParserConfigurationException e) {
            result = new StreamSource(this.sourcefile);
        }
        return result;
    }

    protected Source createXSLTSource() {
        if (this.stylesheet != null) {
            return new StreamSource(this.stylesheet);
        }
        return null;
    }

    protected void transformTo(Result result) throws FOPException {
        try {
            Transformer transformer;
            TransformerFactory factory = TransformerFactory.newInstance();
            Source xsltSource = this.createXSLTSource();
            if (xsltSource == null) {
                transformer = factory.newTransformer();
            } else {
                transformer = factory.newTransformer(xsltSource);
                if (this.xsltParams != null) {
                    for (int i = 0; i < this.xsltParams.size(); i += 2) {
                        transformer.setParameter((String)this.xsltParams.elementAt(i), (String)this.xsltParams.elementAt(i + 1));
                    }
                }
            }
            transformer.setErrorListener(this);
            Source src = this.createMainSource();
            transformer.transform(src, result);
        }
        catch (Exception e) {
            throw new FOPException(e);
        }
    }

    public void warning(TransformerException exc) {
        this.log.warn((Object)exc.getLocalizedMessage());
    }

    public void error(TransformerException exc) {
        this.log.error((Object)exc.toString());
    }

    public void fatalError(TransformerException exc) throws TransformerException {
        throw exc;
    }
}

