/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.CombineHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class CombineHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.io.CombineHiveInputFormat");

    /*
     * WARNING - void declaration
     */
    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        void var14_17;
        this.init(job);
        LinkedHashMap<String, ArrayList<String>> pathToAliases = this.mrwork.getPathToAliases();
        LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork = this.mrwork.getAliasToWork();
        HadoopShims.CombineFileInputFormatShim combine = ShimLoader.getHadoopShims().getCombineFileInputFormat();
        if (combine == null) {
            return super.getSplits(job, numSplits);
        }
        if (combine.getInputPathsShim(job).length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<CombineHiveInputSplit> result = new ArrayList<CombineHiveInputSplit>();
        Path[] paths = combine.getInputPathsShim(job);
        ArrayList<Path> inpDirs = new ArrayList<Path>();
        ArrayList<Path> inpFiles = new ArrayList<Path>();
        HashMap<CombinePathInputFormat, CombineFilter> poolMap = new HashMap<CombinePathInputFormat, CombineFilter>();
        HashSet<Path> poolSet = new HashSet<Path>();
        Path[] arr$ = paths;
        int len$ = arr$.length;
        boolean bl = false;
        while (var14_17 < len$) {
            Path path = arr$[var14_17];
            PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(this.pathToPartitionInfo, path, IOPrepareCache.get().allocatePartitionDescMap());
            TableDesc tableDesc = part.getTableDesc();
            if (tableDesc != null && tableDesc.isNonNative()) {
                return super.getSplits(job, numSplits);
            }
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            String inputFormatClassName = inputFormatClass.getName();
            InputFormat<WritableComparable, Writable> inputFormat = CombineHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            if (this.mrwork != null && !this.mrwork.getHadoopSupportsSplittable()) {
                FileSystem inpFs = path.getFileSystem((Configuration)job);
                if (inputFormat instanceof TextInputFormat) {
                    LinkedList<Path> dirs = new LinkedList<Path>();
                    FileStatus fStats = inpFs.getFileStatus(path);
                    if (fStats.isDir()) {
                        dirs.offer(path);
                    } else if (new CompressionCodecFactory((Configuration)job).getCodec(path) != null) {
                        return super.getSplits(job, numSplits);
                    }
                    while (dirs.peek() != null) {
                        Path tstPath = (Path)dirs.remove();
                        FileStatus[] fStatus = inpFs.listStatus(tstPath);
                        for (int idx = 0; idx < fStatus.length; ++idx) {
                            if (fStatus[idx].isDir()) {
                                dirs.offer(fStatus[idx].getPath());
                                continue;
                            }
                            if (new CompressionCodecFactory((Configuration)job).getCodec(fStatus[idx].getPath()) == null) continue;
                            return super.getSplits(job, numSplits);
                        }
                    }
                }
            }
            if (inputFormat instanceof SymlinkTextInputFormat) {
                return super.getSplits(job, numSplits);
            }
            Path filterPath = path;
            CombineFilter f = null;
            List<Operator<? extends Serializable>> opList = null;
            boolean done = false;
            if (!this.mrwork.isMapperCannotSpanPartns()) {
                opList = HiveFileFormatUtils.doGetWorksFromPath(pathToAliases, aliasToWork, filterPath);
                f = (CombineFilter)poolMap.get(new CombinePathInputFormat(opList, inputFormatClassName));
            } else {
                if (!path.getFileSystem((Configuration)job).getFileStatus(path).isDir()) {
                    filterPath = path.getParent();
                    inpFiles.add(path);
                    poolSet.add(filterPath);
                } else {
                    inpDirs.add(path);
                }
                done = true;
            }
            if (!done) {
                if (f == null) {
                    f = new CombineFilter(filterPath);
                    LOG.info((Object)("CombineHiveInputSplit creating pool for " + path + "; using filter path " + filterPath));
                    combine.createPool(job, f);
                    if (!this.mrwork.isMapperCannotSpanPartns()) {
                        poolMap.put(new CombinePathInputFormat(opList, inputFormatClassName), f);
                    }
                } else {
                    LOG.info((Object)("CombineHiveInputSplit: pool is already created for " + path + "; using filter path " + filterPath));
                    f.addPath(filterPath);
                }
            }
            ++var14_17;
        }
        List<Object> iss = new ArrayList();
        if (!this.mrwork.isMapperCannotSpanPartns()) {
            iss = Arrays.asList(combine.getSplits(job, 1));
        } else {
            for (Path path : inpDirs) {
                this.processPaths(job, combine, iss, path);
            }
            if (inpFiles.size() > 0) {
                for (Path path : poolSet) {
                    combine.createPool(job, new CombineFilter(path));
                }
                this.processPaths(job, combine, iss, inpFiles.toArray(new Path[0]));
            }
        }
        if (this.mrwork.getNameToSplitSample() != null && !this.mrwork.getNameToSplitSample().isEmpty()) {
            iss = this.sampleSplits(iss);
        }
        for (HadoopShims.InputSplitShim inputSplitShim : iss) {
            CombineHiveInputSplit csplit = new CombineHiveInputSplit(job, inputSplitShim);
            result.add(csplit);
        }
        LOG.info((Object)("number of splits " + result.size()));
        return result.toArray(new CombineHiveInputSplit[result.size()]);
    }

    private void processPaths(JobConf job, HadoopShims.CombineFileInputFormatShim combine, List<HadoopShims.InputSplitShim> iss, Path ... path) throws IOException {
        JobConf currJob = new JobConf((Configuration)job);
        FileInputFormat.setInputPaths((JobConf)currJob, (Path[])path);
        iss.addAll(Arrays.asList(combine.getSplits(currJob, 1)));
    }

    private List<HadoopShims.InputSplitShim> sampleSplits(List<HadoopShims.InputSplitShim> splits) {
        HashMap<String, SplitSample> nameToSamples = this.mrwork.getNameToSplitSample();
        ArrayList<HadoopShims.InputSplitShim> retLists = new ArrayList<HadoopShims.InputSplitShim>();
        HashMap aliasToSplitList = new HashMap();
        LinkedHashMap<String, ArrayList<String>> pathToAliases = this.mrwork.getPathToAliases();
        for (HadoopShims.InputSplitShim inputSplitShim : splits) {
            String alias = null;
            for (Path path : inputSplitShim.getPaths()) {
                List<String> l = HiveFileFormatUtils.doGetAliasesFromPath(pathToAliases, path);
                if (l.size() != 1 || !nameToSamples.containsKey(l.get(0)) || alias != null && l.get(0) != alias) {
                    alias = null;
                    break;
                }
                alias = l.get(0);
            }
            if (alias != null) {
                if (!aliasToSplitList.containsKey(alias)) {
                    aliasToSplitList.put(alias, new ArrayList());
                }
                ((ArrayList)aliasToSplitList.get(alias)).add(inputSplitShim);
                continue;
            }
            retLists.add(inputSplitShim);
        }
        block2: for (Map.Entry entry : aliasToSplitList.entrySet()) {
            ArrayList splitList = (ArrayList)entry.getValue();
            long totalSize = 0L;
            for (HadoopShims.InputSplitShim split : splitList) {
                totalSize += split.getLength();
            }
            long targetSize = (long)((double)totalSize * nameToSamples.get(entry.getKey()).getPercent() / 100.0);
            int startIndex = nameToSamples.get(entry.getKey()).getSeedNum() % splitList.size();
            long size = 0L;
            for (int i = 0; i < splitList.size(); ++i) {
                HadoopShims.InputSplitShim split = (HadoopShims.InputSplitShim)splitList.get((startIndex + i) % splitList.size());
                retLists.add(split);
                long splitgLength = split.getLength();
                if (size + splitgLength >= targetSize) {
                    LOG.info((Object)("Sample alias " + entry.getValue() + " using " + (i + 1) + "splits"));
                    if (size + splitgLength <= targetSize) continue block2;
                    split.shrinkSplit(targetSize - size);
                    continue block2;
                }
                size += splitgLength;
            }
        }
        return retLists;
    }

    @Override
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (!(split instanceof CombineHiveInputSplit)) {
            return super.getRecordReader(split, job, reporter);
        }
        CombineHiveInputSplit hsplit = (CombineHiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        this.pushProjectionsAndFilters(job, inputFormatClass, hsplit.getPath(0).toString(), hsplit.getPath(0).toUri().getPath());
        return ShimLoader.getHadoopShims().getCombineFileInputFormat().getRecordReader(job, ((CombineHiveInputSplit)split).getInputSplitShim(), reporter, CombineHiveRecordReader.class);
    }

    static class CombineFilter
    implements PathFilter {
        private final Set<String> pStrings = new HashSet<String>();

        public CombineFilter(Path p) {
            this.addPath(p);
        }

        public void addPath(Path p) {
            String pString = p.toUri().getPath().toString();
            this.pStrings.add(pString);
        }

        public boolean accept(Path path) {
            boolean find = false;
            while (path != null && !find) {
                if (this.pStrings.contains(path.toString())) {
                    find = true;
                    break;
                }
                path = path.getParent();
            }
            return find;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("PathFilter: ");
            for (String pString : this.pStrings) {
                s.append(pString + " ");
            }
            return s.toString();
        }
    }

    private static class CombinePathInputFormat {
        private final List<Operator<? extends Serializable>> opList;
        private final String inputFormatClassName;

        public CombinePathInputFormat(List<Operator<? extends Serializable>> opList, String inputFormatClassName) {
            this.opList = opList;
            this.inputFormatClassName = inputFormatClassName;
        }

        public boolean equals(Object o) {
            if (o instanceof CombinePathInputFormat) {
                CombinePathInputFormat mObj = (CombinePathInputFormat)o;
                if (mObj == null) {
                    return false;
                }
                return ((Object)this.opList).equals(mObj.opList) && this.inputFormatClassName.equals(mObj.inputFormatClassName);
            }
            return false;
        }

        public int hashCode() {
            return this.opList == null ? 0 : ((Object)this.opList).hashCode();
        }
    }

    public static class CombineHiveInputSplit
    implements HadoopShims.InputSplitShim {
        String inputFormatClassName;
        HadoopShims.InputSplitShim inputSplitShim;

        public CombineHiveInputSplit() throws IOException {
            this(ShimLoader.getHadoopShims().getCombineFileInputFormat().getInputSplitShim());
        }

        public CombineHiveInputSplit(HadoopShims.InputSplitShim inputSplitShim) throws IOException {
            this(inputSplitShim.getJob(), inputSplitShim);
        }

        public CombineHiveInputSplit(JobConf job, HadoopShims.InputSplitShim inputSplitShim) throws IOException {
            this.inputSplitShim = inputSplitShim;
            if (job != null) {
                LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = Utilities.getMapRedWork((Configuration)job).getPathToPartitionInfo();
                Path[] ipaths = inputSplitShim.getPaths();
                if (ipaths.length > 0) {
                    PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, ipaths[0], IOPrepareCache.get().getPartitionDescMap());
                    this.inputFormatClassName = part.getInputFileFormatClass().getName();
                }
            }
        }

        public HadoopShims.InputSplitShim getInputSplitShim() {
            return this.inputSplitShim;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public void setInputFormatClassName(String inputFormatClassName) {
            this.inputFormatClassName = inputFormatClassName;
        }

        @Override
        public JobConf getJob() {
            return this.inputSplitShim.getJob();
        }

        @Override
        public long getLength() {
            return this.inputSplitShim.getLength();
        }

        @Override
        public long[] getStartOffsets() {
            return this.inputSplitShim.getStartOffsets();
        }

        @Override
        public long[] getLengths() {
            return this.inputSplitShim.getLengths();
        }

        @Override
        public long getOffset(int i) {
            return this.inputSplitShim.getOffset(i);
        }

        @Override
        public long getLength(int i) {
            return this.inputSplitShim.getLength(i);
        }

        @Override
        public int getNumPaths() {
            return this.inputSplitShim.getNumPaths();
        }

        @Override
        public Path getPath(int i) {
            return this.inputSplitShim.getPath(i);
        }

        @Override
        public Path[] getPaths() {
            return this.inputSplitShim.getPaths();
        }

        @Override
        public String[] getLocations() throws IOException {
            return this.inputSplitShim.getLocations();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(((Object)this.inputSplitShim).toString());
            sb.append("InputFormatClass: " + this.inputFormatClassName);
            sb.append("\n");
            return sb.toString();
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.inputSplitShim.readFields(in);
            this.inputFormatClassName = in.readUTF();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.inputSplitShim.write(out);
            if (this.inputFormatClassName == null) {
                LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = Utilities.getMapRedWork((Configuration)this.getJob()).getPathToPartitionInfo();
                PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, this.inputSplitShim.getPath(0), IOPrepareCache.get().getPartitionDescMap());
                this.inputFormatClassName = part.getInputFileFormatClass().getName();
            }
            out.writeUTF(this.inputFormatClassName);
        }

        @Override
        public void shrinkSplit(long length) {
            this.inputSplitShim.shrinkSplit(length);
        }
    }
}

