/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.persister.collection.CollectionPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedQueryCollectionInitializer
implements CollectionInitializer {
    private final String queryName;
    private final CollectionPersister persister;
    private static final Logger log = LoggerFactory.getLogger((Class)NamedQueryCollectionInitializer.class);

    public NamedQueryCollectionInitializer(String queryName, CollectionPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    public void initialize(Serializable key, SessionImplementor session) throws HibernateException {
        AbstractQueryImpl query;
        if (log.isDebugEnabled()) {
            log.debug("initializing collection: " + this.persister.getRole() + " using named query: " + this.queryName);
        }
        if ((query = (AbstractQueryImpl)session.getNamedSQLQuery(this.queryName)).getNamedParameters().length > 0) {
            query.setParameter(query.getNamedParameters()[0], (Object)key, this.persister.getKeyType());
        } else {
            query.setParameter(0, (Object)key, this.persister.getKeyType());
        }
        query.setCollectionKey(key).setFlushMode(FlushMode.MANUAL).list();
    }
}

