/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.mondrian.MondrianDimension;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.query.MDXElement;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.Locale;

public class MondrianHierarchy
implements Hierarchy,
MDXElement {
    private mondrian.olap.Hierarchy monHierarchy;
    private MondrianDimension dimension;
    private ArrayList aLevels;
    private MondrianModel model;
    private Resources resources;

    public MondrianHierarchy(mondrian.olap.Hierarchy monHierarchy, MondrianDimension dimension, MondrianModel model) {
        this.monHierarchy = monHierarchy;
        this.dimension = dimension;
        this.model = model;
        this.resources = Resources.instance((Locale)model.getLocale(), MondrianHierarchy.class);
        this.aLevels = new ArrayList();
        if (this.newHierarchy(this.getLabel())) {
            dimension.addHierarchy(this);
        }
    }

    private boolean newHierarchy(String hierLabel) {
        Hierarchy[] hierarchies;
        boolean result = true;
        if (hierLabel != null && this.dimension != null && (hierarchies = this.dimension.getHierarchies()) != null) {
            for (int i = 0; i < this.dimension.getHierarchies().length; ++i) {
                if (!hierLabel.equals(hierarchies[i].getLabel())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected void addLevel(MondrianLevel level) {
        this.aLevels.add(level);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Level[] getLevels() {
        return this.aLevels.toArray(new MondrianLevel[0]);
    }

    public String getLabel() {
        String label = this.monHierarchy.getCaption();
        return this.resources.getOptionalString(label, label);
    }

    public void accept(Visitor visitor) {
        visitor.visitHierarchy(this);
    }

    public mondrian.olap.Hierarchy getMonHierarchy() {
        return this.monHierarchy;
    }

    public Object getRootDecoree() {
        return this;
    }

    public String getUniqueName() {
        return this.monHierarchy.getUniqueName();
    }

    public boolean hasAll() {
        return this.monHierarchy.hasAll();
    }

    public Model getModel() {
        return this.model;
    }
}

