#include "vpext.h"

// This file includes the declarations of all the VP functions
// We set them all to zero because we do not know if the card supports
// them yet, if it does we will get the pointers to the functions.

// Simple macro to make it easy to get function pointers
// (credit to Shawn Kirst)
#ifdef WIN32
# define GLPROC(type,func) (func)=(type)wglGetProcAddress(#func)
#else
# define GLPROC(type,func) (func)=(type)glXGetProcAddressARB((GLubyte*)#func)
#endif

#if !defined(sgi) && !defined(__linux__)
PFNGLGENPROGRAMSNVPROC glGenProgramsNV=0;
PFNGLBINDPROGRAMNVPROC glBindProgramNV=0;
PFNGLLOADPROGRAMNVPROC glLoadProgramNV=0;
PFNGLEXECUTEPROGRAMNVPROC glExecuteProgramNV=0;
PFNGLPROGRAMPARAMETER4FNVPROC glProgramParameter4fNV=0;
PFNGLPROGRAMPARAMETER4FVNVPROC glProgramParameter4fvNV=0;
PFNGLPROGRAMPARAMETERS4FVNVPROC glProgramParameters4fvNV=0;
PFNGLTRACKMATRIXNVPROC glTrackMatrixNV=0;
PFNGLDELETEPROGRAMSNVPROC glDeleteProgramsNV=0;
PFNGLAREPROGRAMSRESIDENTNVPROC glAreProgramsResidentNV=0;
PFNGLGETPROGRAMPARAMETERFVNVPROC glGetProgramParameterfvNV=0;
PFNGLGETPROGRAMIVNVPROC glGetProgramivNV=0;
PFNGLGETPROGRAMSTRINGNVPROC glGetProgramStringNV=0;
PFNGLGETTRACKMATRIXIVNVPROC glGetTrackMatrixivNV=0;
PFNGLGETVERTEXATTRIBFVNVPROC glGetVertexAttribfvNV=0;
PFNGLGETVERTEXATTRIBIVNVPROC glGetVertexAttribivNV=0;
PFNGLGETVERTEXATTRIBPOINTERVNVPROC glGetVertexAttribPointerNV=0;
PFNGLISPROGRAMNVPROC glIsProgramNV=0;
PFNGLREQUESTRESIDENTPROGRAMSNVPROC glRequestResidentProgramsNV=0;

PFNGLVERTEXATTRIBPOINTERNVPROC glVertexAttribPointerNV=0;
PFNGLVERTEXATTRIB1FNVPROC glVertexAttrib1fNV=0;
PFNGLVERTEXATTRIB1FVNVPROC glVertexAttrib1fvNV=0;
PFNGLVERTEXATTRIB2FNVPROC glVertexAttrib2fNV=0;
PFNGLVERTEXATTRIB2FVNVPROC glVertexAttrib2fvNV=0;
PFNGLVERTEXATTRIB3FNVPROC glVertexAttrib3fNV=0;
PFNGLVERTEXATTRIB3FVNVPROC glVertexAttrib3fvNV=0;
PFNGLVERTEXATTRIB4FNVPROC glVertexAttrib4fNV=0;
PFNGLVERTEXATTRIB4FVNVPROC glVertexAttrib4fvNV=0;
PFNGLVERTEXATTRIB4UBVNVPROC glVertexAttrib4ubvNV=0;
PFNGLVERTEXATTRIBS1FVNVPROC glVertexAttribs1fvNV=0;
PFNGLVERTEXATTRIBS2FVNVPROC glVertexAttribs2fvNV=0;
PFNGLVERTEXATTRIBS3FVNVPROC glVertexAttribs3fvNV=0;
PFNGLVERTEXATTRIBS4FVNVPROC glVertexAttribs4fvNV=0;
PFNGLVERTEXATTRIBS4UBVNVPROC glVertexAttribs4ubvNV=0;
#endif

//Initializes all of the VP functions
bool InitializeVertexProgramNV()
{
	if (CheckExtension("NV_vertex_program"))
	{
#if !defined(sgi) && !defined(__linux__)
		GLPROC(PFNGLGENPROGRAMSNVPROC,glGenProgramsNV);
		GLPROC(PFNGLBINDPROGRAMNVPROC,glBindProgramNV);
		GLPROC(PFNGLLOADPROGRAMNVPROC,glLoadProgramNV);
		GLPROC(PFNGLEXECUTEPROGRAMNVPROC,glExecuteProgramNV);
		GLPROC(PFNGLPROGRAMPARAMETER4FNVPROC,glProgramParameter4fNV);
		GLPROC(PFNGLPROGRAMPARAMETER4FVNVPROC,glProgramParameter4fvNV);
		GLPROC(PFNGLPROGRAMPARAMETERS4FVNVPROC,glProgramParameters4fvNV);
		GLPROC(PFNGLTRACKMATRIXNVPROC,glTrackMatrixNV);
		GLPROC(PFNGLDELETEPROGRAMSNVPROC,glDeleteProgramsNV);
		GLPROC(PFNGLAREPROGRAMSRESIDENTNVPROC,glAreProgramsResidentNV);
		GLPROC(PFNGLGETPROGRAMPARAMETERFVNVPROC,glGetProgramParameterfvNV);
		GLPROC(PFNGLGETPROGRAMIVNVPROC,glGetProgramivNV);
		GLPROC(PFNGLGETPROGRAMSTRINGNVPROC,glGetProgramStringNV);
		GLPROC(PFNGLGETTRACKMATRIXIVNVPROC,glGetTrackMatrixivNV);
		GLPROC(PFNGLGETVERTEXATTRIBFVNVPROC,glGetVertexAttribfvNV);
		GLPROC(PFNGLGETVERTEXATTRIBIVNVPROC,glGetVertexAttribivNV);
		GLPROC(PFNGLGETVERTEXATTRIBPOINTERVNVPROC,glGetVertexAttribPointerNV);
		GLPROC(PFNGLISPROGRAMNVPROC,glIsProgramNV);
		GLPROC(PFNGLREQUESTRESIDENTPROGRAMSNVPROC,glRequestResidentProgramsNV);

		GLPROC(PFNGLVERTEXATTRIBPOINTERNVPROC,glVertexAttribPointerNV);
		GLPROC(PFNGLVERTEXATTRIB1FNVPROC,glVertexAttrib1fNV);
		GLPROC(PFNGLVERTEXATTRIB1FVNVPROC,glVertexAttrib1fvNV);
		GLPROC(PFNGLVERTEXATTRIB2FNVPROC,glVertexAttrib2fNV);
		GLPROC(PFNGLVERTEXATTRIB2FVNVPROC,glVertexAttrib2fvNV);
		GLPROC(PFNGLVERTEXATTRIB3FNVPROC,glVertexAttrib3fNV);
		GLPROC(PFNGLVERTEXATTRIB3FVNVPROC,glVertexAttrib3fvNV);
		GLPROC(PFNGLVERTEXATTRIB4FNVPROC,glVertexAttrib4fNV);
		GLPROC(PFNGLVERTEXATTRIB4FVNVPROC,glVertexAttrib4fvNV);
		GLPROC(PFNGLVERTEXATTRIB4UBVNVPROC,glVertexAttrib4ubvNV);
		GLPROC(PFNGLVERTEXATTRIBS1FVNVPROC,glVertexAttribs1fvNV);
		GLPROC(PFNGLVERTEXATTRIBS2FVNVPROC,glVertexAttribs2fvNV);
		GLPROC(PFNGLVERTEXATTRIBS3FVNVPROC,glVertexAttribs3fvNV);
		GLPROC(PFNGLVERTEXATTRIBS4FVNVPROC,glVertexAttribs4fvNV);
		GLPROC(PFNGLVERTEXATTRIBS4UBVNVPROC,glVertexAttribs4ubvNV);
#endif
		return true;
	}
	else return false;
}

