#ifndef _PIXELBUFFER_H__
#define _PIXELBUFFER_H__


class PixelBuffer
{
protected:
  // Width in pixels
  int width_;
   // Height in pixels
  int height_;
  // RowInfo structure
  struct RowInfo* rowInfos_;
  // Buffer pointer unaligned
  unsigned int* memUnaligned_;
  // Buffer pointer aligned
  unsigned int* mem_;


public:
	PixelBuffer(int w, int h);
	virtual ~PixelBuffer();
  unsigned int getWidth();
  unsigned int getHeight();
  unsigned int* getRowPointer(int row);
  unsigned int getNumPixels();
  RowInfo* getRowInfo(int row);
  bool isRowCalculated(int row);
  void setRowCalculated(int row, bool calculated);
  int getRowAgent(int row);
  unsigned int getTotalIters(unsigned int maxi, unsigned int iterBlack);
  void setRowAgent(int row, int agent);
  void clearBuffer();
protected:
  void resetRow(int row);
};


#endif
