#include <stdlib.h>
#include <stdio.h>
#include "RowInfo.h"
#include "PixelBuffer.h"

#ifndef NULL
#define NULL 0
#endif

PixelBuffer::PixelBuffer(int w, int h) {
  w = ((w+15)&0xfffff0);
  h = ((h+15)&0xfffff0);
  width_ = 0;
  height_ = 0;
  rowInfos_ = NULL;
  mem_ = NULL;
  int npixel = w*h;
  memUnaligned_ = (unsigned int*) malloc((npixel+16) * sizeof(unsigned int));
  mem_ = (unsigned int*) ((((unsigned long)memUnaligned_) + 15) & (~0xf));
  rowInfos_ = (RowInfo*) malloc(h * sizeof(RowInfo));
  if ((memUnaligned_ == NULL) && (rowInfos_ == NULL)) {
    printf("ERROR: Failed to allocate pixel buffer\n");
    width_ = 0;
    height_ = 0;
  }
  else {
    width_ = w;
    height_ = h;
  }
}

PixelBuffer::~PixelBuffer() {
  if (memUnaligned_ != NULL) free(memUnaligned_);
  if (rowInfos_ != NULL) free(rowInfos_);
}

unsigned int PixelBuffer::getWidth() {
  return width_;
}

unsigned int PixelBuffer::getHeight() {
  return height_;
}

unsigned int PixelBuffer::getNumPixels() {
  return width_ * height_;
}

unsigned int* PixelBuffer::getRowPointer(int row) {
  //printf("%p\n",&mem_[row*width_]);
  if (mem_ == NULL) return NULL;
  else return (&mem_[row*width_]);
}

RowInfo* PixelBuffer::getRowInfo(int row) {
  if (rowInfos_ == NULL) return NULL;
  else return (rowInfos_ + row);
}

bool PixelBuffer::isRowCalculated(int row) {
  RowInfo* ri = getRowInfo(row);
  if (ri == NULL) return false;
  else return ri->calculated;
}

void PixelBuffer::setRowCalculated(int row, bool calculated) {
  RowInfo* ri = getRowInfo(row);
  if (ri == NULL) return;
  else ri->calculated = calculated;
}

int PixelBuffer::getRowAgent(int row) {
  RowInfo* ri = getRowInfo(row);
  if (ri == NULL) return ROW_AGENT_NONE;
  else return ri->agent;
}

void PixelBuffer::setRowAgent(int row, int agent) {
  RowInfo* ri = getRowInfo(row);
  if (ri == NULL) return;
  else ri->agent = agent;
}

void PixelBuffer::resetRow(int row) {
  setRowCalculated(row, false);
  setRowAgent(row, ROW_AGENT_NONE);
}

unsigned int PixelBuffer::getTotalIters(unsigned int maxi, unsigned int iterBlack) {
  unsigned int tot = 0;
  unsigned int* rowP;
  unsigned int iters;
  for (int y=0; y<height_; y++) {
    if (!isRowCalculated(y)) continue;
    rowP = PixelBuffer::getRowPointer(y);
    for (int x=0; x<width_; x++) {
      iters = *rowP++;
      if (iters == iterBlack) iters = maxi;
      tot += iters;
    }
  }
  return tot;
}

void PixelBuffer::clearBuffer() {
  unsigned int* p = mem_;
  for (int i=0; i<width_*height_; i++) *p++ = 0;
}
