#pragma once

#if defined(__APPLE__)
  #include <OpenGL/gl.h>
  #include <OpenGL/glu.h>
  #include <GLUT/glut.h>
#elif defined(__linux__)
  #define GL_GLEXT_PROTOTYPES
  #include <GL/glut.h>
#else
  #include <GL/glut.h>
#endif

/**
 * Abstract class for a Mandelbrot GPU Program
 * Author: Daniele Paccaloni
 */
class GPUProgram
{
protected:
  int iters_;
  GLint maxInstr_; // Maximum number of GPU program instructions (-1 if unknown)

public:
  GPUProgram(int iters, int w, int h, double ax, double ay, double ex, double ey);
  virtual ~GPUProgram(void);
  // Get number of iterations
  int getIters(void) { return iters_; };
  // Set number of iterations
  void setIters(int iters) { iters_ = iters; };
  // Check if the Vertex Program is supported by the hardware
  virtual bool isValid(void) = 0;
  // Initialize the Vertex Program
  virtual bool initialize(int iters, int w, int h, double ax, double ay, double ex, double ey) = 0;
  // Prepare the world coords space
  virtual void prepareWorldSpace(int w, int h, double ax, double ay, double ex, double ey) = 0;
  // Update the Vertex Program to use the current 2D proj matrix
  virtual bool setOrtho2D(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top) = 0;
  // Check for required extensions
  virtual bool checkRequiredExtensions(void) = 0;
};
