#pragma once

#include "FragmentProgram.h"

/**
 * Class for Mandelbrot using ARB Fragment Program
 * Author: Daniele Paccaloni
 */
class FragmentProgramARB10 : public FragmentProgram
{
protected:
  bool isValid_;
  bool usingR3xx_;
  GLuint fpid_;  // Fragment Program id
  GLuint texid_; // Texture id

public:
  FragmentProgramARB10(int iters, int w, int h, double ax, double ay, double ex, double ey);
  virtual ~FragmentProgramARB10(void);
  virtual bool isValid(void) { return isValid_; }
  virtual bool initialize(int iters, int w, int h, double ax, double ay, double ex, double ey);
  virtual bool setOrtho2D(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top);
  virtual void prepareWorldSpace(int w, int h, double ax, double ay, double ex, double ey);
  virtual bool checkRequiredExtensions(void);
protected:
  bool initializeGPU_FP(int iters, int w, int h, double ax, double ay, double ex, double ey);
  bool createTexture(void);
};

