/*
 * Decompiled with CFR 0.152.
 */
package com.horobi.relax;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.Attlist;
import com.ibm.xml.parser.CM1op;
import com.ibm.xml.parser.CM2op;
import com.ibm.xml.parser.CMLeaf;
import com.ibm.xml.parser.CMNode;
import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.Parser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class DTD2RELAXParser {
    public static final String RELAX_XMLNS = "http://www.xml.gr.jp/xmlns/relaxCore";
    DocumentHandler handler;
    Vector elementTypes;
    Hashtable attLists;
    DTD dtd;
    String finalElementType;
    AttributeListImpl attBuffer = new AttributeListImpl();
    boolean any = false;

    DTD2RELAXParser() {
        this.elementTypes = new Vector();
        this.attLists = new Hashtable();
    }

    protected void addAttribute(String aname, String type, String value) {
        this.attBuffer.addAttribute(aname, type, value);
    }

    protected void endDocument() throws SAXException {
        if (this.handler != null) {
            this.handler.endDocument();
        }
    }

    protected void endElement(String ename) throws SAXException {
        if (this.handler != null) {
            this.handler.endElement(ename);
        }
    }

    String getDatatype(AttDef attdef) {
        switch (attdef.getDeclaredType()) {
            case 1: {
                return "string";
            }
            case 6: {
                return "ENTITIES";
            }
            case 5: {
                return "ENTITY";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 10: {
                return "NMTOKEN";
            }
            case 7: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 9: {
                return "NOTATION";
            }
        }
        return "";
    }

    boolean isMixedContent(CMNode cmnd) {
        if (cmnd instanceof CMLeaf) {
            CMLeaf cmlf = (CMLeaf)cmnd;
            return cmlf.getName() == "#PCDATA";
        }
        if (cmnd instanceof CM2op) {
            CM2op cm2 = (CM2op)cmnd;
            if (cm2.getType() == 124) {
                return this.isMixedContent(cm2.getLeft());
            }
            return false;
        }
        return false;
    }

    boolean isPCDATA(CMNode cmnd) {
        String pcdataname = "#PCDATA";
        if (cmnd instanceof CMLeaf) {
            String cmlf_name = ((CMLeaf)cmnd).getName();
            if (pcdataname.equals(cmlf_name)) {
                return true;
            }
        } else if (cmnd instanceof CM1op) {
            String cmlf_child_name;
            CM1op cm1op = (CM1op)cmnd;
            CMNode cmnd_child = cm1op.getNode();
            if (cm1op.getType() == 42 && cmnd_child instanceof CMLeaf && pcdataname.equals(cmlf_child_name = ((CMLeaf)cmnd_child).getName())) {
                return true;
            }
        }
        return false;
    }

    public void parse(String inputFilename) throws SAXException, IOException, FileNotFoundException {
        FileInputStream is = new FileInputStream(inputFilename);
        this.dtd = new Parser(inputFilename).readDTDStream(is);
        if (this.dtd == null) {
            throw new RuntimeException("no DTD.");
        }
        this.startDocument();
        this.addAttribute("moduleVersion", "CDATA", "1.0");
        this.addAttribute("relaxCoreVersion", "CDATA", "1.0");
        this.addAttribute("xmlns", "CDATA", RELAX_XMLNS);
        this.startElement("module");
        this.startElement("interface");
        this.addAttribute("label", "CDATA", this.finalElementType);
        this.startElement("export");
        this.endElement("export");
        this.endElement("interface");
        Enumeration en = this.dtd.externalElements();
        while (en.hasMoreElements()) {
            Child cld = (Child)en.nextElement();
            switch (cld.getNodeType()) {
                case 20: {
                    ElementDecl ed = (ElementDecl)cld;
                    this.elementTypes.addElement(ed.getName());
                    this.printRule(ed);
                    break;
                }
                case 21: {
                    Attlist al = (Attlist)cld;
                    Vector<Attlist> v = (Vector<Attlist>)this.attLists.get(al.getName());
                    if (v == null) {
                        v = new Vector<Attlist>();
                        this.attLists.put(al.getName(), v);
                    }
                    v.addElement(al);
                    break;
                }
            }
        }
        this.printImplicitTags();
        this.printTags();
        this.printAny();
        this.endElement("module");
        this.endDocument();
    }

    void printATag(String edname, Vector atts) throws SAXException {
        this.addAttribute("name", "CDATA", edname);
        this.startElement("tag");
        int n = atts.size();
        int i = 0;
        while (i < n) {
            Attlist al = (Attlist)atts.elementAt(i);
            int m = al.size();
            int j = 0;
            while (j < m) {
                AttDef attdef = al.elementAt(j);
                this.printAttDef(attdef);
                ++j;
            }
            ++i;
        }
        this.endElement("tag");
    }

    void printAny() throws SAXException {
        if (this.any) {
            this.addAttribute("label", "CDATA", "any");
            this.startElement("hedgeRule");
            this.startElement("choice");
            Enumeration e = this.elementTypes.elements();
            while (e.hasMoreElements()) {
                String elem_name = (String)e.nextElement();
                this.addAttribute("label", "CDATA", elem_name);
                this.startElement("ref");
                this.endElement("ref");
            }
            this.endElement("choice");
            this.endElement("hedgeRule");
        }
    }

    void printAttDef(AttDef attdef) throws SAXException {
        this.addAttribute("name", "CDATA", attdef.getName());
        switch (attdef.getDefaultType()) {
            case 2: {
                this.addAttribute("required", "NMTOKEN", "true");
                break;
            }
        }
        String type = this.getDatatype(attdef);
        if (type.length() > 0) {
            this.addAttribute("type", "NMTOKEN", type);
        }
        this.startElement("attribute");
        if (attdef.getDeclaredType() == 10) {
            this.printEnumeration(attdef);
        }
        this.endElement("attribute");
    }

    void printContentModel(CM1op cm1) throws SAXException {
        String occurrenceIndicator = "";
        if (cm1.getType() == 42) {
            occurrenceIndicator = "*";
        } else if (cm1.getType() == 43) {
            occurrenceIndicator = "+";
        } else if (cm1.getType() == 63) {
            occurrenceIndicator = "?";
        } else {
            throw new SAXException("henda printContentModel(CM1op");
        }
        this.printContentModel(cm1.getNode(), occurrenceIndicator);
    }

    void printContentModel(CM2op cm2, String occurrenceIndicator) throws SAXException {
        if (cm2.getType() == 124) {
            if (occurrenceIndicator.length() > 0) {
                this.addAttribute("occurs", "CDATA", occurrenceIndicator);
            }
            this.startElement("choice");
            this.printContentModelInChoice(cm2.getLeft(), "");
            this.printContentModel(cm2.getRight(), "");
            this.endElement("choice");
        } else if (cm2.getType() == 44) {
            if (occurrenceIndicator.length() > 0) {
                this.addAttribute("occurs", "CDATA", occurrenceIndicator);
            }
            this.startElement("sequence");
            this.printContentModelInSequence(cm2.getLeft(), "");
            this.printContentModel(cm2.getRight(), "");
            this.endElement("sequence");
        } else {
            throw new SAXException("henda printContentModel(CM2op");
        }
    }

    void printContentModel(CMLeaf cmlf, String occurrenceIndicator) throws SAXException {
        String cmlfname = cmlf.getName();
        this.addAttribute("label", "CDATA", cmlfname);
        if (occurrenceIndicator.length() > 0) {
            this.addAttribute("occurs", "CDATA", occurrenceIndicator);
        }
        this.startElement("ref");
        this.endElement("ref");
    }

    void printContentModel(CMNode cmnd, String occurrenceIndicator) throws SAXException {
        if (cmnd instanceof CMLeaf) {
            CMLeaf cmlf = (CMLeaf)cmnd;
            this.printContentModel(cmlf, occurrenceIndicator);
        } else if (this.isMixedContent(cmnd)) {
            this.startElement("mixed");
            this.addAttribute("occurs", "CDATA", "*");
            this.startElement("choice");
            this.printMixedContent(cmnd);
            this.endElement("choice");
            this.endElement("mixed");
        } else if (cmnd instanceof CM1op) {
            CM1op cm1 = (CM1op)cmnd;
            this.printContentModel(cm1);
        } else if (cmnd instanceof CM2op) {
            CM2op cm2 = (CM2op)cmnd;
            this.printContentModel(cm2, occurrenceIndicator);
        } else {
            throw new SAXException("invalid content model");
        }
    }

    void printContentModelInChoice(CM2op cm2, String occurrenceIndicator) throws SAXException {
        if (cm2.getType() == 124) {
            this.printContentModelInChoice(cm2.getLeft(), "");
            this.printContentModelInChoice(cm2.getRight(), "");
        } else {
            this.printContentModel(cm2, occurrenceIndicator);
        }
    }

    void printContentModelInChoice(CMNode cmnd, String occurrenceIndicator) throws SAXException {
        if (cmnd instanceof CM2op) {
            CM2op cm2 = (CM2op)cmnd;
            this.printContentModelInChoice(cm2, occurrenceIndicator);
            return;
        }
        this.printContentModel(cmnd, occurrenceIndicator);
    }

    void printContentModelInSequence(CM2op cm2, String occurrenceIndicator) throws SAXException {
        if (cm2.getType() == 44) {
            this.printContentModelInSequence(cm2.getLeft(), "");
            this.printContentModelInSequence(cm2.getRight(), "");
        } else {
            this.printContentModel(cm2, occurrenceIndicator);
        }
    }

    void printContentModelInSequence(CMNode cmnd, String occurrenceIndicator) throws SAXException {
        if (cmnd instanceof CM2op) {
            CM2op cm2 = (CM2op)cmnd;
            this.printContentModelInSequence(cm2, occurrenceIndicator);
            return;
        }
        this.printContentModel(cmnd, occurrenceIndicator);
    }

    void printEnumeration(AttDef attdef) throws SAXException {
        Enumeration en = attdef.elements();
        while (en.hasMoreElements()) {
            String val = (String)en.nextElement();
            this.addAttribute("value", "CDATE", val);
            this.startElement("enumeration");
            this.endElement("enumeration");
        }
    }

    void printImplicitTags() throws SAXException {
        Enumeration e = this.elementTypes.elements();
        while (e.hasMoreElements()) {
            String elem_name = (String)e.nextElement();
            if (this.attLists.containsKey(elem_name)) continue;
            this.addAttribute("name", "CDATA", elem_name);
            this.startElement("tag");
            this.endElement("tag");
        }
    }

    void printMixedContent(CMNode cmnd) throws SAXException {
        CMLeaf cmlf;
        if (cmnd instanceof CM2op) {
            CM2op cm2 = (CM2op)cmnd;
            this.printMixedContent(cm2.getLeft());
            this.printMixedContent(cm2.getRight());
        } else if (cmnd instanceof CMLeaf && (cmlf = (CMLeaf)cmnd).getName() != "#PCDATA") {
            this.printContentModel(cmlf, "");
        }
    }

    void printRule(ElementDecl ed) throws SAXException {
        String edname = ed.getName();
        this.addAttribute("role", "CDATA", edname);
        switch (this.dtd.getContentType(edname)) {
            case 0: {
                System.err.println("???");
                return;
            }
            case 1: {
                this.startElement("elementRule");
                this.startElement("empty");
                this.endElement("empty");
                break;
            }
            case 2: {
                this.any = true;
                this.startElement("elementRule");
                this.startElement("mixed");
                this.addAttribute("label", "CDATA", "any");
                this.addAttribute("occurs", "CDATA", "*");
                this.startElement("hedgeRef");
                this.endElement("hedgeRef");
                this.endElement("mixed");
                break;
            }
            case 4: {
                CMNode cmnd = this.dtd.getContentModel(edname).getContentModelNode();
                if (this.isPCDATA(cmnd)) {
                    this.addAttribute("type", "NMTOKEN", "string");
                    this.startElement("elementRule");
                    break;
                }
                this.startElement("elementRule");
                this.printContentModel(cmnd, "");
            }
        }
        this.endElement("elementRule");
    }

    void printTags() throws SAXException {
        int n = this.elementTypes.size();
        int i = 0;
        while (i < n) {
            String edname = (String)this.elementTypes.elementAt(i);
            Vector v = (Vector)this.attLists.get(this.elementTypes.elementAt(i));
            if (v != null) {
                this.printATag(edname, v);
            }
            ++i;
        }
    }

    public void setDocumentHandler(DocumentHandler aHandler) {
        this.handler = aHandler;
    }

    void setFinalElementType(String aType) {
        this.finalElementType = aType;
    }

    protected void startDocument() throws SAXException {
        if (this.handler != null) {
            this.handler.startDocument();
        }
    }

    protected void startElement(String ename) throws SAXException {
        if (this.handler != null) {
            this.handler.startElement(ename, this.attBuffer);
        }
        this.attBuffer.clear();
    }
}

