/*
 * Decompiled with CFR 0.152.
 */
package com.horobi.relax;

import com.horobi.relax.DTD2RELAXParser;
import com.horobi.relax.EasyRELAXPrinter;
import com.horobi.relax.SAXPrinter;
import com.ibm.xml.parser.MIME2Java;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.SAXException;

public class DTD2RELAX {
    static String encoding = "utf-8";
    static final String RELAX_XMLNS = "http://www.xml.gr.jp/xmlns/relaxCore";
    static final String VERSION = "1.1.1";
    static final String PRINTER_KEY = "com.horobi.relax.printer";

    public static String convertEncoding(String mimeEnc) {
        String javaEnc = MIME2Java.convert(mimeEnc);
        if (javaEnc == null && mimeEnc.equalsIgnoreCase("UTF-16")) {
            javaEnc = "Unicode";
        }
        return javaEnc;
    }

    static int getOptions(String[] args) {
        int i = 0;
        while (i < args.length && args[i].charAt(0) == '-') {
            if (args[i].equals("-e")) {
                encoding = args[++i];
            }
            ++i;
        }
        return i;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static void main(String[] args) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        PrintWriter os;
        int shift = DTD2RELAX.getOptions(args);
        if (args.length - shift < 2 || args.length - shift > 3) {
            DTD2RELAX.usage();
            return;
        }
        String inputFilename = args[shift];
        String outputFilename = null;
        String topLevelElement = null;
        if (args.length - shift == 2) {
            topLevelElement = args[1 + shift];
        } else {
            outputFilename = args[1 + shift];
            topLevelElement = args[2 + shift];
        }
        if (inputFilename == null) {
            System.err.println("Specify a DTD file name.");
            return;
        }
        String javaenc = DTD2RELAX.convertEncoding(encoding);
        if (javaenc == null) {
            System.err.println("unsupported encoding: '" + encoding + "'");
            return;
        }
        if (outputFilename != null) {
            FileOutputStream fos = new FileOutputStream(outputFilename);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, javaenc);
            os = new PrintWriter(osw);
        } else {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)System.out, javaenc);
            os = new PrintWriter(osw);
        }
        try {
            DTD2RELAX.printSchema(inputFilename, topLevelElement, os, encoding);
        }
        catch (SAXException e) {
            System.err.println(e);
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    static void printSchema(String inputFilename, String topLevelElement, PrintWriter writer, String encoding) throws SAXException, RuntimeException, FileNotFoundException, IOException {
        SAXPrinter printer;
        DTD2RELAXParser dtd2relax = new DTD2RELAXParser();
        dtd2relax.setFinalElementType(topLevelElement);
        String printerClass = System.getProperty(PRINTER_KEY);
        if (printerClass != null) {
            try {
                printer = (SAXPrinter)Class.forName(printerClass).newInstance();
                printer.setWriter(writer);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        } else {
            printer = new EasyRELAXPrinter(writer);
        }
        dtd2relax.setDocumentHandler(printer);
        if (encoding != null && encoding.length() > 0) {
            writer.print("<?xml version=\"1.0\" ");
            writer.println("encoding=\"" + encoding + "\"?>");
        }
        writer.println("<!-- generated by DTD2RELAX 1.1.1 -->");
        dtd2relax.parse(inputFilename);
        writer.close();
    }

    static void usage() {
        System.err.println("java com.horobi.relax.DTD2RELAX [-e encoding] dtdFile [relaxFile] topLevelElem");
    }
}

