/*
 * Decompiled with CFR 0.152.
 */
package com.horobi.relax;

import com.horobi.relax.FileConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;

public class ConverterPanel
extends JPanel {
    FileConverter converter;
    JButton open;
    JButton convert;
    JLabel fromLabel;
    JLabel toLabel;
    JLabel toLabel2;
    JLabel message;
    JFileChooser chooser;
    Timer timer;
    File src;
    File dst;
    OptionValue[] optionValues;

    public ConverterPanel(FileConverter aConverter) {
        this.converter = aConverter;
        this.chooser = new JFileChooser(".");
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return ConverterPanel.this.converter.accept(f);
            }

            public String getDescription() {
                return ConverterPanel.this.converter.getInputFileDescription();
            }
        };
        this.chooser.addChoosableFileFilter(filter);
        this.chooser.setFileFilter(filter);
        GridBagLayout gb = new GridBagLayout();
        JPanel center = new JPanel(gb);
        GridBagConstraints c = new GridBagConstraints();
        this.open = new JButton("Open...");
        this.open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConverterPanel.this.open();
            }
        });
        this.fromLabel = new JLabel("From: ");
        this.toLabel = new JLabel("To: ");
        this.toLabel2 = new JLabel("");
        this.convert = new JButton("Start");
        this.convert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConverterPanel.this.convert();
            }
        });
        this.convert.setEnabled(false);
        this.message = new JLabel(this.converter.getName());
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = -1;
        ConverterPanel.add(center, this.fromLabel, gb, c);
        c.fill = 0;
        c.anchor = 13;
        c.gridwidth = 0;
        ConverterPanel.add(center, this.open, gb, c);
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridwidth = -1;
        ConverterPanel.add(center, this.toLabel, gb, c);
        c.fill = 2;
        c.anchor = 13;
        c.gridwidth = 0;
        ConverterPanel.add(center, this.toLabel2, gb, c);
        ConverterPanel.add(center, this.createOptionUI(), gb, c);
        c.anchor = 17;
        ConverterPanel.add(center, this.convert, gb, c);
        this.setLayout(new BorderLayout());
        this.add("Center", center);
        this.add("South", this.message);
    }

    static void add(JPanel panel, Component component, GridBagLayout gb, GridBagConstraints c) {
        gb.setConstraints(component, c);
        panel.add(component);
    }

    public void convert() {
        this.start();
        new Thread(new Runner()).start();
    }

    protected JPanel createOptionUI() {
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel options = new JPanel(gb);
        String[] names = this.converter.getOptionNames();
        Object[] defaults = this.converter.getOptionDefaults();
        int n = names.length;
        this.optionValues = new OptionValue[n];
        int i = 0;
        while (i < n) {
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 17;
            c.gridwidth = -1;
            JLabel label = new JLabel(String.valueOf(names[i]) + ": ");
            ConverterPanel.add(options, label, gb, c);
            c.weightx = 1.0;
            c.fill = 2;
            c.gridwidth = 0;
            c.anchor = 13;
            if (defaults[i] instanceof String) {
                JTextField text = new JTextField((String)defaults[i]);
                ConverterPanel.add(options, text, gb, c);
                this.optionValues[i] = new OptionValue(this, text){

                    String getValue() {
                        return ((JTextField)this.object).getText();
                    }
                };
            } else if (defaults[i] instanceof String[]) {
                JComboBox<Object> combo = new JComboBox<Object>((Object[])defaults[i]);
                combo.setEditable(true);
                ConverterPanel.add(options, combo, gb, c);
                this.optionValues[i] = new OptionValue(this, combo){

                    String getValue() {
                        return (String)((JComboBox)this.object).getEditor().getItem();
                    }
                };
            }
            ++i;
        }
        return options;
    }

    public void open() {
        int opt = this.chooser.showOpenDialog(this);
        if (opt == 0) {
            this.src = this.chooser.getSelectedFile();
            String output = this.converter.getOutputFileName(this.src);
            this.dst = new File(String.valueOf(this.src.getParent()) + File.separator + output);
            this.fromLabel.setText("From: " + this.src.getName());
            this.toLabel2.setText(output);
            this.convert.setEnabled(true);
            this.repaint();
        }
    }

    protected void start() {
        this.open.setEnabled(false);
        this.convert.setEnabled(false);
        this.timer = new Timer(100, new ActionListener(){
            int t = 0;

            public void actionPerformed(ActionEvent ae) {
                ConverterPanel.this.message.setText("converting... " + "-\\|/".charAt(this.t++ % 4));
                ConverterPanel.this.message.repaint();
            }
        });
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(0);
        this.timer.start();
    }

    protected void stop(String msg) {
        this.timer.stop();
        this.timer = null;
        this.message.setText(msg);
        this.open.setEnabled(true);
        this.convert.setEnabled(true);
    }

    class Runner
    implements Runnable {
        Runner() {
        }

        public void run() {
            String[] options = new String[ConverterPanel.this.optionValues.length];
            int i = 0;
            while (i < ConverterPanel.this.optionValues.length) {
                options[i] = ConverterPanel.this.optionValues[i].getValue();
                ++i;
            }
            try {
                try {
                    ConverterPanel.this.converter.convert(ConverterPanel.this.src, ConverterPanel.this.dst, options);
                    ConverterPanel.this.stop("done.");
                }
                catch (Exception e) {
                    ConverterPanel.this.stop(e.getMessage());
                }
                Object var4_4 = null;
                ConverterPanel.this.repaint();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ConverterPanel.this.repaint();
                throw throwable;
            }
        }
    }

    abstract class OptionValue {
        Object object;

        OptionValue(Object obj) {
            this.object = obj;
        }

        abstract String getValue();
    }
}

