/*
 * Created on 6 sept. 2003
 *
 */
package org.gudy.azureus2.irc;

import org.jibble.pircbot.Colors;
import org.jibble.pircbot.PircBot;
import org.jibble.pircbot.User;

import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.*;

import java.net.*;
import java.io.*;
import java.util.Arrays;
import java.util.Locale;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.plugins.dht.DHTPlugin;

import org.gudy.azureus2.plugins.utils.*;

/**
 * @author Olivier
 * 
 */

public class 
IrcClient 
	extends PircBot 
{
	public static final String	CONFIG_IRC_SERVER 			= "Irc Server";
	public static final String	CONFIG_IRC_SERVER_DEFAULT	= "irc.freenode.net";
	
	public static final String	CONFIG_IRC_CHANNEL			= "Irc Channel";
	public static final String	CONFIG_IRC_CHANNEL_DEFAULT	= "#azureus-users";
	
	public static final String	CONFIG_IRC_USER				= "Irc Login";
	public static final String	CONFIG_IRC_USER_DEFAULT		= "";
	
	public static final String	CONFIG_IRC_SEND_USER_INFO				= "Irc User Info";
	public static final boolean	CONFIG_IRC_SEND_USER_INFO_DEFAULT		= true;
	
	public static final String	CONFIG_IRC_LOG				= "Irc Log";
	public static final boolean	CONFIG_IRC_LOG_DEFAULT		= false;
	
	private PluginInterface		plugin_interface;
	private PluginConfig		plugin_config;
	private PluginManager		plugin_manager;
	private LocaleUtilities 	locale_utils;
	
  private String srvName;
  private String channel;
  private String azVersion;
  private IrcListener listener;
  private String userName;
  private String static_id;
   
  public 
  IrcClient(
  	PluginInterface	_plugin_interface,
	IrcListener 	_listener)
  {    
  	plugin_interface	= _plugin_interface;
  	listener = _listener;
  	
  	locale_utils = plugin_interface.getUtilities().getLocaleUtilities();
 	
  	plugin_config = plugin_interface.getPluginconfig();
  	
  	plugin_manager = plugin_interface.getPluginManager();
  	
  	azVersion = plugin_interface.getAzureusVersion();

  	
  	srvName 	= plugin_config.getPluginStringParameter(CONFIG_IRC_SERVER, CONFIG_IRC_SERVER_DEFAULT );
  	channel 	= plugin_config.getPluginStringParameter(CONFIG_IRC_CHANNEL, CONFIG_IRC_CHANNEL_DEFAULT );
  	userName 	= plugin_config.getPluginStringParameter(CONFIG_IRC_USER, CONFIG_IRC_USER_DEFAULT);
  	
  	/*if(channel.equals("")) {
  		//listener.systemMessage(LOCALE_CURRENT.getDefault().toString());
  		if (LOCALE_CURRENT.getDefault().toString().equals("es_ES")) {
  			channel = "#Azureus-Espanol";
  		} else if (LOCALE_CURRENT.getDefault().toString().equals("de_DE")) {
  			channel = "#Azureus-German";
  		} else if (LOCALE_CURRENT.getDefault().toString().equals("fi_FI")) {
  			channel = "#Azureus-Finnish";
  		} else if (LOCALE_CURRENT.getDefault().toString().equals("fr_FR")) {
  			channel = "#Azureus-French";
  		} else if (LOCALE_CURRENT.getDefault().toString().equals("pl_PL")) {
  			channel = "#Azureus-Polish";
  		} else if (LOCALE_CURRENT.getDefault().toString().equals("no_NO")) {
  			channel = "#Azureus-Norwegian";
  		} else if ((LOCALE_CURRENT.getDefault().toString().equals("pt_BR") || (LOCALE_CURRENT.getDefault().toString().equals("pt_PT")))) {
  			channel = "#Azureus-Portugues";
  		} else {
  			channel = "#Azureus-Users";
  		}
  	}*/
  	
  	if(userName.equals("")) {
  		listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.noNick"));
  		return;
  	}
    
  	static_id = plugin_config.getStringParameter( "ID", "        " ).substring( 0, 8 );  //first chars of the client instance id

    String az_version = azVersion;
    az_version = az_version.replaceAll("_", "" );
    az_version = az_version.replaceAll("\\.", "" );
    
    setName( userName ); //also sets NICK
    setLogin( static_id );
    setVersion( "AZ" +az_version+ "|" +static_id+ "|" +getVersion() );
    
    
    Thread t = new Thread() {
      /* (non-Javadoc)
       * @see java.lang.Thread#run()
       */
      public void run() {
        try {                  
          listener.systemMessage("");  
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.copyright"));
          listener.systemMessage("");
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.connecting") + " " + srvName);
          connect(srvName);
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.connected") + " " + srvName);
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.joining") + " " + channel);
          joinChannel(channel);
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.channel") + " " + channel + " " +  locale_utils.getLocalisedMessageText("IrcClient.joined"));
        }
        catch (Exception e) {
          //e.printStackTrace();
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.error") + " : " + e.getMessage());
        }
      }
    };
    t.setDaemon(true);
    t.start();
  }
  protected void onMessage(String channel, String sender, String login, String hostname, String message) {
    if(listener != null) {
      listener.messageReceived(sender,Colors.removeFormattingAndColors(message));
    }
  }
  
  public void close() {    
    super.quitServer( plugin_interface.getAzureusName() + " " + plugin_interface.getAzureusVersion());
    try {
      super.dispose();
    } catch(Exception e) {
      
    }
  }
  
  public void sendMessage(String message) {
	  if ((message.startsWith("!")) || (message.startsWith("@"))){
		  listener.notice("WARNING", "Do not use ! and @ triggers here, there are NO files - read the topic and http://azureus.aelitis.com/wiki/index.php/Rules_for_IRC");
	  }
	  else {
		  super.sendMessage(channel,message);
		  listener.messageReceived(userName,message);	
	  }
  }
  
  
  protected void onJoin(String channel, String sender, String login, String hostname) {
    listener.systemMessage(sender + " " + locale_utils.getLocalisedMessageText("IrcClient.hasjoined")  + (sender.equals(userName)?" " + channel:""));
    listener.clientEntered(sender);
  }
  
  protected void onKick(String channel, String kickerNick, String kickerLogin, String kickerHostname, String recipientNick, String reason) {
    listener.systemMessage(kickerNick + " " + locale_utils.getLocalisedMessageText("IrcClient.haskicked") + " " + recipientNick + " (" + reason + ").");
    listener.clientExited(recipientNick);
	  if (recipientNick.equals(userName)){
		    listener.notice("WARNING", "You are no longer in the channel as you have been kicked (" + reason + ") Please respect the rules... http://azureus.aelitis.com/wiki/index.php/Rules_for_IRC");
		    listener.allExited();
		  }
  }
  
  protected void onQuit(String sourceNick, String sourceLogin, String sourceHostname, String reason) {
    listener.systemMessage(sourceNick + " " + locale_utils.getLocalisedMessageText("IrcClient.hasleft") + " (" + reason + ").");
    listener.clientExited(sourceNick);
  }
  
  protected void onPart(String channel, String sender, String login, String hostname)  {
    listener.systemMessage(sender + " " + locale_utils.getLocalisedMessageText("IrcClient.hasleft")  + (sender.equals(userName)?" " + channel:""));
    listener.clientExited(sender);
  }
  
  
  protected void onNickChange(String oldNick, String login, String hostname, String newNick) 
  {
    listener.systemMessage(oldNick + " " + locale_utils.getLocalisedMessageText("IrcClient.nowknown") + " " + newNick);
    listener.clientExited(oldNick);
    listener.clientEntered(newNick);
  }
  
  protected void onAction(String sender, String login, String hostname, String target, String action) 
  {
    listener.action(sender,action);
  }
  
  /**
   * @return
   */
  public String getUserName() {
    return userName;
  }

  /**
   * @param userName
   */
  public void setUserName(String _userName) {
	  if (! _userName.startsWith("`") && ! _userName.startsWith("") && ! _userName.startsWith("|") && ! _userName.startsWith("[") && ! _userName.startsWith("]") && ! _userName.startsWith("_") && ! _userName.startsWith("^")){
		    userName = _userName;
		    plugin_config.setPluginParameter(CONFIG_IRC_USER, userName);
		    changeNick(userName);		  
	  }
	  else{
		listener.notice("WARNING", "Your nick was not changed as it would have made responding to you more difficult, Please choose one containing only alphanumerc characters... http://azureus.aelitis.com/wiki/index.php/Rules_for_IRC");
	  }
  }
  
  public void sendAction(String action) {
    super.sendAction(channel,action);
  }
  
  protected void onUserList(String channel, User[] users) {
    if(! this.channel.equals(channel))
       return;
    for(int i = 0 ; i < users.length ;i++) {
      listener.clientEntered(users[i].getNick());
    }    
  }
  
  protected void onPrivateMessage(String sender, String login, String hostname, String message)
  {
    listener.privateMessage(sender,message);
  }
  
  protected void onNotice(String sourceNick, String sourceLogin, String sourceHostname, String target, String notice)
  {
	if ((! notice.contains("[Global Notice]")) && (! sourceNick.equals("NickServ")))
	{
		listener.notice(sourceNick,notice);
	}
  } 
  
  protected void onServerResponse(int code, String response)  {
    String st[];

    switch (code)
    {
      //No such nick name:
      case ERR_NOSUCHNICK:
	listener.systemMessage(response);
	break;

      case RPL_WHOISIDLE:
	st = response.split(" ");
	listener.systemMessage("\t==> Idle: " + st[2] + " sec, Sign-on: " +
	  st[3]);
	break;

/*
      default:
	listener.privateMessage("Server: ", response);
*/
    }
  }

  /**
   * Tests if a given user is a channel op.
   * @param nick The user's nick.
   * @return true of the user is a channel op, false otherwise. 
   */
  public boolean isChanelOp(String nick)
  {
    User[] users = getUsers(channel);
    int i;

    for (i = 0; i < users.length; i++)
	if (users[i].getNick().equalsIgnoreCase(nick) && users[i].isOp())
	    return true;

    return false;
  }
  
  public boolean isChanelVoice(String nick)
  {
    User[] users = getUsers(channel);
    int i;

    for (i = 0; i < users.length; i++)
	if (users[i].getNick().equalsIgnoreCase(nick) && users[i].hasVoice())
	    return true;

    return false;
  }
  
  protected void onTopic(String channel, String topic, String setBy, long date, boolean changed) {
    listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.topicforchannel") + " " + channel + " : " + topic);
  }
  
  protected void onDisconnect() {
    listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.disconnected") + " " + srvName);
  }
  
  /**
   * @return
   */
  public String getChannel() {
    return channel;
  }

  /**
   * @return
   */
  public String getSrvName() {
    return srvName;
  }
  
  public void changeChannel(String channel) {
	    partChannel(this.channel);    
	    User[] users = super.getUsers(this.channel);
	    for(int i=0 ; i< users.length ; i++) {
	      listener.clientExited(users[i].getNick());
	    }
	    this.channel = channel;
	    //plugin_config.setPluginParameter(CONFIG_IRC_CHANNEL, this.channel);
	    joinChannel(this.channel);
	  }

/* (non-Javadoc)
 * @see org.jibble.pircbot.PircBot#onInfo(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
 */
protected void onInfo(String sourceNick, String sourceLogin, String sourceHostname, String target) {
	// TODO Auto-generated method stub
	try {
	String UPnPEnabled;
	String UserSelectedMode;
	String dHTStatus;
	String BindToIP = "N/A";
	PluginInterface dht_pi 	= AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass( "com.aelitis.azureus.plugins.dht.DHTPlugin" );
	PluginInterface upnp_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass( "com.aelitis.azureus.plugins.upnp.UPnPPlugin" );

	boolean bSendInfo = plugin_config.getPluginBooleanParameter(CONFIG_IRC_SEND_USER_INFO);
	if ((isChanelOp(sourceNick) == true) || (isChanelVoice(sourceNick) == true)) {
		
		if(bSendInfo){
			
			long delay = this.getMessageDelay();
			this.setMessageDelay(500);
			
			if (plugin_config.getIntParameter("Plugin.UPnP.upnp.enable", 1) == 0) {
				UPnPEnabled = "Disabled";
			}else{
				String info = "";
				
				if ( upnp_pi != null ){
					info = " (" + upnp_pi.getPluginconfig().getPluginStringParameter( "plugin.info" ) + ")";
				}
				UPnPEnabled = "Enabled" + info; 				
			}
			if (plugin_config.getIntParameter("User Mode", 0) == 1) {
				UserSelectedMode = "Intermediate";
				}
			else if (plugin_config.getIntParameter("User Mode", 0) == 2){
				UserSelectedMode = "Advanced";
				}
			else {
				UserSelectedMode = "Beginner";
				}
			if (! plugin_config.getStringParameter("Bind IP","").equals("")) {
				BindToIP = plugin_config.getStringParameter("Bind IP","");
			}
			
			this.sendMessage(sourceNick, " :Info for " + getName() + " (" + static_id +") - " + azVersion + " - " + System.getProperty("os.name") + " " + System.getProperty("sun.os.patch.level") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "");

			File dir = new File(System.getProperty("java.home") + File.separator + ".." + File.separator + (Constants.isOSX?".."+File.separator:""));
		    String[] children = dir.list();
		    String filedir = "";
		    if (children != null)
		    {
		        for (int i=0; i<children.length; i++)
		        {
		            filedir = filedir + " " + children[i];
		        }
		    }
		    this.sendMessage(sourceNick, " :Java: " + System.getProperty("java.version") + " installed in " + System.getProperty("java.home") + " | Installations:" + filedir + "");
		    this.sendMessage(sourceNick, " :Port: " + plugin_config.getIntParameter("TCP.Listen.Port",6881) + " | Max connection attempts: " + plugin_config.getIntParameter("network.max.simultaneous.connect.attempts",8) + " | Bind to local IP: " + BindToIP + "");
		    String upSeedingOnly = "";
		    if (plugin_config.getIntParameter("enable.seedingonly.upload.rate",0) == 0)
		    {
		    	upSeedingOnly = "N/A";
		    }
		    else
		    {
		    	upSeedingOnly = "" + plugin_config.getIntParameter("Max Upload Speed Seeding KBs", 0);
		    }
		    this.sendMessage(sourceNick, " :Transfer: Max upload speed: " + plugin_config.getIntParameter("Max Upload Speed KBs", 0) + " | Max upload speed while seeding: " + upSeedingOnly + " | Max download speed: " + plugin_config.getIntParameter("Max Download Speed KBs", 0) + " | Default max upload slots: " + plugin_config.getIntParameter("Max Uploads", 4) + "");
		    this.sendMessage(sourceNick, " :Transfer: Max connections per torrent: " + plugin_config.getIntParameter("Max.Peer.Connections.Per.Torrent", 80) + " | Max connections globally: " + plugin_config.getIntParameter("Max.Peer.Connections.Total", 400) + "");
		    String numberSeedingOnly = "";
		    if (plugin_config.getIntParameter("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled", 0) == 0)
		    {
		    	numberSeedingOnly = "N/A";
		    }
		    else
		    {
		    	numberSeedingOnly = "" + plugin_config.getIntParameter("MaxActiveTorrentsWhenSeeding", 0);
		    }
		    this.sendMessage(sourceNick, " :Queue: Max downloads: " + plugin_config.getIntParameter("max downloads", 4) + " | Max torrents: " + plugin_config.getIntParameter("max active torrents", 4) + " | Max torrents while seeding: " + numberSeedingOnly + " | Ignore Ratio: " +  plugin_config.getFloatParameter("Stop Ratio") + ":1");
		    
		    int nb_plugins = plugin_manager.getPlugins().length;
		    String[] plugins_names = new String[nb_plugins];
		    for(int i=0; i<nb_plugins; i++) {
		    	plugins_names[i] = plugin_manager.getPlugins()[i].getPluginName();
		    }
		    Arrays.sort(plugins_names);

		    int begin = 0;
		    int nb_per_line = 5;
		    int end = nb_per_line;
		    while(begin<nb_plugins) {
		    	String plugins = "";
			    for(int i=begin; i< end; i++) {
			    	plugins += plugins_names[i] + ", ";
			    }
		    	begin += nb_per_line;
		    	end = Math.min(end + nb_per_line, nb_plugins);
		    	
		    	this.sendMessage(sourceNick, " :Plugins:" + plugins + "");
		    }
		    
		    this.sendMessage(sourceNick, " :Misc: UPnP: " + UPnPEnabled + " | User Mode: " + UserSelectedMode + " | User language: " + Locale.getDefault().toString() + "");
		    if ( dht_pi != null ){
		    	DHTPlugin	dhtPlugin = (DHTPlugin)dht_pi.getPlugin();
		   
			    if(dhtPlugin == null || dhtPlugin.getStatus() == DHTPlugin.STATUS_DISABLED ){
			    	dHTStatus = "Disabled";
			    }
			    else if(dhtPlugin.getStatus() == DHTPlugin.STATUS_FAILED ) {
			    	dHTStatus = "Failed";
			    }
			    else if( dhtPlugin.getStatus() == DHTPlugin.STATUS_INITALISING ) {
			    	dHTStatus = "Initialising";
			    }
			    else if( dhtPlugin.getStatus() == DHTPlugin.STATUS_RUNNING ) {
			    	DHT[]	dhts = dhtPlugin.getDHTs();
			    	dHTStatus = "Running (OK) Users: " + dhts[0].getControl().getStats().getEstimatedDHTSize();
			    }
			    else{
			    	dHTStatus = "Unknown";
			    }
		    }else{
		    	dHTStatus = "Unavailable";
		    }
		    
			try {
				String address = InetAddress.getLocalHost ().getHostAddress();
				//String address = InetAddress.getLocalHost().getHostName();
				  this.sendMessage(sourceNick, " :Network: IP: " + address + " | DHT Status: " + dHTStatus + "");
				}
				catch (UnknownHostException ex) {
				  this.sendMessage(sourceNick, " :Network: IP: IP Address could not be resolved | DHT Status: " + dHTStatus + "");
				}
				
			this.setMessageDelay(delay);
		} else {
			this.sendMessage(sourceNick, " :The User does not allow sending information");
		}
		
	} else {
	 		this.sendMessage(sourceNick, " :You do not have permission to do that");
	}
	}
	catch (Exception e) {
		this.sendMessage(sourceNick, " :Something went horribly wrong... Please notify another helper (Error: " + e.getMessage().toString() + ")"); 
	}
	super.onInfo(sourceNick, sourceLogin, sourceHostname, target);
}
}