/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating.ui;

import com.aelitis.azureus.plugins.rating.RatingPlugin;
import com.aelitis.azureus.plugins.rating.updater.RatingResults;
import com.aelitis.azureus.plugins.rating.updater.RatingsUpdater;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.SWT.SWTManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;

public class RatingColumn
implements TableCellRefreshListener {
    private Graphic gNoRating;
    private Graphic[] gRated;
    private RatingPlugin plugin;
    private RatingsUpdater updater;

    public RatingColumn(RatingPlugin plugin) {
        this.plugin = plugin;
        SWTManager swtManager = plugin.getPluginInterface().getUIManager().getSWTManager();
        this.gNoRating = swtManager.createGraphic(plugin.imgNoRating);
        this.gRated = new Graphic[5];
        int i = 0;
        while (i < 5) {
            this.gRated[i] = swtManager.createGraphic(plugin.imgRated[i]);
            ++i;
        }
    }

    public void refresh(TableCell cell) {
        RatingResults rating;
        Object dataSource = cell.getDataSource();
        if (dataSource == null || !(dataSource instanceof Download)) {
            return;
        }
        Download download = (Download)dataSource;
        if (this.updater == null) {
            this.updater = this.plugin.getUpdater();
        }
        Graphic image = this.gNoRating;
        String toolTip = null;
        float average = 0.0f;
        if (this.updater != null && (rating = this.updater.getRatingsForDownload(download)) != null) {
            average = rating.getRealAverageScore();
            average += (float)rating.getNbRatings() / 10000.0f;
            int score = rating.getAverageScoreRound() - 1;
            if (score >= 0 && score < 5) {
                image = this.gRated[score];
            }
            toolTip = rating.getNbRatings() > 0 ? String.valueOf(rating.getAverageScore()) + " (based on " + rating.getNbRatings() + " ratings)" : String.valueOf(rating.getAverageScore()) + " (looking for ratings)";
        }
        if (!cell.setSortValue(average) && cell.isValid()) {
            return;
        }
        cell.setGraphic(image);
        cell.setToolTip(toolTip);
    }
}

