/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.FilesView;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PathItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PathItem() {
        super("path", 1, -2, 200, "Files");
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String path = "";
        if (fileInfo2 != null) {
            if (FilesView.show_full_path || fileInfo2.getLink() != null) {
                File file = fileInfo2.getFile(true);
                try {
                    path = file.getParentFile().getCanonicalPath();
                }
                catch (IOException e) {
                    path = file.getParentFile().getAbsolutePath();
                }
                if (!path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
            } else {
                path = fileInfo2.getTorrentFile().getRelativePath();
                int pos = path.lastIndexOf(File.separator);
                path = pos > 0 ? File.separator + path.substring(0, pos) : File.separator;
            }
        }
        cell.setText(path);
    }
}

