/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.mytorrents.PluginMyTorrentsItemFactory;
import org.gudy.azureus2.plugins.ui.tables.peers.PluginPeerItemFactory;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.OldMyTorrentsPluginItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.OldPeerPluginItem;

public class TableColumnManager {
    private static TableColumnManager instance;
    private static AEMonitor class_mon;
    private Map items;
    private AEMonitor items_mon = new AEMonitor("TableColumnManager:items");

    private TableColumnManager() {
        this.items = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableColumnManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TableColumnManager();
            }
            TableColumnManager tableColumnManager = instance;
            return tableColumnManager;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(TableColumnCore item) {
        try {
            String name = item.getName();
            String sTableID = item.getTableID();
            try {
                this.items_mon.enter();
                LinkedHashMap<String, TableColumnCore> mTypes = (LinkedHashMap<String, TableColumnCore>)this.items.get(sTableID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, TableColumnCore>();
                    this.items.put(sTableID, mTypes);
                }
                if (!mTypes.containsKey(name)) {
                    mTypes.put(name, item);
                    item.loadSettings();
                }
            }
            finally {
                this.items_mon.exit();
            }
            if (!item.getColumnAdded()) {
                item.setColumnAdded(true);
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Table Column Extension");
            Debug.printStackTrace(e);
        }
    }

    public void addExtension(String name, PluginMyTorrentsItemFactory item) {
        OldMyTorrentsPluginItem tci;
        String sAlign = item.getOrientation();
        int iAlign = sAlign.equals("R") ? 2 : 1;
        int iVisibleIn = item.getTablesVisibleIn();
        if ((iVisibleIn & 1) != 0) {
            tci = new OldMyTorrentsPluginItem("MySeeders", name, item);
            tci.initialize(iAlign, item.getDefaultPosition(), item.getDefaultSize());
            this.addColumn(tci);
        }
        if ((iVisibleIn & 2) != 0) {
            tci = new OldMyTorrentsPluginItem("MyTorrents", name, item);
            tci.initialize(iAlign, item.getDefaultPosition(), item.getDefaultSize());
            this.addColumn(tci);
        }
    }

    public void addExtension(String name, PluginPeerItemFactory item) {
        OldPeerPluginItem tci = new OldPeerPluginItem("Peers", name, item);
        tci.initialize(1, -1, item.getDefaultSize());
        this.addColumn(tci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getTableColumnsAsMap(String sTableID) {
        try {
            this.items_mon.enter();
            LinkedHashMap mReturn = new LinkedHashMap();
            Map mTypes = (Map)this.items.get(sTableID);
            if (mTypes != null) {
                mReturn.putAll(mTypes);
            }
            LinkedHashMap linkedHashMap = mReturn;
            return linkedHashMap;
        }
        finally {
            this.items_mon.exit();
        }
    }

    public TableColumnCore[] getAllTableColumnCoreAsArray(String sTableID) {
        Map mTypes = (Map)this.items.get(sTableID);
        if (mTypes != null) {
            return mTypes.values().toArray(new TableColumnCore[mTypes.values().size()]);
        }
        return new TableColumnCore[0];
    }

    public TableColumnCore getTableColumnCore(String sTableID, String sColumnName) {
        Map mTypes = (Map)this.items.get(sTableID);
        if (mTypes == null) {
            return null;
        }
        return (TableColumnCore)mTypes.get(sColumnName);
    }

    public void ensureIntegrety(String sTableID) {
        Map mTypes = (Map)this.items.get(sTableID);
        if (mTypes == null) {
            return;
        }
        TableColumnCore[] tableColumns = mTypes.values().toArray(new TableColumnCore[mTypes.values().size()]);
        Arrays.sort(tableColumns, new Comparator(){

            public final int compare(Object a, Object b) {
                int iPositionB;
                int iPositionA = ((TableColumnCore)a).getPosition();
                if (iPositionA == -2) {
                    iPositionA = 65535;
                }
                if ((iPositionB = ((TableColumnCore)b).getPosition()) == -2) {
                    iPositionB = 65535;
                }
                return iPositionA - iPositionB;
            }
        });
        int iPos = 0;
        for (int i = 0; i < tableColumns.length; ++i) {
            int iCurPos = tableColumns[i].getPosition();
            if (iCurPos < 0 && iCurPos != -2) continue;
            tableColumns[i].setPositionNoShift(iPos++);
        }
    }

    public void saveTableColumns(String sTableID) {
        TableColumnCore[] tcs = this.getAllTableColumnCoreAsArray(sTableID);
        for (int i = 0; i < tcs.length; ++i) {
            if (tcs[i] == null) continue;
            tcs[i].saveSettings();
        }
        COConfigurationManager.save();
    }

    static {
        class_mon = new AEMonitor("TableColumnManager");
    }
}

