/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import java.text.DecimalFormat;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class TransferStatsView
extends AbstractIView {
    GlobalManager manager;
    GlobalManagerStats stats;
    OverallStats totalStats;
    Composite panel;
    BufferedLabel nowUp;
    BufferedLabel nowDown;
    BufferedLabel sessionDown;
    BufferedLabel sessionUp;
    BufferedLabel session_ratio;
    BufferedLabel sessionTime;
    BufferedLabel totalDown;
    BufferedLabel totalUp;
    BufferedLabel total_ratio;
    BufferedLabel totalTime;
    private final DecimalFormat formatter = new DecimalFormat("##.#");

    public TransferStatsView(GlobalManager manager) {
        this.manager = manager;
        this.stats = manager.getStats();
        this.totalStats = StatsFactory.getStats();
    }

    public void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 5;
        panelLayout.makeColumnsEqualWidth = true;
        this.panel.setLayout((Layout)panelLayout);
        Label lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.downloaded");
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uploaded");
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.ratio");
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uptime");
        lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.now");
        this.nowDown = new BufferedLabel(this.panel, 0);
        GridData gridData = new GridData(768);
        this.nowDown.setLayoutData(gridData);
        this.nowUp = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.nowUp.setLayoutData(gridData);
        lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.session");
        this.sessionDown = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.sessionDown.setLayoutData(gridData);
        this.sessionUp = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.sessionUp.setLayoutData(gridData);
        this.session_ratio = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.session_ratio.setLayoutData(gridData);
        this.sessionTime = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.sessionTime.setLayoutData(gridData);
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.total");
        this.totalDown = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.totalDown.setLayoutData(gridData);
        this.totalUp = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.totalUp.setLayoutData(gridData);
        this.total_ratio = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.total_ratio.setLayoutData(gridData);
        this.totalTime = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.totalTime.setLayoutData(gridData);
    }

    public void delete() {
        Utils.disposeComposite(this.panel);
    }

    public String getFullTitle() {
        return MessageText.getString("SpeedView.title.full");
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void refresh() {
        int now_prot_down_rate = this.stats.getProtocolReceiveRate();
        int now_prot_up_rate = this.stats.getProtocolSendRate();
        int now_total_down_rate = this.stats.getDataReceiveRate() + now_prot_down_rate;
        int now_total_up_rate = this.stats.getDataSendRate() + now_prot_up_rate;
        float now_perc_down = (float)(now_prot_down_rate * 100) / (float)(now_total_down_rate + 1);
        float now_perc_up = (float)(now_prot_up_rate * 100) / (float)(now_total_up_rate + 1);
        this.nowDown.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_down_rate) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_down_rate) + ", " + this.formatter.format(now_perc_down) + "%)");
        this.nowUp.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_up_rate) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_up_rate) + ", " + this.formatter.format(now_perc_up) + "%)");
        long session_prot_received = this.stats.getTotalProtocolBytesReceived();
        long session_prot_sent = this.stats.getTotalProtocolBytesSent();
        long session_total_received = this.stats.getTotalDataBytesReceived() + session_prot_received;
        long session_total_sent = this.stats.getTotalDataBytesSent() + session_prot_sent;
        float session_perc_received = (float)(session_prot_received * 100L) / (float)(session_total_received + 1L);
        float session_perc_sent = (float)(session_prot_sent * 100L) / (float)(session_total_sent + 1L);
        this.sessionDown.setText(DisplayFormatters.formatByteCountToKiBEtc(session_total_received) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_received) + ", " + this.formatter.format(session_perc_received) + "%)");
        this.sessionUp.setText(DisplayFormatters.formatByteCountToKiBEtc(session_total_sent) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_sent) + ", " + this.formatter.format(session_perc_sent) + "%)");
        this.totalDown.setText(DisplayFormatters.formatByteCountToKiBEtc(this.totalStats.getDownloadedBytes()));
        this.totalUp.setText(DisplayFormatters.formatByteCountToKiBEtc(this.totalStats.getUploadedBytes()));
        this.sessionTime.setText(DisplayFormatters.formatETA(this.totalStats.getSessionUpTime()));
        this.totalTime.setText(DisplayFormatters.formatETA(this.totalStats.getTotalUpTime()));
        long t_ratio_raw = 1000L * this.totalStats.getUploadedBytes() / (this.totalStats.getDownloadedBytes() + 1L);
        long s_ratio_raw = 1000L * session_total_sent / (session_total_received + 1L);
        String t_ratio = "";
        String s_ratio = "";
        String partial = String.valueOf(t_ratio_raw % 1000L);
        while (partial.length() < 3) {
            partial = "0" + partial;
        }
        t_ratio = t_ratio_raw / 1000L + "." + partial;
        partial = String.valueOf(s_ratio_raw % 1000L);
        while (partial.length() < 3) {
            partial = "0" + partial;
        }
        s_ratio = s_ratio_raw / 1000L + "." + partial;
        this.total_ratio.setText(t_ratio);
        this.session_ratio.setText(s_ratio);
    }

    public String getData() {
        return "TransferStatsView.title.full";
    }
}

