/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.generic.GenericBooleanParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericIntParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class TorrentOptionsView
extends AbstractIView {
    private static final String TEXT_PREFIX = "TorrentOptionsView.param.";
    private static final String MAX_UPLOAD = "max.upload";
    private static final String MAX_DOWNLOAD = "max.download";
    private static final String MAX_UPLOADS = "max.uploads";
    private DownloadManager manager;
    private GenericParameterAdapter ds_param_adapter = new downloadStateParameterAdapter();
    private GenericParameterAdapter adhoc_param_adapter = new adhocParameterAdapter();
    private Composite panel;

    protected TorrentOptionsView(DownloadManager _manager) {
        this.manager = _manager;
    }

    public void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this.panel.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite cHeader = new Composite(this.panel, 2048);
        GridLayout configLayout = new GridLayout();
        configLayout.marginHeight = 3;
        configLayout.marginWidth = 0;
        cHeader.setLayout((Layout)configLayout);
        GridData gridData = new GridData(772);
        cHeader.setLayoutData((Object)gridData);
        Display d = this.panel.getDisplay();
        cHeader.setBackground(d.getSystemColor(26));
        cHeader.setForeground(d.getSystemColor(27));
        Label lHeader = new Label(cHeader, 0);
        lHeader.setBackground(d.getSystemColor(26));
        lHeader.setForeground(d.getSystemColor(27));
        FontData[] fontData = lHeader.getFont().getFontData();
        fontData[0].setStyle(1);
        int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
        fontData[0].setHeight(fontHeight);
        Font headerFont = new Font((Device)d, fontData);
        lHeader.setFont(headerFont);
        lHeader.setText(" " + MessageText.getString("authenticator.torrent") + " : " + this.manager.getDisplayName().replaceAll("&", "&&"));
        gridData = new GridData(772);
        lHeader.setLayoutData((Object)gridData);
        Group gTransfer = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gTransfer, "ConfigView.section.transfer");
        gridData = new GridData(272);
        gTransfer.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTransfer.setLayout((Layout)layout);
        String k_unit = DisplayFormatters.getRateUnitBase10(1).trim();
        Label label = new Label((Composite)gTransfer, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxuploadspeed.tooltip"));
        GenericIntParameter max_upload = new GenericIntParameter(this.adhoc_param_adapter, (Composite)gTransfer, MAX_UPLOAD, false);
        gridData = new GridData();
        gridData.widthHint = 40;
        max_upload.setLayoutData(gridData);
        label = new Label((Composite)gTransfer, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxdownloadspeed.tooltip"));
        GenericIntParameter max_download = new GenericIntParameter(this.adhoc_param_adapter, (Composite)gTransfer, MAX_DOWNLOAD, false);
        gridData = new GridData();
        gridData.widthHint = 40;
        max_download.setLayoutData(gridData);
        if (userMode > 0) {
            label = new Label((Composite)gTransfer, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.uploads");
            GenericIntParameter max_uploads = new GenericIntParameter(this.adhoc_param_adapter, (Composite)gTransfer, MAX_UPLOADS, false);
            max_uploads.setMinimumValue(2);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_uploads.setLayoutData(gridData);
            Composite cMaxUploadsOptionsArea = new Composite((Composite)gTransfer, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxUploadsOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 15;
            gridData.horizontalSpan = 2;
            cMaxUploadsOptionsArea.setLayoutData((Object)gridData);
            label = new Label(cMaxUploadsOptionsArea, 0);
            Image img = ImageRepository.getImage("subitem");
            img.setBackground(label.getBackground());
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
            label.setImage(img);
            gridData = new GridData();
            GenericBooleanParameter max_uploads_when_seeding_enabled = new GenericBooleanParameter(this.ds_param_adapter, cMaxUploadsOptionsArea, "max.uploads.when.seeding.enabled", false, "TorrentOptionsView.param.max.uploads.when.seeding.enable");
            max_uploads_when_seeding_enabled.setLayoutData(gridData);
            GenericIntParameter max_uploads_when_seeding = new GenericIntParameter(this.ds_param_adapter, cMaxUploadsOptionsArea, "max.uploads.when.seeding", false);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_uploads_when_seeding.setMinimumValue(2);
            max_uploads_when_seeding.setLayoutData(gridData);
            max_uploads_when_seeding_enabled.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(max_uploads_when_seeding.getControl()));
            label = new Label((Composite)gTransfer, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.peers");
            GenericIntParameter max_peers = new GenericIntParameter(this.ds_param_adapter, (Composite)gTransfer, "max.peers", false);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_peers.setLayoutData(gridData);
        }
    }

    public Composite getComposite() {
        return this.panel;
    }

    public String getFullTitle() {
        return MessageText.getString("TorrentOptionsView.title.full");
    }

    public String getData() {
        return "TorrentOptionsView.title.short";
    }

    protected class downloadStateParameterAdapter
    extends GenericParameterAdapter {
        protected downloadStateParameterAdapter() {
        }

        public int getIntValue(String key) {
            return this.getIntValue(key, 0);
        }

        public int getIntValue(String key, int def) {
            return TorrentOptionsView.this.manager.getDownloadState().getIntParameter(key);
        }

        public void setIntValue(String key, int value) {
            TorrentOptionsView.this.manager.getDownloadState().setIntParameter(key, value);
        }

        public boolean getBooleanValue(String key) {
            return this.getBooleanValue(key, false);
        }

        public boolean getBooleanValue(String key, boolean def) {
            return TorrentOptionsView.this.manager.getDownloadState().getBooleanParameter(key);
        }

        public void setBooleanValue(String key, boolean value) {
            TorrentOptionsView.this.manager.getDownloadState().setBooleanParameter(key, value);
        }
    }

    protected class adhocParameterAdapter
    extends GenericParameterAdapter {
        protected adhocParameterAdapter() {
        }

        public int getIntValue(String key) {
            return this.getIntValue(key, 0);
        }

        public int getIntValue(String key, int def) {
            if (key == TorrentOptionsView.MAX_UPLOADS) {
                return TorrentOptionsView.this.manager.getStats().getMaxUploads();
            }
            if (key == TorrentOptionsView.MAX_UPLOAD) {
                return TorrentOptionsView.this.manager.getStats().getUploadRateLimitBytesPerSecond() / 1024;
            }
            if (key == TorrentOptionsView.MAX_DOWNLOAD) {
                return TorrentOptionsView.this.manager.getStats().getDownloadRateLimitBytesPerSecond() / 1024;
            }
            return 0;
        }

        public void setIntValue(String key, int value) {
            if (key == TorrentOptionsView.MAX_UPLOADS) {
                TorrentOptionsView.this.manager.getStats().setMaxUploads(value);
            } else if (key == TorrentOptionsView.MAX_UPLOAD) {
                TorrentOptionsView.this.manager.getStats().setUploadRateLimitBytesPerSecond(value * 1024);
            } else if (key == TorrentOptionsView.MAX_DOWNLOAD) {
                TorrentOptionsView.this.manager.getStats().setDownloadRateLimitBytesPerSecond(value * 1024);
            }
        }
    }
}

