/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import java.lang.reflect.Constructor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;

public class SWTThread {
    private static SWTThread instance;
    Display display;
    private boolean sleak;
    private boolean terminated;
    private Thread runner;

    public static SWTThread getInstance() {
        return instance;
    }

    public static void createInstance(Initializer app) throws SWTThreadAlreadyInstanciatedException {
        if (instance != null) {
            throw new SWTThreadAlreadyInstanciatedException();
        }
        boolean bGTKTableBug_default = SWT.getPlatform().equals("gtk");
        COConfigurationManager.setBooleanDefault("SWT_bGTKTableBug", bGTKTableBug_default);
        new SWTThread(app);
    }

    private SWTThread(final Initializer app) {
        instance = this;
        try {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = new Display();
                this.sleak = false;
            } else {
                this.sleak = true;
            }
        }
        catch (Exception e) {
            this.display = new Display();
            this.sleak = false;
        }
        Display.setAppName((String)"Azureus");
        if (Constants.isOSX) {
            try {
                Class<?> ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CarbonUIEnhancer");
                Constructor<?> constructor = ehancerClass.getConstructor(new Class[0]);
                constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        this.runner = new Thread((Runnable)new AERunnable(){

            public void runSupport() {
                app.run();
            }
        }, "Main Thread");
        this.runner.start();
        if (!this.sleak) {
            while (!this.display.isDisposed() && !this.terminated) {
                try {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
                catch (Exception e) {
                    if (SWT.getVersion() < 3119) {
                        e.printStackTrace();
                        continue;
                    }
                    Debug.printStackTrace(e);
                }
            }
            if (!this.terminated) {
                app.stopIt(false, false);
            }
            try {
                if (!this.display.isDisposed()) {
                    this.display.dispose();
                }
            }
            catch (Throwable t) {
                if (SWT.getVersion() < 3119) {
                    t.printStackTrace();
                }
                Debug.printStackTrace(t);
            }
            PlatformManagerFactory.getPlatformManager().dispose();
        }
    }

    public void terminate() {
        this.terminated = true;
    }

    public Display getDisplay() {
        return this.display;
    }
}

