/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.IView;

public class GUIUpdater
extends AEThread
implements ParameterListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final boolean DEBUG_TIMER = Constants.isCVSVersion();
    private AzureusCore azureus_core;
    private ConnectionManager connection_manager;
    private OverallStats overall_stats;
    private DHTPlugin dhtPlugin;
    private NumberFormat numberFormat;
    private MainWindow mainWindow;
    private Display display;
    private long last_sr_ratio = -1L;
    private int last_sr_status = -1;
    private int lastNATstatus = -1;
    private int lastDHTstatus = -1;
    private long lastDHTcount = -1L;
    boolean finished = false;
    boolean refreshed = true;
    int waitTime = COConfigurationManager.getIntParameter("GUI Refresh");
    Map averageTimes = DEBUG_TIMER ? new HashMap() : null;

    public GUIUpdater(AzureusCore _azureus_core, MainWindow mainWindow) {
        super("GUI updater");
        this.azureus_core = _azureus_core;
        this.mainWindow = mainWindow;
        this.display = mainWindow.getDisplay();
        this.numberFormat = NumberFormat.getInstance();
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        this.connection_manager = pm.getDefaultPluginInterface().getConnectionManager();
        this.overall_stats = StatsFactory.getStats();
        PluginInterface dht_pi = pm.getPluginInterfaceByClass(DHTPlugin.class);
        if (dht_pi != null) {
            this.dhtPlugin = (DHTPlugin)dht_pi.getPlugin();
        }
        this.setPriority(8);
        COConfigurationManager.addParameterListener("GUI Refresh", this);
    }

    public void runSupport() {
        while (!this.finished) {
            if (this.refreshed) {
                this.update();
            }
            try {
                Thread.sleep(this.waitTime);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void parameterChanged(String parameterName) {
        this.waitTime = COConfigurationManager.getIntParameter("GUI Refresh");
    }

    private void update() {
        this.refreshed = false;
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    LinkedHashMap<String, Long> timeMap;
                    long lTimeStart = System.currentTimeMillis();
                    LinkedHashMap<String, Long> linkedHashMap = timeMap = DEBUG_TIMER ? new LinkedHashMap<String, Long>() : null;
                    if (GUIUpdater.this.display == null || GUIUpdater.this.display.isDisposed()) {
                        return;
                    }
                    IView view = null;
                    if (!GUIUpdater.this.mainWindow.getShell().isDisposed() && GUIUpdater.this.mainWindow.isVisible() && !GUIUpdater.this.mainWindow.getShell().getMinimized()) {
                        String seeding_only;
                        DHT[] dhts;
                        view = GUIUpdater.this.mainWindow.getCurrentView();
                        if (DEBUG_TIMER) {
                            timeMap.put("Init", new Long(System.currentTimeMillis()));
                        }
                        if (view != null) {
                            view.refresh();
                            if (DEBUG_TIMER) {
                                String s = view.getFullTitle().replaceAll("[0-9.]++\\% : ", "");
                                timeMap.put("'" + s + "' Refresh", new Long(System.currentTimeMillis()));
                            }
                            Tab.refresh();
                            if (DEBUG_TIMER) {
                                timeMap.put("Tab Refresh", new Long(System.currentTimeMillis()));
                            }
                        }
                        IpFilter ip_filter = GUIUpdater.this.azureus_core.getIpFilterManager().getIPFilter();
                        ((GUIUpdater)GUIUpdater.this).mainWindow.ipBlocked.setText("{" + DisplayFormatters.formatDateShort(ip_filter.getLastUpdateTime()) + "} IPs: " + GUIUpdater.this.numberFormat.format(ip_filter.getNbRanges()) + " - " + GUIUpdater.this.numberFormat.format(ip_filter.getNbIpsBlockedAndLoggable()) + "/" + GUIUpdater.this.numberFormat.format(ip_filter.getNbBannedIps()) + "/" + GUIUpdater.this.numberFormat.format(GUIUpdater.this.azureus_core.getIpFilterManager().getBadIps().getNbBadIps()));
                        long ratio = 1000L * GUIUpdater.this.overall_stats.getUploadedBytes() / (GUIUpdater.this.overall_stats.getDownloadedBytes() + 1L);
                        int sr_status = ratio < 500L ? 0 : (ratio < 900L ? 1 : 2);
                        if (sr_status != GUIUpdater.this.last_sr_status) {
                            String imgID;
                            switch (sr_status) {
                                case 2: {
                                    imgID = "greenled";
                                    break;
                                }
                                case 1: {
                                    imgID = "yellowled";
                                    break;
                                }
                                default: {
                                    imgID = "redled";
                                }
                            }
                            ((GUIUpdater)GUIUpdater.this).mainWindow.srStatus.setImage(ImageRepository.getImage(imgID));
                            GUIUpdater.this.last_sr_status = sr_status;
                        }
                        if (ratio != GUIUpdater.this.last_sr_ratio) {
                            String tooltipID;
                            switch (sr_status) {
                                case 2: {
                                    tooltipID = "MainWindow.sr.status.tooltip.ok";
                                    break;
                                }
                                case 1: {
                                    tooltipID = "MainWindow.sr.status.tooltip.poor";
                                    break;
                                }
                                default: {
                                    tooltipID = "MainWindow.sr.status.tooltip.bad";
                                }
                            }
                            String ratio_str = "";
                            String partial = "" + ratio % 1000L;
                            while (partial.length() < 3) {
                                partial = "0" + partial;
                            }
                            ratio_str = ratio / 1000L + "." + partial;
                            ((GUIUpdater)GUIUpdater.this).mainWindow.srStatus.setToolTipText(MessageText.getString(tooltipID, new String[]{ratio_str}));
                            GUIUpdater.this.last_sr_ratio = ratio;
                        }
                        int nat_status = GUIUpdater.this.connection_manager.getNATStatus();
                        if (GUIUpdater.this.lastNATstatus != nat_status) {
                            String statusID;
                            String tooltipID;
                            String imgID;
                            switch (nat_status) {
                                case 0: {
                                    imgID = "grayled";
                                    tooltipID = "MainWindow.nat.status.tooltip.unknown";
                                    statusID = "MainWindow.nat.status.unknown";
                                    break;
                                }
                                case 1: {
                                    imgID = "greenled";
                                    tooltipID = "MainWindow.nat.status.tooltip.ok";
                                    statusID = "MainWindow.nat.status.ok";
                                    break;
                                }
                                case 2: {
                                    imgID = "yellowled";
                                    tooltipID = "MainWindow.nat.status.tooltip.probok";
                                    statusID = "MainWindow.nat.status.probok";
                                    break;
                                }
                                default: {
                                    imgID = "redled";
                                    tooltipID = "MainWindow.nat.status.tooltip.bad";
                                    statusID = "MainWindow.nat.status.bad";
                                }
                            }
                            ((GUIUpdater)GUIUpdater.this).mainWindow.natStatus.setImage(ImageRepository.getImage(imgID));
                            ((GUIUpdater)GUIUpdater.this).mainWindow.natStatus.setToolTipText(MessageText.getString(tooltipID));
                            ((GUIUpdater)GUIUpdater.this).mainWindow.natStatus.setText(MessageText.getString(statusID));
                            GUIUpdater.this.lastNATstatus = nat_status;
                        }
                        int dht_status = GUIUpdater.this.dhtPlugin == null ? 1 : GUIUpdater.this.dhtPlugin.getStatus();
                        long dht_count = -1L;
                        if (dht_status == 3 && (dhts = GUIUpdater.this.dhtPlugin.getDHTs()).length > 0 && dhts[0].getTransport().isReachable()) {
                            dht_count = dhts[0].getControl().getStats().getEstimatedDHTSize();
                        }
                        if (GUIUpdater.this.lastDHTstatus != dht_status || GUIUpdater.this.lastDHTcount != dht_count) {
                            switch (dht_status) {
                                case 3: {
                                    if (dht_count > 100000L) {
                                        ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setImage(ImageRepository.getImage("greenled"));
                                        ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.tooltip"));
                                        ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setText(GUIUpdater.this.numberFormat.format(dht_count) + " " + MessageText.getString("MainWindow.dht.status.users"));
                                        break;
                                    }
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setImage(ImageRepository.getImage("yellowled"));
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.unreachabletooltip"));
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.unreachable"));
                                    break;
                                }
                                case 1: {
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setImage(ImageRepository.getImage("grayled"));
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.disabled"));
                                    break;
                                }
                                case 2: {
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setImage(ImageRepository.getImage("yellowled"));
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.initializing"));
                                    break;
                                }
                                case 4: {
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setImage(ImageRepository.getImage("redled"));
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.failed"));
                                    break;
                                }
                                default: {
                                    ((GUIUpdater)GUIUpdater.this).mainWindow.dhtStatus.setImage(null);
                                }
                            }
                            GUIUpdater.this.lastDHTstatus = dht_status;
                            GUIUpdater.this.lastDHTcount = dht_count;
                        }
                        int ul_limit_norm = NetworkManager.getMaxUploadRateBPSNormal() / 1024;
                        int dl_limit = NetworkManager.getMaxDownloadRateBPS() / 1024;
                        if (NetworkManager.isSeedingOnlyUploadRate()) {
                            int ul_limit_seed = NetworkManager.getMaxUploadRateBPSSeedingOnly() / 1024;
                            if (ul_limit_seed == 0) {
                                seeding_only = "+\u221eK";
                            } else {
                                int diff = ul_limit_seed - ul_limit_norm;
                                seeding_only = (diff >= 0 ? "+" : "") + diff + "K";
                            }
                        } else {
                            seeding_only = "";
                        }
                        ((GUIUpdater)GUIUpdater.this).mainWindow.statusDown.setText((dl_limit == 0 ? "" : "[" + dl_limit + "K] ") + DisplayFormatters.formatByteCountToKiBEtcPerSec(((GUIUpdater)GUIUpdater.this).mainWindow.globalManager.getStats().getDataReceiveRate() + ((GUIUpdater)GUIUpdater.this).mainWindow.globalManager.getStats().getProtocolReceiveRate()));
                        ((GUIUpdater)GUIUpdater.this).mainWindow.statusUp.setText((ul_limit_norm == 0 ? "" : "[" + ul_limit_norm + "K" + seeding_only + "] ") + DisplayFormatters.formatByteCountToKiBEtcPerSec(((GUIUpdater)GUIUpdater.this).mainWindow.globalManager.getStats().getDataSendRate() + ((GUIUpdater)GUIUpdater.this).mainWindow.globalManager.getStats().getProtocolSendRate()));
                        ((GUIUpdater)GUIUpdater.this).mainWindow.statusBar.layout();
                    }
                    if (DEBUG_TIMER) {
                        timeMap.put("Status Bar", new Long(System.currentTimeMillis()));
                    }
                    if (((GUIUpdater)GUIUpdater.this).mainWindow.systemTraySWT != null) {
                        ((GUIUpdater)GUIUpdater.this).mainWindow.systemTraySWT.update();
                    }
                    if (DEBUG_TIMER) {
                        timeMap.put("SysTray", new Long(System.currentTimeMillis()));
                    }
                    try {
                        ((GUIUpdater)GUIUpdater.this).mainWindow.downloadBars_mon.enter();
                        Iterator iter = ((GUIUpdater)GUIUpdater.this).mainWindow.downloadBars.values().iterator();
                        while (iter.hasNext()) {
                            MinimizedWindow mw = (MinimizedWindow)iter.next();
                            mw.refresh();
                        }
                    }
                    finally {
                        ((GUIUpdater)GUIUpdater.this).mainWindow.downloadBars_mon.exit();
                    }
                    if (DEBUG_TIMER) {
                        timeMap.put("DLBars", new Long(System.currentTimeMillis()));
                        GUIUpdater.this.makeDebugToolTip(lTimeStart, timeMap);
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "Error while trying to update GUI", e));
                }
                finally {
                    GUIUpdater.this.refreshed = true;
                }
            }
        });
    }

    public void stopIt() {
        this.finished = true;
        COConfigurationManager.removeParameterListener("GUI Refresh", this);
        COConfigurationManager.removeParameterListener("config.style.refreshMT", this);
    }

    private void makeDebugToolTip(long lTimeStart, Map timeMap) {
        boolean IDX_AVG = false;
        boolean IDX_SIZE = true;
        int IDX_MAX = 2;
        int IDX_LAST = 3;
        int IDX_TIME = 4;
        long lastTime = lTimeStart;
        Iterator iter = timeMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!this.averageTimes.containsKey(key)) {
                this.averageTimes.put(key, new Object[]{new Long(0L), new Long(0L), new Long(0L), new Long(0L), new Long(System.currentTimeMillis())});
            }
            Object[] average = (Object[])this.averageTimes.get(key);
            long l = (Long)timeMap.get(key);
            long diff = l - lastTime;
            if (diff > 0L) {
                long count = (Long)average[1];
                if (count >= 20L) {
                    count = 19L;
                }
                long lNewAverage = ((Long)average[0] * count + diff) / (count + 1L);
                average[0] = new Long(lNewAverage);
                average[1] = new Long(count + 1L);
                if (diff > (Long)average[2]) {
                    average[2] = new Long(diff);
                }
                average[3] = new Long(diff);
                average[4] = new Long(System.currentTimeMillis());
            } else {
                average[3] = new Long(diff);
            }
            this.averageTimes.put(key, average);
            lastTime = l;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter2 = this.averageTimes.keySet().iterator();
        while (iter2.hasNext()) {
            String key = (String)iter2.next();
            Object[] average = (Object[])this.averageTimes.get(key);
            long lLastUpdated = (Long)average[4];
            if (System.currentTimeMillis() - lLastUpdated > 10000L) {
                iter2.remove();
                continue;
            }
            long lTime = (Long)average[0];
            if (lTime <= 0L) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(average[0] + "ms avg: ");
            sb.append("[" + key + "]");
            sb.append(average[1] + " samples");
            sb.append("; max:" + average[2]);
            sb.append("; last:" + average[3]);
        }
        if (!this.mainWindow.getShell().isDisposed()) {
            this.mainWindow.statusText.setToolTipText(sb.toString());
        }
    }
}

