/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.generic;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;

public class GenericIntParameter {
    GenericParameterAdapter adapter;
    Text inputField;
    int iMinValue = 0;
    int iMaxValue = -1;
    int iDefaultValue;
    String sParamName;
    boolean allowZero = false;
    boolean generateIntermediateEvents = true;
    boolean value_is_changing_internally;

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name) {
        this.iDefaultValue = adapter.getIntValue(name);
        this.initialize(adapter, composite, name);
    }

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name, boolean generateIntermediateEvents) {
        this.iDefaultValue = adapter.getIntValue(name);
        this.generateIntermediateEvents = generateIntermediateEvents;
        this.initialize(adapter, composite, name);
    }

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name, int defaultValue) {
        this.iDefaultValue = defaultValue;
        this.initialize(adapter, composite, name);
    }

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name, int defaultValue, boolean generateIntermediateEvents) {
        this.iDefaultValue = defaultValue;
        this.generateIntermediateEvents = generateIntermediateEvents;
        this.initialize(adapter, composite, name);
    }

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name, int minValue, int maxValue, boolean allowZero, boolean generateIntermediateEvents) {
        this.iDefaultValue = adapter.getIntValue(name);
        this.iMinValue = minValue;
        this.iMaxValue = maxValue;
        this.allowZero = allowZero;
        this.generateIntermediateEvents = generateIntermediateEvents;
        this.initialize(adapter, composite, name);
    }

    public void initialize(GenericParameterAdapter _adapter, Composite composite, String name) {
        this.adapter = _adapter;
        this.sParamName = name;
        this.inputField = new Text(composite, 2048);
        int value = this.adapter.getIntValue(name, this.iDefaultValue);
        this.inputField.setText(String.valueOf(value));
        this.inputField.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        if (this.generateIntermediateEvents) {
            this.inputField.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    GenericIntParameter.this.checkValue();
                }
            });
        }
        this.inputField.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                GenericIntParameter.this.checkValue();
            }
        });
    }

    public void setAllowZero(boolean allow) {
        this.allowZero = allow;
    }

    public void setMinimumValue(int value) {
        this.iMinValue = value;
    }

    public void setMaximumValue(int value) {
        this.iMaxValue = value;
    }

    protected void checkValue() {
        try {
            int new_val;
            int old_val = this.adapter.getIntValue(this.sParamName, -1);
            int original_new_val = new_val = Integer.parseInt(this.inputField.getText());
            if (!(new_val >= this.iMinValue || this.allowZero && new_val == 0)) {
                new_val = this.iMinValue;
            }
            if (new_val > this.iMaxValue && this.iMaxValue > -1) {
                new_val = this.iMaxValue;
            }
            if (new_val == old_val) {
                if (new_val != original_new_val) {
                    this.inputField.setText(String.valueOf(new_val));
                }
            } else {
                this.adapter.setIntValue(this.sParamName, new_val);
                if (new_val != original_new_val) {
                    this.inputField.setText(String.valueOf(new_val));
                }
                this.adapter.informChanged(this.value_is_changing_internally);
            }
        }
        catch (Exception e) {
            this.inputField.setText(String.valueOf(this.iMinValue));
            this.adapter.setIntValue(this.sParamName, this.iMinValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int value) {
        String str_val = String.valueOf(value);
        if (this.getValue() != value || !str_val.equals(this.inputField.getText())) {
            try {
                this.value_is_changing_internally = true;
                this.inputField.setText(str_val);
            }
            finally {
                this.value_is_changing_internally = false;
            }
        }
    }

    public int getValue() {
        return this.adapter.getIntValue(this.sParamName, this.iDefaultValue);
    }

    public void setLayoutData(Object layoutData) {
        this.inputField.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.inputField;
    }
}

