/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.config.IAdditionalActionPerformer;
import org.gudy.azureus2.ui.swt.config.Parameter;

public class RadioParameter
extends Parameter {
    Button radioButton;
    List performers = new ArrayList();

    public RadioParameter(Composite composite, String sConfigName, int iButtonValue) {
        this(composite, sConfigName, iButtonValue, null);
    }

    public RadioParameter(Composite composite, final String sConfigName, final int iButtonValue, IAdditionalActionPerformer actionPerformer) {
        if (actionPerformer != null) {
            this.performers.add(actionPerformer);
        }
        int iDefaultValue = COConfigurationManager.getIntParameter(sConfigName);
        this.radioButton = new Button(composite, 16);
        this.radioButton.setSelection(iDefaultValue == iButtonValue);
        this.radioButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean selected = RadioParameter.this.radioButton.getSelection();
                if (selected) {
                    COConfigurationManager.setParameter(sConfigName, iButtonValue);
                }
                if (RadioParameter.this.performers.size() > 0) {
                    for (int i = 0; i < RadioParameter.this.performers.size(); ++i) {
                        IAdditionalActionPerformer performer = (IAdditionalActionPerformer)RadioParameter.this.performers.get(i);
                        performer.setSelected(selected);
                        performer.performAction();
                    }
                }
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.radioButton.setLayoutData(layoutData);
    }

    public void setAdditionalActionPerformer(IAdditionalActionPerformer actionPerformer) {
        this.performers.add(actionPerformer);
        boolean selected = this.radioButton.getSelection();
        actionPerformer.setSelected(selected);
        actionPerformer.performAction();
    }

    public Control getControl() {
        return this.radioButton;
    }

    public boolean isSelected() {
        return this.radioButton.getSelection();
    }
}

