/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.multiuser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.gudy.azureus2.ui.console.UserProfile;
import org.gudy.azureus2.ui.console.multiuser.UserManager;

public class TestUserManager
extends TestCase {
    private InMemoryUserManager manager;
    private UserProfile profile1;
    private UserProfile profile2;

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = new InMemoryUserManager(null);
        this.profile1 = new UserProfile();
        this.profile1.setUsername("myuser1");
        this.profile1.setPassword("mypassword");
        this.manager.addUser(this.profile1);
        this.profile2 = new UserProfile();
        this.profile2.setUsername("myuser2");
        this.profile2.setPassword("zigzag");
        this.profile2.setUserType("user");
        this.manager.addUser(this.profile2);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLoadSave() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.manager.save(out);
        System.out.println("Saved to: " + new String(out.toByteArray()));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InMemoryUserManager newManager = new InMemoryUserManager(null);
        newManager.load(in);
        UserProfile profile3 = new UserProfile();
        profile3.setUserType("guest");
        profile3.setUsername("user3");
        profile3.setPassword("whatever");
        TestUserManager.assertTrue((boolean)this.manager.getUsers().contains(this.profile1));
        TestUserManager.assertTrue((boolean)this.manager.getUsers().contains(this.profile2));
        TestUserManager.assertFalse((boolean)this.manager.getUsers().contains(profile3));
        TestUserManager.assertTrue((boolean)newManager.getUsers().contains(this.profile1));
        TestUserManager.assertTrue((boolean)newManager.getUsers().contains(this.profile2));
        TestUserManager.assertFalse((boolean)newManager.getUsers().contains(profile3));
    }

    public void testAuthenticate() {
        TestUserManager.assertEquals((String)"verify authentication succeeds", (Object)this.profile1, (Object)this.manager.authenticate("myuser1", "mypassword"));
        TestUserManager.assertNull((String)"verify authentication fails", (Object)this.manager.authenticate("myuser1", "mypassword_shouldfail"));
    }

    private static final class InMemoryUserManager
    extends UserManager {
        public InMemoryUserManager(String fileName) {
            super(fileName);
        }

        public void save(OutputStream out) {
            this.doSave(out);
        }

        public void load(InputStream in) {
            this.doLoad(in);
        }
    }
}

