/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console;

import org.apache.log4j.Logger;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.common.IUserInterface;
import org.gudy.azureus2.ui.common.UIConst;
import org.gudy.azureus2.ui.common.UITemplateHeadless;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.multiuser.UserManager;
import org.gudy.azureus2.ui.console.multiuser.commands.UserCommand;

public class UI
extends UITemplateHeadless
implements IUserInterface {
    private ConsoleInput console = null;

    public void init(boolean first, boolean others) {
        super.init(first, others);
        System.setProperty("java.awt.headless", "true");
    }

    public String[] processArgs(String[] args) {
        return args;
    }

    public void startUI() {
        super.startUI();
        TorrentDownloaderFactory.initManager(UIConst.getGlobalManager(), true, true, COConfigurationManager.getStringParameter("Default save path"));
        if (!this.isStarted() || this.console == null || !this.console.isAlive()) {
            System.out.println();
            this.console = new ConsoleInput("Main", UIConst.getAzureusCore(), System.in, System.out, Boolean.TRUE);
            if (System.getProperty("azureus.console.multiuser") != null) {
                UserManager manager = UserManager.getInstance(UIConst.getAzureusCore().getPluginManager().getDefaultPluginInterface());
                this.console.registerCommand(new UserCommand(manager));
            }
            this.console.printconsolehelp();
        }
    }

    public void openTorrent(String fileName) {
        if (this.console != null) {
            this.console.downloadTorrent(fileName);
            return;
        }
        if (fileName.toUpperCase().startsWith("HTTP://")) {
            System.out.println("Downloading torrent from url: " + fileName);
            TorrentDownloaderFactory.downloadManaged(fileName);
            return;
        }
        try {
            if (!FileUtil.isTorrentFile(fileName)) {
                Logger.getLogger((String)"azureus2.ui.console").error((Object)(fileName + " doesn't seem to be a torrent file. Not added."));
                return;
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"azureus2.ui.console").error((Object)("Something is wrong with " + fileName + ". Not added. (Reason: " + e.getMessage() + ")"));
            return;
        }
        if (UIConst.getGlobalManager() != null) {
            try {
                String downloadDir = COConfigurationManager.getDirectoryParameter("Default save path");
                System.out.println("Adding torrent: " + fileName + " and saving to " + downloadDir);
                UIConst.getGlobalManager().addDownloadManager(fileName, downloadDir);
            }
            catch (Exception e) {
                Logger.getLogger((String)"azureus2.ui.console").error((Object)("The torrent " + fileName + " could not be added."), (Throwable)e);
            }
        }
    }
}

