/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;

public class TrackerWebPageResponseImpl
implements TrackerWebPageResponse {
    protected static final String NL = "\r\n";
    protected OutputStream os;
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    protected String content_type = "text/html";
    protected int reply_status = 200;
    protected Map header_map = new HashMap();

    protected TrackerWebPageResponseImpl(OutputStream _os) {
        this.os = _os;
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        String formatted_date_now = format.format(new Date());
        this.setHeader("Last-Modified", formatted_date_now);
        this.setHeader("Expires", formatted_date_now);
    }

    public void setLastModified(long time) {
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        String formatted_date = format.format(new Date(time));
        this.setHeader("Last-Modified", formatted_date);
    }

    public void setExpires(long time) {
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        String formatted_date = format.format(new Date(time));
        this.setHeader("Expires", formatted_date);
    }

    public void setContentType(String type) {
        this.content_type = type;
    }

    public void setReplyStatus(int status) {
        this.reply_status = status;
    }

    public void setHeader(String name, String value) {
        this.header_map.put(name, value);
    }

    public OutputStream getOutputStream() {
        return this.baos;
    }

    protected void complete() throws IOException {
        byte[] reply_bytes = this.baos.toByteArray();
        String reply_header = "HTTP/1.1 " + this.reply_status + (this.reply_status == 200 || this.reply_status == 204 ? " OK" : " BAD") + NL;
        Iterator it = this.header_map.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = (String)this.header_map.get(name);
            reply_header = reply_header + name + ": " + value + NL;
        }
        reply_header = reply_header + "Server: Azureus 2.3.0.7_B51\r\nConnection: close\r\nContent-Type: " + this.content_type + NL + "Content-Length: " + reply_bytes.length + NL + NL;
        this.os.write(reply_header.getBytes());
        this.os.flush();
        this.os.write(reply_bytes);
        this.os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useFile(String root_dir, String relative_url) throws IOException {
        String target = root_dir + relative_url.replace('/', File.separatorChar);
        File canonical_file = new File(target).getCanonicalFile();
        if (!canonical_file.toString().startsWith(root_dir)) {
            return false;
        }
        if (canonical_file.isDirectory()) {
            return false;
        }
        if (canonical_file.canRead()) {
            String str = canonical_file.toString().toLowerCase();
            int pos = str.lastIndexOf(".");
            if (pos == -1) {
                return false;
            }
            String file_type = str.substring(pos + 1);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(canonical_file);
                this.useStream(file_type, fis);
                boolean bl = true;
                return bl;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return false;
    }

    public void useStream(String file_type, InputStream input_stream) throws IOException {
        int len;
        String response_type = TrackerWebPageResponseImpl.guessContentTypeFromFileType(file_type);
        OutputStream os = this.getOutputStream();
        this.setContentType(response_type);
        byte[] buffer = new byte[4096];
        while ((len = input_stream.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
    }

    public void writeTorrent(TrackerTorrent tracker_torrent) throws IOException {
        try {
            TRHostTorrent host_torrent = ((TrackerTorrentImpl)tracker_torrent).getHostTorrent();
            TOTorrent torrent = host_torrent.getTorrent();
            TOTorrent torrent_to_send = TOTorrentFactory.deserialiseFromMap(torrent.serialiseToMap());
            torrent_to_send.removeAdditionalProperties();
            if (!TorrentUtils.isDecentralised(torrent_to_send)) {
                URL[][] url_sets = TRTrackerUtils.getAnnounceURLs();
                if (host_torrent.getStatus() != 3 && url_sets.length > 0) {
                    String protocol = torrent_to_send.getAnnounceURL().getProtocol();
                    for (int i = 0; i < url_sets.length; ++i) {
                        URL[] urls = url_sets[i];
                        if (!urls[0].getProtocol().equalsIgnoreCase(protocol)) continue;
                        torrent_to_send.setAnnounceURL(urls[0]);
                        torrent_to_send.getAnnounceURLGroup().setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                        for (int j = 1; j < urls.length; ++j) {
                            TorrentUtils.announceGroupsInsertLast(torrent_to_send, new URL[]{urls[j]});
                        }
                        break;
                    }
                }
            }
            this.baos.write(BEncoder.encode(torrent_to_send.serialiseToMap()));
            this.setContentType("application/x-bittorrent");
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            throw new IOException(e.toString());
        }
    }

    public static String guessContentTypeFromFileType(String file_type) {
        String response_type = null;
        response_type = file_type == null ? "application/octet-stream" : (file_type.equals("html") || file_type.equals("htm") ? "text/html" : (file_type.equals("css") ? "text/css" : (file_type.equals("xml") ? "text/xml" : (file_type.equals("xsl") ? "text/xml" : (file_type.equals("jpg") || file_type.equals("jpeg") ? "image/jpeg" : (file_type.equals("gif") ? "image/gif" : (file_type.equals("tiff") ? "image/tiff" : (file_type.equals("bmp") ? "image/bmp" : (file_type.equals("png") ? "image/png" : (file_type.equals("torrent") || file_type.equals("tor") ? "application/x-bittorrent" : (file_type.equals("zip") ? "application/zip" : (file_type.equals("txt") ? "text/plain" : (file_type.equals("jar") ? "application/java-archive" : (file_type.equals("jnlp") ? "application/x-java-jnlp-file" : (file_type.equals("mp3") ? "audio/x-mpeg" : "application/octet-stream")))))))))))))));
        return response_type;
    }
}

