/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.messaging.MessageManagerListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;

public class MessageManagerImpl
implements MessageManager {
    private static final MessageManagerImpl instance = new MessageManagerImpl();
    private final HashMap compat_checks = new HashMap();
    private final DownloadManagerListener download_manager_listener = new DownloadManagerListener(){

        public void downloadAdded(Download dwnld) {
            dwnld.addPeerListener(new DownloadPeerListener(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void peerManagerAdded(Download download, PeerManager peer_manager) {
                    peer_manager.addListener(new PeerManagerListener(this, download){
                        private final /* synthetic */ Download val$download;
                        private final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = this$2;
                            this.val$download = val$download;
                        }

                        public void peerAdded(PeerManager manager, Peer peer) {
                            peer.addListener(new PeerListener(this, peer){
                                private final /* synthetic */ Peer val$peer;
                                private final /* synthetic */ 3 this$3;
                                {
                                    this.this$3 = this$3;
                                    this.val$peer = val$peer;
                                }

                                public void stateChanged(int new_state) {
                                    if (new_state == 30 && this.val$peer.supportsMessaging()) {
                                        Message[] messages = this.val$peer.getSupportedMessages();
                                        for (int i = 0; i < messages.length; ++i) {
                                            Message msg = messages[i];
                                            Iterator<Map.Entry<K, V>> it = MessageManagerImpl.access$300(1.access$200(2.access$100(3.access$000(this.this$3)))).entrySet().iterator();
                                            while (it.hasNext()) {
                                                Map.Entry<K, V> entry2 = it.next();
                                                Message message = (Message)entry2.getKey();
                                                if (!msg.getID().equals(message.getID())) continue;
                                                MessageManagerListener listener = (MessageManagerListener)entry2.getValue();
                                                listener.compatiblePeerFound(3.access$400(this.this$3), this.val$peer, message);
                                            }
                                        }
                                    }
                                }

                                public void sentBadChunk(int piece_num, int total_bad_chunks) {
                                }

                                public void addAvailability(boolean[] peerHavePieces) {
                                }

                                public void removeAvailability(boolean[] peerHavePieces) {
                                }
                            });
                        }

                        public void peerRemoved(PeerManager manager, Peer peer) {
                            Iterator<V> i = MessageManagerImpl.access$300(1.access$200(2.access$100(this.this$2))).values().iterator();
                            while (i.hasNext()) {
                                MessageManagerListener listener = (MessageManagerListener)i.next();
                                listener.peerRemoved(this.val$download, peer);
                            }
                        }

                        static /* synthetic */ 2 access$000(3 x0) {
                            return x0.this$2;
                        }

                        static /* synthetic */ Download access$400(3 x0) {
                            return x0.val$download;
                        }
                    });
                }

                public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                }

                static /* synthetic */ 1 access$100(2 x0) {
                    return x0.this$1;
                }
            });
        }

        public void downloadRemoved(Download download) {
        }

        static /* synthetic */ MessageManagerImpl access$200(1 x0) {
            return x0.MessageManagerImpl.this;
        }
    };

    public static MessageManagerImpl getSingleton() {
        return instance;
    }

    private MessageManagerImpl() {
    }

    public void registerMessageType(Message message) throws MessageException {
        try {
            com.aelitis.azureus.core.peermanager.messaging.MessageManager.getSingleton().registerMessageType(new MessageAdapter(message));
        }
        catch (com.aelitis.azureus.core.peermanager.messaging.MessageException me) {
            throw new MessageException(me.getMessage());
        }
    }

    public void deregisterMessageType(Message message) {
        com.aelitis.azureus.core.peermanager.messaging.MessageManager.getSingleton().deregisterMessageType(new MessageAdapter(message));
    }

    public void locateCompatiblePeers(PluginInterface plug_interface, Message message, MessageManagerListener listener) {
        this.compat_checks.put(message, listener);
        if (this.compat_checks.size() == 1) {
            plug_interface.getDownloadManager().addListener(this.download_manager_listener);
        }
    }

    public void cancelCompatiblePeersLocation(MessageManagerListener orig_listener) {
        Iterator it = this.compat_checks.values().iterator();
        while (it.hasNext()) {
            MessageManagerListener listener = (MessageManagerListener)it.next();
            if (listener != orig_listener) continue;
            it.remove();
            break;
        }
    }

    static /* synthetic */ HashMap access$300(MessageManagerImpl x0) {
        return x0.compat_checks;
    }
}

