/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class Timer
extends AERunnable {
    protected ThreadPool thread_pool;
    protected Set events = new TreeSet();
    protected long unique_id_next = 0L;
    protected volatile boolean destroyed;

    public Timer(String name) {
        this(name, 1);
    }

    public Timer(String name, int thread_pool_size) {
        this.thread_pool = new ThreadPool(name, thread_pool_size);
        Thread t = new Thread((Runnable)this, "Timer:" + name);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSupport() {
        block5: while (true) {
            try {
                block6: while (true) {
                    ArrayList<TimerEvent> events_to_run = new ArrayList<TimerEvent>();
                    Timer timer = this;
                    synchronized (timer) {
                        long now;
                        if (this.destroyed) {
                            break block5;
                        }
                        if (this.events.isEmpty()) {
                            this.wait();
                        } else {
                            now = SystemTime.getCurrentTime();
                            TimerEvent next_event = (TimerEvent)this.events.iterator().next();
                            long delay = next_event.getWhen() - now;
                            if (delay > 0L) {
                                this.wait(delay);
                            }
                        }
                        if (this.destroyed) {
                            break block5;
                        }
                        now = SystemTime.getCurrentTime();
                        Iterator it = this.events.iterator();
                        while (it.hasNext()) {
                            TimerEvent event = (TimerEvent)it.next();
                            if (event.getWhen() > now) continue;
                            events_to_run.add(event);
                            it.remove();
                        }
                    }
                    int i = 0;
                    while (true) {
                        if (i >= events_to_run.size()) continue block6;
                        TimerEvent ev = (TimerEvent)events_to_run.get(i);
                        ev.setHasRun();
                        this.thread_pool.run(ev.getRunnable());
                        ++i;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    public synchronized TimerEvent addEvent(long when, TimerEventPerformer performer) {
        return this.addEvent(SystemTime.getCurrentTime(), when, performer);
    }

    public synchronized TimerEvent addEvent(long creation_time, long when, TimerEventPerformer performer) {
        TimerEvent event = new TimerEvent(this, this.unique_id_next++, creation_time, when, performer);
        this.events.add(event);
        this.notify();
        return event;
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(long frequency, TimerEventPerformer performer) {
        TimerEventPeriodic periodic_performer = new TimerEventPeriodic(this, frequency, performer);
        return periodic_performer;
    }

    protected synchronized void cancelEvent(TimerEvent event) {
        if (this.events.contains(event)) {
            this.events.remove(event);
            this.notify();
        }
    }

    public synchronized void destroy() {
        this.destroyed = true;
        this.notify();
    }

    public synchronized void dump() {
        System.out.println("Timer '" + this.thread_pool.getName() + "': dump");
        Iterator it = this.events.iterator();
        while (it.hasNext()) {
            TimerEvent ev = (TimerEvent)it.next();
            System.out.println("\t" + ev + ": when = " + ev.getWhen() + ", run = " + ev.hasRun() + ", can = " + ev.isCancelled());
        }
    }
}

