/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.Collections;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonSem;
import org.gudy.azureus2.core3.util.Debug;

public class AEMonitor
extends AEMonSem {
    protected int dont_wait = 1;
    protected int nests = 0;
    protected Thread owner;
    protected Thread last_waiter;

    public AEMonitor(String _name) {
        super(_name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter() {
        if (DEBUG) {
            this.debugEntry();
        }
        Thread current_thread = Thread.currentThread();
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            ++this.entry_count;
            if (this.owner == current_thread) {
                ++this.nests;
            } else {
                if (this.dont_wait == 0) {
                    try {
                        ++this.waiting;
                        this.last_waiter = current_thread;
                        if (this.waiting > 1) {
                            // empty if block
                        }
                        this.wait();
                    }
                    catch (Throwable e) {
                        --this.waiting;
                        this.owner = current_thread;
                        Debug.out("**** monitor interrupted ****");
                        throw new RuntimeException("AEMonitor:interrupted");
                    }
                    finally {
                        this.last_waiter = null;
                    }
                } else {
                    --this.dont_wait;
                }
                this.owner = current_thread;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        try {
            AEMonitor aEMonitor = this;
            synchronized (aEMonitor) {
                if (this.nests > 0) {
                    if (DEBUG && this.owner != Thread.currentThread()) {
                        Debug.out("nested exit but current thread not owner");
                    }
                    --this.nests;
                } else {
                    this.owner = null;
                    if (this.waiting != 0) {
                        --this.waiting;
                        this.notify();
                    } else {
                        ++this.dont_wait;
                        if (this.dont_wait > 1) {
                            Debug.out("**** AEMonitor '" + this.name + "': multiple exit detected");
                        }
                    }
                }
            }
        }
        finally {
            if (DEBUG) {
                this.debugExit();
            }
        }
    }

    public boolean isHeld() {
        return this.owner == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaiters() {
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            return this.waiting > 0;
        }
    }

    public static Map getSynchronisedMap(Map m) {
        return Collections.synchronizedMap(m);
    }
}

