/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.dht;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.dht.TRTrackerDHTScraperResponseImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class TRTrackerDHTScraperImpl {
    protected static TRTrackerDHTScraperImpl singleton;
    protected static AEMonitor class_mon;
    private TRTrackerScraperImpl scraper;
    private Map responses = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerDHTScraperImpl create(TRTrackerScraperImpl _scraper) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerDHTScraperImpl(_scraper);
            }
            TRTrackerDHTScraperImpl tRTrackerDHTScraperImpl = singleton;
            return tRTrackerDHTScraperImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TRTrackerDHTScraperImpl(TRTrackerScraperImpl _scraper) {
        this.scraper = _scraper;
    }

    public void setScrape(TOTorrent torrent, URL url, DownloadScrapeResult result) {
        if (torrent != null && result != null) {
            try {
                TRTrackerDHTScraperResponseImpl resp = new TRTrackerDHTScraperResponseImpl(torrent.getHash(), result.getURL());
                resp.setSeedsPeers(result.getSeedCount(), result.getNonSeedCount());
                resp.setScrapeStartTime(result.getScrapeStartTime());
                resp.setNextScrapeStartTime(result.getNextScrapeStartTime());
                resp.setStatus(result.getResponseType() == 1 ? 2 : 1, result.getStatus());
                this.responses.put(torrent.getHashWrapper(), resp);
                this.scraper.scrapeReceived(resp);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, URL target_url, boolean force) {
        if (torrent != null) {
            try {
                return (TRTrackerScraperResponse)this.responses.get(torrent.getHashWrapper());
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public TRTrackerScraperResponse scrape(TRTrackerAnnouncer tracker_client) {
        TOTorrent torrent = tracker_client.getTorrent();
        if (torrent != null) {
            try {
                return (TRTrackerScraperResponse)this.responses.get(torrent.getHashWrapper());
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public void remove(TOTorrent torrent) {
        try {
            this.responses.remove(torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    static {
        class_mon = new AEMonitor("TRTrackerDHTScraper");
    }
}

