/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHandshake;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageEncoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZPeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTCancel;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTKeepAlive;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUninterested;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.peermanager.utils.AZPeerIdentityManager;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTHaveMessageAggregator;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandler;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import com.aelitis.azureus.core.peermanager.utils.PeerMessageLimiter;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.IPToHostNameResolverRequest;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionImpl;

public class PEPeerTransportProtocol
extends LogRelation
implements PEPeerTransport {
    protected static final LogIDs LOGID = LogIDs.PEER;
    private volatile int _lastPiece = -1;
    protected final PEPeerControl manager;
    protected final DiskManager diskManager;
    protected final PiecePicker piecePicker;
    protected int nbPieces = -1;
    private String peer_source;
    private byte[] peer_id;
    private String ip;
    protected String ip_resolved;
    private IPToHostNameResolverRequest ip_resolver_request;
    private int port;
    private PeerItem peer_item_identity;
    private int tcp_listen_port = 0;
    private int udp_listen_port = 0;
    protected final PEPeerStats peer_stats;
    private final ArrayList requested = new ArrayList();
    private final AEMonitor requested_mon = new AEMonitor("PEPeerTransportProtocol:Req");
    private HashMap data;
    private long lastNeededUndonePieceChange;
    protected boolean choked_by_other_peer = true;
    protected boolean choking_other_peer = true;
    private boolean interested_in_other_peer = false;
    private boolean other_peer_interested_in_me = false;
    private volatile long snubbed = 0L;
    private volatile BitFlags peerHavePieces = null;
    private volatile boolean availabilityAdded = false;
    private boolean seed = false;
    private boolean incoming;
    protected volatile boolean closing = false;
    private volatile int current_peer_state;
    protected NetworkConnection connection;
    private OutgoingBTPieceMessageHandler outgoing_piece_message_handler;
    private OutgoingBTHaveMessageAggregator outgoing_have_message_aggregator;
    private Connection plugin_connection;
    private boolean identityAdded = false;
    protected int connection_state = 0;
    private String client = "";
    private int uniquePiece = -1;
    private int reservedPiece = -1;
    private int spreadTimeHint = 0;
    protected long last_message_sent_time = 0L;
    protected long last_message_received_time = 0L;
    protected long last_data_message_received_time = -1L;
    protected long last_good_data_time = -1L;
    protected long last_data_message_sent_time = -1L;
    private long connection_established_time = 0L;
    private boolean az_messaging_mode = false;
    private Message[] supported_messages = null;
    private final AEMonitor closing_mon = new AEMonitor("PEPeerTransportProtocol:closing");
    private final AEMonitor data_mon = new AEMonitor("PEPeerTransportProtocol:data");
    private LinkedHashMap recent_outgoing_requests;
    private AEMonitor recent_outgoing_requests_mon;
    private static final boolean SHOW_DISCARD_RATE_STATS;
    private static int requests_discarded;
    private static int requests_discarded_endgame;
    private static int requests_recovered;
    private static int requests_completed;
    private List peer_listeners_cow;
    private final AEMonitor peer_listeners_mon = new AEMonitor("PEPeerTransportProtocol:PL");
    protected static boolean ENABLE_LAZY_BITFIELD;
    private boolean is_optimistic_unchoke = false;
    private PeerExchangerItem peer_exchange_item = null;
    private boolean peer_exchange_supported = false;
    protected PeerMessageLimiter message_limiter;

    public PEPeerTransportProtocol(PEPeerControl _manager, String _peer_source, NetworkConnection _connection) {
        this.manager = _manager;
        this.diskManager = this.manager.getDiskManager();
        this.piecePicker = this.manager.getPiecePicker();
        this.nbPieces = this.diskManager.getNbPieces();
        this.peer_source = _peer_source;
        this.ip = _connection.getAddress().getAddress().getHostAddress();
        this.port = _connection.getAddress().getPort();
        this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.port, PeerItem.convertSourceID(_peer_source), 0);
        this.incoming = true;
        this.connection = _connection;
        this.plugin_connection = new ConnectionImpl(this.connection);
        this.peer_stats = this.manager.createPeerStats();
        this.changePeerState(10);
        this.connection.connect(new NetworkConnection.ConnectionListener(){

            public void connectStarted() {
                PEPeerTransportProtocol.this.connection_state = 1;
            }

            public void connectSuccess() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LOGID, "In: Established incoming connection"));
                }
                PEPeerTransportProtocol.this.initializeConnection();
                PEPeerTransportProtocol.this.sendBTHandshake();
            }

            public void connectFailure(Throwable failure_msg) {
                Debug.out("ERROR: incoming connect failure: ", failure_msg);
                PEPeerTransportProtocol.this.closeConnectionInternally("ERROR: incoming connect failure [" + PEPeerTransportProtocol.this + "] : " + failure_msg.getMessage());
            }

            public void exceptionThrown(Throwable error) {
                if (error.getMessage() == null) {
                    Debug.out(error);
                }
                PEPeerTransportProtocol.this.closeConnectionInternally("connection exception: " + error.getMessage());
            }
        });
    }

    public PEPeerTransportProtocol(PEPeerControl _manager, String _peer_source, String _ip, int _port, boolean require_crypto_handshake) {
        boolean use_crypto;
        this.manager = _manager;
        this.diskManager = this.manager.getDiskManager();
        this.piecePicker = this.manager.getPiecePicker();
        this.nbPieces = this.diskManager.getNbPieces();
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this.peer_source = _peer_source;
        this.ip = _ip;
        this.port = _port;
        this.tcp_listen_port = _port;
        this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.tcp_listen_port, PeerItem.convertSourceID(_peer_source), 0);
        this.incoming = false;
        this.peer_stats = this.manager.createPeerStats();
        if (this.port < 0 || this.port > 65535) {
            this.closeConnectionInternally("given remote port is invalid: " + this.port);
            return;
        }
        boolean bl = use_crypto = require_crypto_handshake || NetworkManager.REQUIRE_CRYPTO_HANDSHAKE;
        if (this.isLANLocal()) {
            use_crypto = false;
        }
        this.connection = NetworkManager.getSingleton().createConnection(new InetSocketAddress(this.ip, this.port), new BTMessageEncoder(), new BTMessageDecoder(), use_crypto, !require_crypto_handshake, this.manager.getTorrentHash());
        this.plugin_connection = new ConnectionImpl(this.connection);
        this.changePeerState(10);
        this.connection.connect(new NetworkConnection.ConnectionListener(){

            public void connectStarted() {
                PEPeerTransportProtocol.this.connection_state = 1;
            }

            public void connectSuccess() {
                if (PEPeerTransportProtocol.this.closing) {
                    return;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LOGID, "Out: Established outgoing connection"));
                }
                PEPeerTransportProtocol.this.initializeConnection();
                PEPeerTransportProtocol.this.sendBTHandshake();
            }

            public void connectFailure(Throwable failure_msg) {
                PEPeerTransportProtocol.this.closeConnectionInternally("failed to establish outgoing connection: " + failure_msg.getMessage());
            }

            public void exceptionThrown(Throwable error) {
                if (error.getMessage() == null) {
                    Debug.out(error);
                }
                PEPeerTransportProtocol.this.closeConnectionInternally("connection exception: " + error.getMessage());
            }
        });
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Out: Creating outgoing connection"));
        }
    }

    protected void initializeConnection() {
        if (this.closing) {
            return;
        }
        this.recent_outgoing_requests = new LinkedHashMap(16, 0.75f, true){

            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 16;
            }
        };
        this.recent_outgoing_requests_mon = new AEMonitor("PEPeerTransportProtocol:ROR");
        this.message_limiter = new PeerMessageLimiter();
        this.outgoing_piece_message_handler = new OutgoingBTPieceMessageHandler(this.diskManager, this.connection.getOutgoingMessageQueue());
        this.outgoing_have_message_aggregator = new OutgoingBTHaveMessageAggregator(this.connection.getOutgoingMessageQueue());
        this.connection_established_time = SystemTime.getCurrentTime();
        this.connection_state = 2;
        this.changePeerState(20);
        this.registerForMessageHandling();
    }

    public String getPeerSource() {
        return this.peer_source;
    }

    protected void closeConnectionInternally(String reason) {
        this.performClose(reason, false);
    }

    public void closeConnection(String reason) {
        this.performClose(reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performClose(String reason, boolean externally_closed) {
        try {
            this.closing_mon.enter();
            if (this.closing) {
                return;
            }
            this.closing = true;
            if (this.identityAdded) {
                if (this.peer_id != null) {
                    PeerIdentityManager.removeIdentity(this.manager.getPeerIdentityDataID(), this.peer_id);
                } else {
                    Debug.out("PeerIdentity added but peer_id == null !!!");
                }
                this.identityAdded = false;
            }
            this.changePeerState(40);
        }
        finally {
            this.closing_mon.exit();
        }
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.destroy();
        }
        if (this.peer_exchange_item != null) {
            this.peer_exchange_item.destroy();
        }
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.destroy();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        this.cancelRequests();
        if (this.ip_resolver_request != null) {
            this.ip_resolver_request.cancel();
        }
        this.removeAvailability();
        this.changePeerState(50);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Peer connection closed: " + reason));
        }
        if (!externally_closed) {
            this.manager.peerConnectionClosed(this);
        }
    }

    private void addAvailability() {
        List peer_listeners_ref;
        if (!this.availabilityAdded && !this.closing && this.peerHavePieces != null && this.current_peer_state == 30 && (peer_listeners_ref = this.peer_listeners_cow) != null) {
            for (int i = 0; i < peer_listeners_ref.size(); ++i) {
                PEPeerListener peerListener = (PEPeerListener)peer_listeners_ref.get(i);
                peerListener.addAvailability(this, this.peerHavePieces);
            }
            this.availabilityAdded = true;
        }
    }

    private void removeAvailability() {
        if (this.availabilityAdded && this.peerHavePieces != null) {
            List peer_listeners_ref = this.peer_listeners_cow;
            if (peer_listeners_ref != null) {
                for (int i = 0; i < peer_listeners_ref.size(); ++i) {
                    PEPeerListener peerListener = (PEPeerListener)peer_listeners_ref.get(i);
                    peerListener.removeAvailability(this, this.peerHavePieces);
                }
            }
            this.availabilityAdded = false;
        }
        this.peerHavePieces = null;
    }

    protected void sendBTHandshake() {
        this.connection.getOutgoingMessageQueue().addMessage(new BTHandshake(this.manager.getHash(), this.manager.getPeerId(), this.manager.isAZMessagingEnabled()), false);
    }

    private void sendAZHandshake() {
        Message[] avail_msgs = MessageManager.getSingleton().getRegisteredMessages();
        String[] avail_ids = new String[avail_msgs.length];
        byte[] avail_vers = new byte[avail_msgs.length];
        for (int i = 0; i < avail_msgs.length; ++i) {
            avail_ids[i] = avail_msgs[i].getID();
            avail_vers[i] = 1;
        }
        int local_udp_port = 0;
        try {
            PluginInterface dht_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi != null) {
                DHTPlugin dht = (DHTPlugin)dht_pi.getPlugin();
                local_udp_port = dht.getPort();
            }
        }
        catch (Throwable t) {
            Debug.out("Exception while obtaining local udp listen port from DHTPlugin:", t);
        }
        AZHandshake az_handshake = new AZHandshake(AZPeerIdentityManager.getAZPeerIdentity(), "Azureus", "2.3.0.7_B51", COConfigurationManager.getIntParameter("TCP.Listen.Port"), local_udp_port, avail_ids, avail_vers, NetworkManager.REQUIRE_CRYPTO_HANDSHAKE ? 1 : 0);
        this.connection.getOutgoingMessageQueue().addMessage(az_handshake, false);
    }

    public int getPeerState() {
        return this.current_peer_state;
    }

    public boolean isDownloadPossible() {
        if (!this.closing) {
            if (this.lastNeededUndonePieceChange < this.piecePicker.getNeededUndonePieceChange()) {
                this.checkInterested();
                this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
            }
            if (this.interested_in_other_peer && !this.choked_by_other_peer && this.current_peer_state == 30) {
                return true;
            }
        }
        return false;
    }

    public int getPercentDoneInThousandNotation() {
        if (this.peerHavePieces == null || this.peerHavePieces.length < 1) {
            return 0;
        }
        return this.peerHavePieces.nbSet * 1000 / this.peerHavePieces.length;
    }

    public boolean transferAvailable() {
        return !this.choked_by_other_peer && this.interested_in_other_peer;
    }

    private void printRequestStats() {
        if (SHOW_DISCARD_RATE_STATS) {
            float discard_perc = (float)requests_discarded * 100.0f / ((float)(requests_completed + requests_recovered + requests_discarded) * 1.0f);
            float discard_perc_end = (float)requests_discarded_endgame * 100.0f / ((float)(requests_completed + requests_recovered + requests_discarded_endgame) * 1.0f);
            float recover_perc = (float)requests_recovered * 100.0f / ((float)(requests_recovered + requests_discarded) * 1.0f);
            System.out.println("c=" + requests_completed + " d=" + requests_discarded + " de=" + requests_discarded_endgame + " r=" + requests_recovered + " dp=" + discard_perc + "% dpe=" + discard_perc_end + "% rp=" + recover_perc + "%");
        }
    }

    private void checkSeed() {
        this.seed = this.peerHavePieces != null && this.peerHavePieces.nbSet > 0 ? this.peerHavePieces.nbSet == this.peerHavePieces.length : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean request(int pieceNumber, int pieceOffset, int pieceLength) {
        if (this.current_peer_state != 30) {
            this.manager.requestCanceled(this.manager.createDiskManagerRequest(pieceNumber, pieceOffset, pieceLength));
            return false;
        }
        DiskManagerReadRequest request2 = this.manager.createDiskManagerRequest(pieceNumber, pieceOffset, pieceLength);
        if (!this.hasBeenRequested(request2)) {
            this.addRequest(request2);
            try {
                this.recent_outgoing_requests_mon.enter();
                this.recent_outgoing_requests.put(request2, null);
            }
            finally {
                this.recent_outgoing_requests_mon.exit();
            }
            this.connection.getOutgoingMessageQueue().addMessage(new BTRequest(pieceNumber, pieceOffset, pieceLength), false);
            return true;
        }
        return false;
    }

    public void sendCancel(DiskManagerReadRequest request2) {
        if (this.current_peer_state != 30) {
            return;
        }
        if (this.hasBeenRequested(request2)) {
            this.removeRequest(request2);
            this.connection.getOutgoingMessageQueue().addMessage(new BTCancel(request2.getPieceNumber(), request2.getOffset(), request2.getLength()), false);
        }
    }

    public void sendHave(int pieceNumber) {
        if (this.current_peer_state != 30) {
            return;
        }
        boolean force = !this.other_peer_interested_in_me && this.peerHavePieces != null && !this.peerHavePieces.flags[pieceNumber];
        this.outgoing_have_message_aggregator.queueHaveMessage(pieceNumber, force);
        this.checkInterested();
    }

    public void sendChoke() {
        if (this.current_peer_state != 30) {
            return;
        }
        this.outgoing_piece_message_handler.removeAllPieceRequests();
        this.connection.getOutgoingMessageQueue().addMessage(new BTChoke(), false);
        this.choking_other_peer = true;
        this.is_optimistic_unchoke = false;
    }

    public void sendUnChoke() {
        if (this.current_peer_state != 30) {
            return;
        }
        this.connection.getOutgoingMessageQueue().addMessage(new BTUnchoke(), false);
        this.choking_other_peer = false;
    }

    private void sendKeepAlive() {
        if (this.current_peer_state != 30) {
            return;
        }
        if (this.outgoing_have_message_aggregator.hasPending()) {
            this.outgoing_have_message_aggregator.forceSendOfPending();
        } else {
            this.connection.getOutgoingMessageQueue().addMessage(new BTKeepAlive(), false);
        }
    }

    public void checkInterested() {
        if (this.closing || this.peerHavePieces == null || this.peerHavePieces.nbSet == 0) {
            return;
        }
        boolean is_interesting = false;
        if (this.piecePicker.hasDownloadablePiece()) {
            if (!this.seed) {
                for (int i = this.peerHavePieces.start; i <= this.peerHavePieces.end; ++i) {
                    if (!this.peerHavePieces.flags[i] || !this.diskManager.isInteresting(i)) continue;
                    is_interesting = true;
                    break;
                }
            } else {
                is_interesting = true;
            }
        }
        if (is_interesting && !this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(), false);
        } else if (!is_interesting && this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTUninterested(), false);
        }
        this.interested_in_other_peer = is_interesting;
    }

    private void checkInterested(int pieceNumber) {
        if (this.closing) {
            return;
        }
        boolean is_interesting = this.diskManager.isInteresting(pieceNumber);
        if (is_interesting && !this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(), false);
        } else if (!is_interesting && this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTUninterested(), false);
        }
        this.interested_in_other_peer = is_interesting;
    }

    private void sendBitField() {
        int i;
        if (this.closing) {
            return;
        }
        if (this.manager.isSuperSeedMode()) {
            return;
        }
        ArrayList<Integer> lazies = null;
        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)12, (this.nbPieces + 7) / 8);
        DiskManagerPiece[] pieces = this.diskManager.getPieces();
        int bToSend = 0;
        for (i = 0; i < pieces.length; ++i) {
            if (i % 8 == 0) {
                bToSend = 0;
            }
            bToSend <<= 1;
            if (pieces[i].isDone()) {
                if (ENABLE_LAZY_BITFIELD) {
                    if (i < 8 || i >= pieces.length - pieces.length % 8) {
                        if (lazies == null) {
                            lazies = new ArrayList<Integer>();
                        }
                        lazies.add(new Integer(i));
                    } else {
                        ++bToSend;
                    }
                } else {
                    ++bToSend;
                }
            }
            if (i % 8 != 7) continue;
            buffer.put((byte)6, (byte)bToSend);
        }
        if (i % 8 != 0) {
            buffer.put((byte)6, (byte)(bToSend <<= 8 - i % 8));
        }
        buffer.flip((byte)6);
        this.connection.getOutgoingMessageQueue().addMessage(new BTBitfield(buffer), false);
        if (lazies != null) {
            for (int x = 0; x < lazies.size(); ++x) {
                Integer num = (Integer)lazies.get(x);
                this.connection.getOutgoingMessageQueue().addMessage(new BTHave(num), false);
            }
        }
    }

    public byte[] getId() {
        return this.peer_id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public int getTCPListenPort() {
        return this.tcp_listen_port;
    }

    public int getUDPListenPort() {
        return this.udp_listen_port;
    }

    public String getClient() {
        return this.client;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public boolean isOptimisticUnchoke() {
        return this.is_optimistic_unchoke && !this.isChokedByMe();
    }

    public void setOptimisticUnchoke(boolean is_optimistic) {
        this.is_optimistic_unchoke = is_optimistic;
    }

    public PEPeerControl getControl() {
        return this.manager;
    }

    public PEPeerManager getManager() {
        return this.manager;
    }

    public PEPeerStats getStats() {
        return this.peer_stats;
    }

    public BitFlags getAvailable() {
        return this.peerHavePieces;
    }

    public boolean isPieceAvailable(int pieceNumber) {
        if (this.peerHavePieces != null) {
            return this.peerHavePieces.flags[pieceNumber];
        }
        return false;
    }

    public boolean isChokingMe() {
        return this.choked_by_other_peer;
    }

    public boolean isChokedByMe() {
        return this.choking_other_peer;
    }

    public boolean isInteresting() {
        return this.interested_in_other_peer;
    }

    public boolean isInterested() {
        return this.other_peer_interested_in_me;
    }

    public boolean isSeed() {
        return this.seed;
    }

    public boolean isSnubbed() {
        return this.snubbed != 0L;
    }

    public long getSnubbedTime() {
        if (this.snubbed == 0L) {
            return 0L;
        }
        long now = SystemTime.getCurrentTime();
        if (now < this.snubbed) {
            this.snubbed = now - 26L;
        }
        return now - this.snubbed;
    }

    public void setSnubbed(boolean b) {
        if (!b) {
            this.snubbed = 0L;
        } else if (this.snubbed == 0L) {
            this.snubbed = SystemTime.getCurrentTime();
        }
    }

    public void setUploadHint(int spreadTime) {
        this.spreadTimeHint = spreadTime;
    }

    public int getUploadHint() {
        return this.spreadTimeHint;
    }

    public void setUniqueAnnounce(int _uniquePiece) {
        this.uniquePiece = _uniquePiece;
    }

    public int getUniqueAnnounce() {
        return this.uniquePiece;
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        try {
            this.data_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.data_mon.exit();
        }
    }

    public String getIPHostName() {
        if (this.ip_resolved == null) {
            this.ip_resolved = this.ip;
            this.ip_resolver_request = IPToHostNameResolver.addResolverRequest(this.ip_resolved, new IPToHostNameResolverListener(){

                public void IPResolutionComplete(String res, boolean ok) {
                    PEPeerTransportProtocol.this.ip_resolved = res;
                }
            });
        }
        return this.ip_resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRequests() {
        if (this.requested != null) {
            try {
                this.requested_mon.enter();
                for (int i = this.requested.size() - 1; i >= 0; --i) {
                    DiskManagerReadRequest request2 = (DiskManagerReadRequest)this.requested.remove(i);
                    this.manager.requestCanceled(request2);
                }
            }
            finally {
                this.requested_mon.exit();
            }
        }
        if (!this.closing) {
            Message[] type = new Message[]{new BTRequest(-1, -1, -1)};
            this.connection.getOutgoingMessageQueue().removeMessagesOfType(type, false);
        }
    }

    public int getNbRequests() {
        return this.requested.size();
    }

    public List getExpiredRequests() {
        ArrayList<DiskManagerReadRequest> result = null;
        try {
            for (int i = 0; i < this.requested.size(); ++i) {
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)this.requested.get(i);
                if (!request2.isExpired()) continue;
                if (result == null) {
                    result = new ArrayList<DiskManagerReadRequest>();
                }
                result.add(request2);
            }
            return result;
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasBeenRequested(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            boolean bl = this.requested.contains(request2);
            return bl;
        }
        finally {
            this.requested_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequest(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            this.requested.add(request2);
        }
        finally {
            this.requested_mon.exit();
        }
        this._lastPiece = request2.getPieceNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRequest(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            this.requested.remove(request2);
        }
        finally {
            this.requested_mon.exit();
        }
        BTRequest msg = new BTRequest(request2.getPieceNumber(), request2.getOffset(), request2.getLength());
        this.connection.getOutgoingMessageQueue().removeMessage(msg, false);
        msg.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reSetRequestsTime() {
        try {
            this.requested_mon.enter();
            for (int i = 0; i < this.requested.size(); ++i) {
                DiskManagerReadRequest request2 = null;
                try {
                    request2 = (DiskManagerReadRequest)this.requested.get(i);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                if (request2 == null) continue;
                request2.reSetTime();
            }
        }
        finally {
            this.requested_mon.exit();
        }
    }

    public String toString() {
        if (this.connection != null && this.connection.isConnected()) {
            return this.connection + " [" + this.client + "]";
        }
        return this.ip + ":" + this.port + " [" + this.client + "]";
    }

    public void doKeepAliveCheck() {
        long wait_time = SystemTime.getCurrentTime() - this.last_message_sent_time;
        if (this.last_message_sent_time == 0L || wait_time < 0L) {
            this.last_message_sent_time = SystemTime.getCurrentTime();
            return;
        }
        if (wait_time > 120000L) {
            this.sendKeepAlive();
            this.last_message_sent_time = SystemTime.getCurrentTime();
        }
    }

    public boolean doTimeoutChecks() {
        if (this.connection_state == 4) {
            long dead_time = SystemTime.getCurrentTime() - this.last_message_received_time;
            if (dead_time < 0L) {
                this.last_message_received_time = SystemTime.getCurrentTime();
                return false;
            }
            if (dead_time > 300000L) {
                this.closeConnectionInternally("timed out while waiting for messages");
                return true;
            }
        } else if (this.connection_state == 2) {
            long wait_time = SystemTime.getCurrentTime() - this.connection_established_time;
            if (wait_time < 0L) {
                this.connection_established_time = SystemTime.getCurrentTime();
                return false;
            }
            if (wait_time > 180000L) {
                this.closeConnectionInternally("timed out while waiting for handshake");
                return true;
            }
        }
        return false;
    }

    public void doPerformanceTuningCheck() {
        if (this.peer_stats != null && this.outgoing_piece_message_handler != null) {
            long send_rate = this.peer_stats.getDataSendRate() + this.peer_stats.getProtocolSendRate();
            if (send_rate >= 3125000L) {
                this.connection.getTCPTransport().setTransportMode(2);
                this.outgoing_piece_message_handler.setRequestReadAhead(256);
            } else if (send_rate >= 1250000L) {
                this.connection.getTCPTransport().setTransportMode(2);
                this.outgoing_piece_message_handler.setRequestReadAhead(128);
            } else if (send_rate >= 125000L) {
                if (this.connection.getTCPTransport().getTransportMode() < 1) {
                    this.connection.getTCPTransport().setTransportMode(1);
                }
                this.outgoing_piece_message_handler.setRequestReadAhead(32);
            } else if (send_rate >= 62500L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(16);
            } else if (send_rate >= 31250L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(8);
            } else if (send_rate >= 12500L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(4);
            } else {
                this.outgoing_piece_message_handler.setRequestReadAhead(2);
            }
            long receive_rate = this.peer_stats.getDataReceiveRate() + this.peer_stats.getProtocolReceiveRate();
            if (receive_rate >= 1250000L) {
                this.connection.getTCPTransport().setTransportMode(2);
            } else if (receive_rate >= 125000L && this.connection.getTCPTransport().getTransportMode() < 1) {
                this.connection.getTCPTransport().setTransportMode(1);
            }
        }
    }

    public int getConnectionState() {
        return this.connection_state;
    }

    public long getTimeSinceLastDataMessageReceived() {
        if (this.last_data_message_received_time == -1L) {
            return -1L;
        }
        long time_since = SystemTime.getCurrentTime() - this.last_data_message_received_time;
        if (time_since < 0L) {
            this.last_data_message_received_time = SystemTime.getCurrentTime();
            time_since = 0L;
        }
        return time_since;
    }

    public long getTimeSinceGoodDataReceived() {
        if (this.last_good_data_time == -1L) {
            return -1L;
        }
        long now = SystemTime.getCurrentTime();
        long time_since = now - this.last_good_data_time;
        if (time_since < 0L) {
            this.last_good_data_time = now;
            time_since = 0L;
        }
        return time_since;
    }

    public long getTimeSinceLastDataMessageSent() {
        if (this.last_data_message_sent_time == -1L) {
            return -1L;
        }
        long time_since = SystemTime.getCurrentTime() - this.last_data_message_sent_time;
        if (time_since < 0L) {
            this.last_data_message_sent_time = SystemTime.getCurrentTime();
            time_since = 0L;
        }
        return time_since;
    }

    public long getTimeSinceConnectionEstablished() {
        if (this.connection_established_time == 0L) {
            return 0L;
        }
        long time = SystemTime.getCurrentTime() - this.connection_established_time;
        if (time < 0L) {
            this.connection_established_time = SystemTime.getCurrentTime();
            time = 0L;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeBTHandshake(BTHandshake handshake) {
        String msg;
        boolean same_allowed;
        PeerIdentityDataID my_peer_data_id = this.manager.getPeerIdentityDataID();
        if (!Arrays.equals(this.manager.getHash(), handshake.getDataHash())) {
            this.closeConnectionInternally("handshake has wrong infohash");
            handshake.destroy();
            return;
        }
        this.peer_id = handshake.getPeerId();
        this.client = PeerClassifier.getClientDescription(this.peer_id);
        if (!PeerClassifier.isClientTypeAllowed(this.client)) {
            this.closeConnectionInternally(this.client + " client type not allowed to connect, banned");
            handshake.destroy();
            return;
        }
        if (Arrays.equals(this.manager.getPeerId(), this.peer_id)) {
            this.manager.peerVerifiedAsSelf(this);
            this.closeConnectionInternally("given peer id matches myself");
            handshake.destroy();
            return;
        }
        boolean sameIdentity = PeerIdentityManager.containsIdentity(my_peer_data_id, this.peer_id);
        boolean sameIP = false;
        boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || this.ip.equals("127.0.0.1");
        if (!same_allowed && PeerIdentityManager.containsIPAddress(my_peer_data_id, this.ip)) {
            sameIP = true;
        }
        if (sameIdentity) {
            PEPeerTransport existing;
            boolean close = true;
            if (this.connection.isLANLocal() && (existing = this.manager.getTransportFromIdentity(this.peer_id)) != null && !existing.isLANLocal()) {
                Debug.out("dropping existing non-lanlocal peer connection [" + existing + "]");
                this.manager.removePeer(existing);
                close = false;
            }
            if (close) {
                this.closeConnectionInternally("peer matches already-connected peer id");
                handshake.destroy();
                return;
            }
        }
        if (sameIP) {
            this.closeConnectionInternally("peer matches already-connected IP address, duplicate connections not allowed");
            handshake.destroy();
            return;
        }
        int maxAllowed = this.manager.getMaxNewConnectionsAllowed();
        if (maxAllowed == 0) {
            msg = "too many existing peer connections [p" + PeerIdentityManager.getIdentityCount(my_peer_data_id) + "/g" + PeerIdentityManager.getTotalIdentityCount() + ", pmx" + PeerUtils.MAX_CONNECTIONS_PER_TORRENT + "/gmx" + PeerUtils.MAX_CONNECTIONS_TOTAL + "/dmx" + this.manager.getMaxConnections() + "]";
            this.closeConnectionInternally(msg);
            handshake.destroy();
            return;
        }
        try {
            this.closing_mon.enter();
            if (this.closing) {
                msg = "connection already closing";
                this.closeConnectionInternally(msg);
                handshake.destroy();
                return;
            }
            if (!PeerIdentityManager.addIdentity(my_peer_data_id, this.peer_id, this.ip)) {
                this.closeConnectionInternally("peer matches already-connected peer id");
                handshake.destroy();
                return;
            }
            this.identityAdded = true;
        }
        finally {
            this.closing_mon.exit();
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "In: has sent their handshake"));
        }
        if ((handshake.getReserved()[0] & 0x80) == 128) {
            if (!this.manager.isAZMessagingEnabled()) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LOGID, "Ignoring peer's extended AZ messaging support, as disabled for this download."));
                }
            } else if (this.client.indexOf("Plus!") != -1) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LOGID, "Handshake mistakingly indicates extended AZ messaging support...ignoring."));
                }
            } else {
                if (Logger.isEnabled() && this.client.indexOf("Azureus") == -1) {
                    Logger.log(new LogEvent(this, LOGID, "Handshake claims extended AZ messaging support....enabling AZ mode."));
                }
                this.az_messaging_mode = true;
                this.connection.getIncomingMessageQueue().setDecoder(new AZMessageDecoder());
                this.connection.getOutgoingMessageQueue().setEncoder(new AZMessageEncoder());
                this.sendAZHandshake();
            }
        }
        handshake.destroy();
        if (!this.az_messaging_mode) {
            this.connection.getIncomingMessageQueue().resumeQueueProcessing();
            this.changePeerState(30);
            this.connection_state = 4;
            this.sendBitField();
            this.addAvailability();
        }
    }

    protected void decodeAZHandshake(AZHandshake handshake) {
        this.client = handshake.getClient() + " " + handshake.getClientVersion();
        if (handshake.getTCPListenPort() > 0) {
            this.tcp_listen_port = handshake.getTCPListenPort();
            this.udp_listen_port = handshake.getUDPListenPort();
            int type = handshake.getHandshakeType() == 1 ? 1 : 0;
            this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.tcp_listen_port, PeerItem.convertSourceID(this.peer_source), type);
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 0; i < handshake.getMessageIDs().length; ++i) {
            Message msg = MessageManager.getSingleton().lookupMessage(handshake.getMessageIDs()[i]);
            if (msg == null) continue;
            messages.add(msg);
        }
        this.supported_messages = messages.toArray(new Message[messages.size()]);
        this.changePeerState(30);
        this.connection_state = 4;
        this.sendBitField();
        handshake.destroy();
        this.addAvailability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeBitfield(BTBitfield bitfield) {
        DirectByteBuffer field = bitfield.getBitfield();
        byte[] dataf = new byte[(this.nbPieces + 7) / 8];
        if (field.remaining((byte)9) < dataf.length) {
            String error = this.toString() + " has sent invalid Bitfield: too short [" + field.remaining((byte)9) + "<" + dataf.length + "]";
            Debug.out(error);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, error));
            }
            bitfield.destroy();
            return;
        }
        field.get((byte)9, dataf);
        try {
            this.closing_mon.enter();
            if (this.closing) {
                bitfield.destroy();
            } else {
                BitFlags tempHavePieces;
                if (this.peerHavePieces == null) {
                    tempHavePieces = new BitFlags(this.nbPieces);
                } else {
                    tempHavePieces = this.peerHavePieces;
                    this.removeAvailability();
                }
                for (int i = 0; i < this.nbPieces; ++i) {
                    int index = i / 8;
                    byte bData = dataf[index];
                    int bit = 7 - i % 8;
                    byte b = (byte)(bData >> bit);
                    if ((b & 1) != 1) continue;
                    tempHavePieces.set(i);
                    this.manager.updateSuperSeedPiece(this, i);
                }
                bitfield.destroy();
                this.peerHavePieces = tempHavePieces;
                this.addAvailability();
                this.checkSeed();
                this.checkInterested();
            }
        }
        finally {
            this.closing_mon.exit();
        }
    }

    protected void decodeChoke(BTChoke choke) {
        choke.destroy();
        this.choked_by_other_peer = true;
        this.cancelRequests();
    }

    protected void decodeUnchoke(BTUnchoke unchoke) {
        unchoke.destroy();
        this.choked_by_other_peer = false;
    }

    protected void decodeInterested(BTInterested interested) {
        interested.destroy();
        if (!this.seed) {
            this.other_peer_interested_in_me = true;
        }
    }

    protected void decodeUninterested(BTUninterested uninterested) {
        uninterested.destroy();
        this.other_peer_interested_in_me = false;
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.forceSendOfPending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeHave(BTHave have) {
        int piece_number = have.getPieceNumber();
        have.destroy();
        if (piece_number >= this.nbPieces || piece_number < 0) {
            this.closeConnectionInternally("invalid piece_number: " + piece_number);
            return;
        }
        try {
            this.closing_mon.enter();
            if (this.closing) {
                return;
            }
            if (this.peerHavePieces == null) {
                this.peerHavePieces = new BitFlags(this.nbPieces);
            }
            if (!this.peerHavePieces.flags[piece_number]) {
                this.peerHavePieces.set(piece_number);
                int pieceLength = this.manager.getPieceLength(piece_number);
                this.peer_stats.hasNewPiece(pieceLength);
                this.manager.havePiece(piece_number, pieceLength, this);
            }
            this.checkSeed();
            if (!this.interested_in_other_peer) {
                this.checkInterested(piece_number);
            }
        }
        finally {
            this.closing_mon.exit();
        }
    }

    protected void decodeRequest(BTRequest request2) {
        int number = request2.getPieceNumber();
        int offset = request2.getPieceOffset();
        int length = request2.getLength();
        request2.destroy();
        if (!this.manager.checkBlock(number, offset, length)) {
            this.closeConnectionInternally("request for piece #" + number + ":" + offset + "->" + (offset + length - 1) + " is an invalid request");
            return;
        }
        if (!this.choking_other_peer) {
            this.outgoing_piece_message_handler.addPieceRequest(number, offset, length);
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Protocol:In: peer request for piece #" + number + ":" + offset + "->" + (offset + length - 1) + " ignored as peer is currently choked."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodePiece(BTPiece piece) {
        int pieceNumber = piece.getPieceNumber();
        int offset = piece.getPieceOffset();
        DirectByteBuffer payload = piece.getPieceData();
        int length = payload.remaining((byte)9);
        String error_msg = "Peer has sent piece #" + pieceNumber + ":" + offset + "->" + (offset + length - 1) + ", ";
        if (!this.manager.checkBlock(pieceNumber, offset, payload)) {
            this.peer_stats.bytesDiscarded(length);
            this.manager.discarded(length);
            ++requests_discarded;
            this.printRequestStats();
            piece.destroy();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Protocol:In: " + error_msg + "but piece block discarded as invalid."));
            }
            return;
        }
        PEPiece pePiece = this.manager.getPiece(pieceNumber);
        if (pePiece != null) {
            pePiece.setDownloaded(offset);
        }
        DiskManagerReadRequest request2 = this.manager.createDiskManagerRequest(pieceNumber, offset, length);
        boolean piece_error = true;
        if (this.hasBeenRequested(request2)) {
            this.removeRequest(request2);
            this.reSetRequestsTime();
            if (this.manager.isWritten(pieceNumber, offset)) {
                this.peer_stats.bytesDiscarded(length);
                this.manager.discarded(length);
                if (this.manager.isInEndGameMode()) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 0, "Protocol:In: " + error_msg + "but piece block ignored as " + "already written in end-game mode."));
                    }
                    ++requests_discarded_endgame;
                } else {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 1, "Protocol:In: " + error_msg + "but piece block discarded as " + "already written."));
                    }
                    ++requests_discarded;
                }
                this.printRequestStats();
            } else {
                this.manager.writeBlock(pieceNumber, offset, payload, this, false);
                long now = SystemTime.getCurrentTime();
                if (this.last_good_data_time != -1L && now - this.last_good_data_time < 60000L) {
                    this.setSnubbed(false);
                }
                ++requests_completed;
                piece_error = false;
                this.last_good_data_time = now;
            }
        } else if (!this.manager.isWritten(pieceNumber, offset)) {
            boolean ever_requested;
            try {
                this.recent_outgoing_requests_mon.enter();
                ever_requested = this.recent_outgoing_requests.containsKey(request2);
            }
            finally {
                this.recent_outgoing_requests_mon.exit();
            }
            if (ever_requested) {
                this.manager.writeBlock(pieceNumber, offset, payload, this, true);
                long now = SystemTime.getCurrentTime();
                if (this.last_good_data_time != -1L && now - this.last_good_data_time < 60000L) {
                    this.setSnubbed(false);
                }
                this.reSetRequestsTime();
                ++requests_recovered;
                this.printRequestStats();
                piece_error = false;
                this.last_good_data_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LogIDs.PIECES, "Protocol:In: " + error_msg + "expired piece block data " + "recovered as useful."));
                }
            } else {
                System.out.println("[" + this.client + "]" + error_msg + "but expired piece block discarded as never requested.");
                this.peer_stats.bytesDiscarded(length);
                this.manager.discarded(length);
                ++requests_discarded;
                this.printRequestStats();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 3, "Protocol:In: " + error_msg + "but expired piece block " + "discarded as never requested."));
                }
            }
        } else {
            this.peer_stats.bytesDiscarded(length);
            this.manager.discarded(length);
            ++requests_discarded;
            this.printRequestStats();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 3, "Protocol:In: " + error_msg + "but expired piece block discarded " + "as already written."));
            }
        }
        if (piece_error) {
            piece.destroy();
            if (!this.manager.isWritten(pieceNumber, offset) && pePiece != null) {
                pePiece.clearDownloaded(offset);
            }
        }
    }

    protected void decodeCancel(BTCancel cancel) {
        int number = cancel.getPieceNumber();
        int offset = cancel.getPieceOffset();
        int length = cancel.getLength();
        cancel.destroy();
        this.outgoing_piece_message_handler.removePieceRequest(number, offset, length);
    }

    private void registerForMessageHandling() {
        this.connection.getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

            public boolean messageReceived(Message message) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LogIDs.NET, "Received [" + message.getDescription() + "] message"));
                }
                PEPeerTransportProtocol.this.last_message_received_time = SystemTime.getCurrentTime();
                if (message.getType() == 1) {
                    PEPeerTransportProtocol.this.last_data_message_received_time = SystemTime.getCurrentTime();
                }
                if (message.getID().equals("BT_PIECE")) {
                    PEPeerTransportProtocol.this.decodePiece((BTPiece)message);
                    return true;
                }
                if (PEPeerTransportProtocol.this.closing) {
                    message.destroy();
                    return true;
                }
                if (message.getID().equals("BT_KEEP_ALIVE")) {
                    message.destroy();
                    if (!PEPeerTransportProtocol.this.message_limiter.countIncomingMessage(message.getID(), 6, 60000)) {
                        System.out.println("Incoming keep-alive message flood detected, dropping spamming peer connection." + PEPeerTransportProtocol.this);
                        PEPeerTransportProtocol.this.closeConnectionInternally("Incoming keep-alive message flood detected, dropping spamming peer connection.");
                    }
                    return true;
                }
                if (message.getID().equals("BT_HANDSHAKE")) {
                    PEPeerTransportProtocol.this.decodeBTHandshake((BTHandshake)message);
                    return true;
                }
                if (message.getID().equals("AZ_HANDSHAKE")) {
                    PEPeerTransportProtocol.this.decodeAZHandshake((AZHandshake)message);
                    return true;
                }
                if (message.getID().equals("BT_BITFIELD")) {
                    PEPeerTransportProtocol.this.decodeBitfield((BTBitfield)message);
                    return true;
                }
                if (message.getID().equals("BT_CHOKE")) {
                    PEPeerTransportProtocol.this.decodeChoke((BTChoke)message);
                    if (PEPeerTransportProtocol.this.choking_other_peer) {
                        PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(false);
                    }
                    return true;
                }
                if (message.getID().equals("BT_UNCHOKE")) {
                    PEPeerTransportProtocol.this.decodeUnchoke((BTUnchoke)message);
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(true);
                    return true;
                }
                if (message.getID().equals("BT_INTERESTED")) {
                    PEPeerTransportProtocol.this.decodeInterested((BTInterested)message);
                    return true;
                }
                if (message.getID().equals("BT_UNINTERESTED")) {
                    PEPeerTransportProtocol.this.decodeUninterested((BTUninterested)message);
                    return true;
                }
                if (message.getID().equals("BT_HAVE")) {
                    PEPeerTransportProtocol.this.decodeHave((BTHave)message);
                    return true;
                }
                if (message.getID().equals("BT_REQUEST")) {
                    PEPeerTransportProtocol.this.decodeRequest((BTRequest)message);
                    return true;
                }
                if (message.getID().equals("BT_CANCEL")) {
                    PEPeerTransportProtocol.this.decodeCancel((BTCancel)message);
                    return true;
                }
                if (message.getID().equals("AZ_PEER_EXCHANGE")) {
                    PEPeerTransportProtocol.this.decodeAZPeerExchange((AZPeerExchange)message);
                    return true;
                }
                return false;
            }

            public void protocolBytesReceived(int byte_count) {
                PEPeerTransportProtocol.this.peer_stats.protocolBytesReceived(byte_count);
                PEPeerTransportProtocol.this.manager.protocolBytesReceived(byte_count);
            }

            public void dataBytesReceived(int byte_count) {
                PEPeerTransportProtocol.this.peer_stats.dataBytesReceived(byte_count);
                PEPeerTransportProtocol.this.manager.dataBytesReceived(byte_count);
            }
        });
        this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public boolean messageAdded(Message message) {
                return true;
            }

            public void messageQueued(Message message) {
            }

            public void messageRemoved(Message message) {
            }

            public void messageSent(Message message) {
                PEPeerTransportProtocol.this.last_message_sent_time = SystemTime.getCurrentTime();
                if (message.getType() == 1) {
                    PEPeerTransportProtocol.this.last_data_message_sent_time = SystemTime.getCurrentTime();
                }
                if (message.getID().equals("BT_UNCHOKE")) {
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(true);
                } else if (message.getID().equals("BT_CHOKE") && PEPeerTransportProtocol.this.choked_by_other_peer) {
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(false);
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LogIDs.NET, "Sent [" + message.getDescription() + "] message"));
                }
            }

            public void protocolBytesSent(int byte_count) {
                PEPeerTransportProtocol.this.peer_stats.protocolBytesSent(byte_count);
                PEPeerTransportProtocol.this.manager.protocolBytesSent(byte_count);
            }

            public void dataBytesSent(int byte_count) {
                PEPeerTransportProtocol.this.peer_stats.dataBytesSent(byte_count);
                PEPeerTransportProtocol.this.manager.dataBytesSent(byte_count);
            }
        });
        this.connection.startMessageProcessing(this.manager.getUploadLimitedRateGroup(), this.manager.getDownloadLimitedRateGroup());
    }

    public Connection getConnection() {
        return this.plugin_connection;
    }

    public Message[] getSupportedMessages() {
        return this.supported_messages;
    }

    public boolean supportsMessaging() {
        return this.supported_messages != null;
    }

    public String getEncryption() {
        return this.connection.getTCPTransport().getEncryption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PEPeerListener listener) {
        try {
            this.peer_listeners_mon.enter();
            if (this.peer_listeners_cow == null) {
                this.peer_listeners_cow = new ArrayList();
            }
            ArrayList<PEPeerListener> new_listeners = new ArrayList<PEPeerListener>(this.peer_listeners_cow);
            new_listeners.add(listener);
            this.peer_listeners_cow = new_listeners;
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PEPeerListener listener) {
        try {
            this.peer_listeners_mon.enter();
            if (this.peer_listeners_cow != null) {
                ArrayList new_listeners = new ArrayList(this.peer_listeners_cow);
                new_listeners.remove(listener);
                if (new_listeners.isEmpty()) {
                    new_listeners = null;
                }
                this.peer_listeners_cow = new_listeners;
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    private void changePeerState(int new_state) {
        List peer_listeners_ref;
        this.current_peer_state = new_state;
        if (this.current_peer_state == 30) {
            this.doPostHandshakeProcessing();
        }
        if ((peer_listeners_ref = this.peer_listeners_cow) != null) {
            for (int i = 0; i < peer_listeners_ref.size(); ++i) {
                PEPeerListener l = (PEPeerListener)peer_listeners_ref.get(i);
                l.stateChanged(this, this.current_peer_state);
            }
        }
    }

    private void doPostHandshakeProcessing() {
        if (this.manager.isPeerExchangeEnabled()) {
            this.peer_exchange_item = this.manager.createPeerExchangeConnection(this);
            if (this.peer_exchange_item != null) {
                if (this.peerSupportsMessageType("AZ_PEER_EXCHANGE")) {
                    this.peer_exchange_supported = true;
                } else {
                    this.peer_exchange_item.disableStateMaintenance();
                }
            }
        }
    }

    private boolean peerSupportsMessageType(String message_id) {
        if (this.supported_messages != null) {
            for (int i = 0; i < this.supported_messages.length; ++i) {
                if (!this.supported_messages[i].getID().equals(message_id)) continue;
                return true;
            }
        }
        return false;
    }

    public void updatePeerExchange() {
        if (this.current_peer_state != 30) {
            return;
        }
        if (!this.peer_exchange_supported) {
            return;
        }
        if (this.peer_exchange_item != null && this.manager.isPeerExchangeEnabled()) {
            PeerItem[] adds = this.peer_exchange_item.getNewlyAddedPeerConnections();
            PeerItem[] drops = this.peer_exchange_item.getNewlyDroppedPeerConnections();
            if (adds != null && adds.length > 0 || drops != null && drops.length > 0) {
                this.connection.getOutgoingMessageQueue().addMessage(new AZPeerExchange(this.manager.getHash(), adds, drops), false);
            }
        }
    }

    protected void decodeAZPeerExchange(AZPeerExchange exchange) {
        PeerItem[] added = exchange.getAddedPeers();
        PeerItem[] dropped = exchange.getDroppedPeers();
        if (!this.message_limiter.countIncomingMessage(exchange.getID(), 7, 120000)) {
            System.out.println("Incoming PEX message flood detected, dropping spamming peer connection." + this);
            this.closeConnectionInternally("Incoming PEX message flood detected, dropping spamming peer connection.");
            return;
        }
        exchange.destroy();
        if (added != null && added.length > 50 || dropped != null && dropped.length > 50) {
            System.out.println("Invalid PEX message received: too large [" + added.length + "/" + dropped.length + "]" + this);
            this.closeConnectionInternally("Invalid PEX message received: too large, dropping likely poisoner peer connection.");
            return;
        }
        if (this.peer_exchange_supported && this.peer_exchange_item != null && this.manager.isPeerExchangeEnabled()) {
            int i;
            if (added != null) {
                for (i = 0; i < added.length; ++i) {
                    this.peer_exchange_item.addConnectedPeer(added[i]);
                }
            }
            if (dropped != null) {
                for (i = 0; i < dropped.length; ++i) {
                    this.peer_exchange_item.dropConnectedPeer(dropped[i]);
                }
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Peer Exchange disabled for this download, dropping received exchange message."));
        }
    }

    public PeerItem getPeerItemIdentity() {
        return this.peer_item_identity;
    }

    public int getReservedPieceNumber() {
        return this.reservedPiece;
    }

    public void setReservedPieceNumber(int pieceNumber) {
        this.reservedPiece = pieceNumber;
    }

    public int[] getIncomingRequestedPieceNumbers() {
        return this.outgoing_piece_message_handler.getRequestedPieceNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getOutgoingRequestedPieceNumbers() {
        try {
            this.requested_mon.enter();
            int iLastNumber = -1;
            int[] pieceNumbers = new int[this.requested.size()];
            int pos = 0;
            for (int i = 0; i < this.requested.size(); ++i) {
                DiskManagerReadRequest request2 = null;
                try {
                    request2 = (DiskManagerReadRequest)this.requested.get(i);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                if (request2 == null || iLastNumber == request2.getPieceNumber()) continue;
                iLastNumber = request2.getPieceNumber();
                pieceNumbers[pos++] = iLastNumber;
            }
            int[] trimmed = new int[pos];
            System.arraycopy(pieceNumbers, 0, trimmed, 0, pos);
            int[] nArray = trimmed;
            return nArray;
        }
        finally {
            this.requested_mon.exit();
        }
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.connection.getIncomingMessageQueue().getPercentDoneOfCurrentMessage();
    }

    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.connection.getOutgoingMessageQueue().getPercentDoneOfCurrentMessage();
    }

    public String getRelationText() {
        String text = "";
        if (this.manager instanceof LogRelation) {
            text = ((LogRelation)((Object)this.manager)).getRelationText() + "; ";
        }
        text = text + "Peer: " + this.toString();
        return text;
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.manager};
    }

    public int getLastPiece() {
        return this._lastPiece;
    }

    public void setLastPiece(int pieceNumber) {
        this._lastPiece = pieceNumber;
    }

    public boolean isLANLocal() {
        if (this.connection == null) {
            return AddressUtils.isLANLocalAddress(this.ip);
        }
        return this.connection.isLANLocal();
    }

    static {
        String prop = System.getProperty("show.discard.rate.stats");
        SHOW_DISCARD_RATE_STATS = prop != null && prop.equals("1");
        requests_discarded = 0;
        requests_discarded_endgame = 0;
        requests_recovered = 0;
        requests_completed = 0;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Use Lazy Bitfield"}, new ParameterListener(){

            public void parameterChanged(String ignore) {
                String prop = System.getProperty("azureus.lazy.bitfield");
                ENABLE_LAZY_BITFIELD = prop != null && prop.equals("1");
                ENABLE_LAZY_BITFIELD |= COConfigurationManager.getBooleanParameter("Use Lazy Bitfield");
            }
        });
    }
}

