/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.SeedingRankColumnListener;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.ui.swt.StartStopRulesDefaultPluginSWTUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class StartStopRulesDefaultPlugin
implements Plugin,
COConfigurationListener {
    private static final String sStates = " WPRDS.XEQ";
    public static final int RANK_NONE = 0;
    public static final int RANK_SPRATIO = 1;
    public static final int RANK_SEEDCOUNT = 2;
    public static final int RANK_TIMED = 3;
    private static final int FORCE_CHECK_PERIOD = 30000;
    private static final int CHECK_FOR_GROSS_CHANGE_PERIOD = 30000;
    private static final int PROCESS_CHECK_PERIOD = 500;
    private static final int MIN_SEEDING_STARTUP_WAIT = 20000;
    private static final int MIN_FIRST_SCRAPE_WAIT = 90000;
    private AEMonitor this_mon = new AEMonitor("StartStopRules");
    private PluginInterface plugin_interface;
    protected PluginConfig plugin_config;
    private DownloadManager download_manager;
    protected LoggerChannel log;
    private Timer changeCheckerTimer;
    private TimerTask recalcSeedingRanksTask;
    private static Map downloadDataMap = AEMonitor.getSynchronisedMap(new HashMap());
    private volatile boolean closingDown;
    private volatile boolean somethingChanged;
    private long startedOn;
    protected boolean bDebugLog;
    private int iRankType = -1;
    private int minSpeedForActiveSeeding;
    private int numPeersAsFullCopy;
    private int iFakeFullCopySeedStart;
    private int _maxActive;
    private boolean _maxActiveWhenSeedingEnabled;
    private int _maxActiveWhenSeeding;
    private int maxDownloads;
    private boolean bAutoReposition;
    private long minTimeAlive;
    private boolean bAutoStart0Peers;
    private int iMaxUploadSpeed;
    private static boolean bAlreadyInitialized = false;
    private TableColumn seedingRankColumn;
    private TableContextMenuItem debugMenuItem = null;
    private boolean bSWTUI = false;

    public void initialize(PluginInterface _plugin_interface) {
        if (bAlreadyInitialized) {
            System.err.println("StartStopRulesDefaultPlugin Already initialized!!");
        } else {
            bAlreadyInitialized = true;
        }
        this.startedOn = SystemTime.getCurrentTime();
        this.changeCheckerTimer = new Timer(true);
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Start/Stop Rules");
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
            }

            public void closedownInitiated() {
                StartStopRulesDefaultPlugin.this.closingDown = true;
                COConfigurationManager.removeListener(StartStopRulesDefaultPlugin.this);
            }

            public void closedownComplete() {
            }
        });
        this.log = this.plugin_interface.getLogger().getChannel("StartStopRules");
        this.log.log(1, "Default StartStopRules Plugin Initialisation");
        COConfigurationManager.addListener(this);
        this.plugin_config = this.plugin_interface.getPluginconfig();
        try {
            TableManager tm = this.plugin_interface.getUIManager().getTableManager();
            this.seedingRankColumn = tm.createColumn("MySeeders", "SeedingRank");
            this.seedingRankColumn.initialize(2, -2, 80, -2);
            SeedingRankColumnListener columnListener = new SeedingRankColumnListener(downloadDataMap, this.plugin_config);
            this.seedingRankColumn.addCellRefreshListener(columnListener);
            tm.addColumn(this.seedingRankColumn);
            this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

                public void UIAttached(UIInstance instance) {
                    if (instance instanceof UISWTInstance) {
                        StartStopRulesDefaultPlugin.this.bSWTUI = true;
                        new StartStopRulesDefaultPluginSWTUI(StartStopRulesDefaultPlugin.this.plugin_interface);
                    }
                }

                public void UIDetached(UIInstance instance) {
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.reloadConfigParams();
        this.download_manager = this.plugin_interface.getDownloadManager();
        this.download_manager.addListener(new StartStopDMListener());
        this.changeCheckerTimer.schedule((TimerTask)new ChangeCheckerTimerTask(), 10000L, 30000L);
        this.changeCheckerTimer.schedule((TimerTask)new ChangeFlagCheckerTask(), 10000L, 500L);
    }

    public static DefaultRankCalculator getRankCalculator(Download dl) {
        return (DefaultRankCalculator)downloadDataMap.get(dl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcAllSeedingRanks(boolean force) {
        if (this.closingDown) {
            return;
        }
        try {
            this.this_mon.enter();
            DefaultRankCalculator[] dlDataArray = downloadDataMap.values().toArray(new DefaultRankCalculator[0]);
            for (int i = 0; i < dlDataArray.length; ++i) {
                if (force) {
                    dlDataArray[i].getDownloadObject().setSeedingRank(0);
                }
                dlDataArray[i].recalcSeedingRank();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void configurationSaved() {
        this.reloadConfigParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigParams() {
        block11: {
            try {
                this.this_mon.enter();
                int iNewRankType = this.plugin_config.getIntParameter("StartStopManager_iRankType");
                this.minSpeedForActiveSeeding = this.plugin_config.getIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
                this._maxActive = this.plugin_config.getIntParameter("max active torrents");
                this._maxActiveWhenSeedingEnabled = this.plugin_config.getBooleanParameter("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
                this._maxActiveWhenSeeding = this.plugin_config.getIntParameter("StartStopManager_iMaxActiveTorrentsWhenSeeding");
                this.maxDownloads = this.plugin_config.getIntParameter("max downloads");
                this.numPeersAsFullCopy = this.plugin_config.getIntParameter("StartStopManager_iNumPeersAsFullCopy");
                this.iFakeFullCopySeedStart = this.plugin_config.getIntParameter("StartStopManager_iFakeFullCopySeedStart");
                this.bAutoReposition = this.plugin_config.getBooleanParameter("StartStopManager_bAutoReposition");
                this.minTimeAlive = this.plugin_config.getIntParameter("StartStopManager_iMinSeedingTime") * 1000;
                this.bDebugLog = this.plugin_config.getBooleanParameter("StartStopManager_bDebugLog");
                this.bAutoStart0Peers = this.plugin_config.getBooleanParameter("StartStopManager_bAutoStart0Peers");
                this.iMaxUploadSpeed = this.plugin_config.getIntParameter("Max Upload Speed KBs", 0);
                boolean move_top = this.plugin_config.getBooleanParameter("StartStopManager_bNewSeedsMoveTop");
                this.plugin_config.setBooleanParameter("Newly Seeding Torrents Get First Priority", move_top);
                if (iNewRankType != this.iRankType) {
                    this.iRankType = iNewRankType;
                    if (this.iRankType == 3) {
                        if (this.recalcSeedingRanksTask == null) {
                            this.recalcSeedingRanksTask = new RecalcSeedingRanksTask();
                            this.changeCheckerTimer.schedule(this.recalcSeedingRanksTask, 1000L, 1000L);
                        }
                    } else if (this.recalcSeedingRanksTask != null) {
                        this.recalcSeedingRanksTask.cancel();
                        this.recalcSeedingRanksTask = null;
                    }
                }
                this.recalcAllSeedingRanks(true);
                this.somethingChanged = true;
                if (!this.bDebugLog) break block11;
                this.log.log(1, "somethingChanged: config reload");
                try {
                    if (this.debugMenuItem == null) {
                        String DEBUG_MENU_ID = "StartStopRules.menu.viewDebug";
                        MenuItemListener menuListener = new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                if (!(target instanceof TableRow)) {
                                    return;
                                }
                                TableRow tr = (TableRow)target;
                                Object ds = tr.getDataSource();
                                if (!(ds instanceof Download)) {
                                    return;
                                }
                                DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(ds);
                                if (dlData != null) {
                                    if (StartStopRulesDefaultPlugin.this.bSWTUI) {
                                        StartStopRulesDefaultPluginSWTUI.openDebugWindow(dlData);
                                    } else {
                                        StartStopRulesDefaultPlugin.this.plugin_interface.getUIManager().showTextMessage(null, null, "FP:\n" + dlData.sExplainFP + "\n" + "SR:" + dlData.sExplainSR + "\n" + "TRACE:\n" + dlData.sTrace);
                                    }
                                }
                            }
                        };
                        TableManager tm = this.plugin_interface.getUIManager().getTableManager();
                        TableContextMenuItem menu = tm.addContextMenuItem("MySeeders", "StartStopRules.menu.viewDebug");
                        menu.addListener(menuListener);
                        menu = tm.addContextMenuItem("MyTorrents", "StartStopRules.menu.viewDebug");
                        menu.addListener(menuListener);
                    }
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    private int calcMaxSeeders(int iDLs) {
        int maxActive = this.getMaxActive();
        return maxActive == 0 ? 99999 : maxActive - iDLs;
    }

    protected int getMaxActive() {
        if (!this._maxActiveWhenSeedingEnabled) {
            return this._maxActive;
        }
        if (this.download_manager.isSeedingOnly()) {
            if (this._maxActiveWhenSeeding <= this._maxActive) {
                return this._maxActiveWhenSeeding;
            }
            Download[] downloads = this.download_manager.getDownloads();
            boolean danger = false;
            block0: for (int i = 0; i < downloads.length && !danger; ++i) {
                Download download = downloads[i];
                int state = download.getState();
                if (state == 4 || state == 5 || state == 7 || state == 6 || state == 8) continue;
                DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
                for (int j = 0; j < files.length; ++j) {
                    DiskManagerFileInfo file = files[j];
                    if (file.isSkipped() || file.getDownloaded() == file.getLength()) continue;
                    danger = true;
                    continue block0;
                }
            }
            if (!danger) {
                return this._maxActiveWhenSeeding;
            }
        }
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        try {
            this.this_mon.enter();
            boolean bDebugOn = false;
            Object[] dlDataArray = downloadDataMap.values().toArray(new DefaultRankCalculator[downloadDataMap.size()]);
            TotalsStats totals = new TotalsStats((DefaultRankCalculator[])dlDataArray);
            String[] mainDebugEntries = null;
            if (this.bDebugLog) {
                this.log.log(1, ">>process()");
                mainDebugEntries = new String[]{"ok2Start=" + this.boolDebug(totals.bOkToStartSeeding), "tFrcdCding=" + totals.forcedSeeding, "actvCDs=" + totals.activelyCDing, "tW8tingToCd=" + totals.waitingToSeed, "tDLing=" + totals.downloading, "actvDLs=" + totals.activelyDLing, "tW8tingToDL=" + totals.waitingToDL, "tCom=" + totals.complete, "tIncQd=" + totals.incompleteQueued, "mxCdrs=" + totals.maxSeeders, "tFP=" + totals.firstPriority, "maxT=" + totals.maxTorrents};
            }
            this.somethingChanged = false;
            Arrays.sort(dlDataArray);
            ProcessVars vars = new ProcessVars();
            vars.numWaitingOrSeeding = totals.forcedSeeding;
            vars.numWaitingOrDLing = 0;
            vars.higherQueued = false;
            vars.posComplete = 0;
            for (int i = 0; i < dlDataArray.length; ++i) {
                int state;
                Object dlData = dlDataArray[i];
                Download download = ((DefaultRankCalculator)dlData).getDownloadObject();
                vars.bStopAndQueued = false;
                ((DefaultRankCalculator)dlData).sTrace = "";
                if (download.getState() == 1) {
                    try {
                        download.initialize();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (this.bDebugLog && download.getState() == 1) {
                        ((DefaultRankCalculator)dlData).sTrace = ((DefaultRankCalculator)dlData).sTrace + "still in waiting state after initialize!\n";
                    }
                }
                if (this.bAutoReposition && this.iRankType != 0 && download.getStats().getDownloadCompleted(false) == 1000 && (totals.bOkToStartSeeding || totals.firstPriority > 0)) {
                    download.setPosition(++vars.posComplete);
                }
                if ((state = download.getState()) == 6 || state == 7 || state == 8) continue;
                if (download.getStats().getDownloadCompleted(false) != 1000) {
                    this.handleInCompleteDownload((DefaultRankCalculator)dlData, vars, totals);
                    continue;
                }
                if (!totals.bOkToStartSeeding) continue;
                this.handleCompletedDownload((DefaultRankCalculator[])dlDataArray, (DefaultRankCalculator)dlData, vars, totals);
            }
            if (this.bDebugLog) {
                String[] mainDebugEntries2 = new String[]{"ok2Start=" + this.boolDebug(totals.bOkToStartSeeding), "tFrcdCding=" + totals.forcedSeeding, "actvCDs=" + totals.activelyCDing, "tW8tingToCd=" + totals.waitingToSeed, "tDLing=" + totals.downloading, "actvDLs=" + totals.activelyDLing, "tW8tingToDL=" + totals.waitingToDL, "tCom=" + totals.complete, "tIncQd=" + totals.incompleteQueued, "mxCdrs=" + totals.maxSeeders, "tFP=" + totals.firstPriority, "maxT=" + totals.maxTorrents};
                this.printDebugChanges("<<process() ", mainDebugEntries, mainDebugEntries2, "", "", true, null);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void handleInCompleteDownload(DefaultRankCalculator dlData, ProcessVars vars, TotalsStats totals) {
        String s;
        Download download = dlData.dl;
        int state = download.getState();
        if (download.isForceStart()) {
            if (this.bDebugLog) {
                String s2 = "isForceStart.. rules skipped";
                this.log.log((Object)download.getTorrent(), 1, s2);
                dlData.sTrace = dlData.sTrace + s2 + "\n";
            }
            return;
        }
        if (state == 2) {
            ++vars.numWaitingOrDLing;
            if (this.bDebugLog) {
                String s3 = "ST_PREPARING.. rules skipped. numW8tngorDLing=" + vars.numWaitingOrDLing;
                this.log.log((Object)download.getTorrent(), 1, s3);
                dlData.sTrace = dlData.sTrace + s3 + "\n";
            }
            return;
        }
        int maxDLs = 0;
        int DLmax = 0;
        if (totals.maxActive == 0) {
            maxDLs = this.maxDownloads;
        } else {
            DLmax = totals.stalledFPSeeders + totals.maxActive - totals.firstPriority - totals.forcedSeedingNonFP;
            int n = DLmax <= 0 ? 0 : (maxDLs = this.maxDownloads - DLmax <= 0 ? this.maxDownloads : DLmax);
        }
        if (this.bDebugLog) {
            s = ">> state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + vars.numWaitingOrDLing + ";maxCDrs=" + totals.maxSeeders + ";forced=" + this.boolDebug(download.isForceStart()) + ";actvDLs=" + totals.activelyDLing + ";maxDLs=" + maxDLs + ";ActDLing=" + this.boolDebug(dlData.getActivelyDownloading()) + ";isCmplt=" + this.boolDebug(download.isComplete());
            this.log.log((Object)download.getTorrent(), 1, s);
            dlData.sTrace = dlData.sTrace + s + "\n";
        }
        if (state == 3 || state == 4 || state == 1) {
            boolean bActivelyDownloading = dlData.getActivelyDownloading();
            if (this.maxDownloads != 0 && vars.numWaitingOrDLing >= maxDLs && (bActivelyDownloading || state != 4 || state == 4 && totals.maxActive != 0 && !bActivelyDownloading && totals.activelyCDing + totals.activelyDLing >= totals.maxActive)) {
                try {
                    if (this.bDebugLog) {
                        String s4 = "   stopAndQueue: " + vars.numWaitingOrDLing + " waiting or downloading, when limit is " + this.maxDownloads;
                        this.log.log((Object)download.getTorrent(), 1, s4);
                        dlData.sTrace = dlData.sTrace + s4 + "\n";
                    }
                    download.stopAndQueue();
                    if (state == 4) {
                        --totals.downloading;
                        if (bActivelyDownloading) {
                            --totals.activelyDLing;
                        }
                    } else {
                        --totals.waitingToDL;
                    }
                    totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                state = download.getState();
            }
        }
        if (state == 3 && (this.maxDownloads == 0 || totals.activelyDLing < maxDLs)) {
            try {
                if (this.bDebugLog) {
                    s = "   start: READY && activelyDLing (" + totals.activelyDLing + ") < maxDLs (" + this.maxDownloads + ")";
                    this.log.log((Object)download.getTorrent(), 1, s);
                    dlData.sTrace = dlData.sTrace + s + "\n";
                }
                download.start();
                --totals.waitingToDL;
                ++totals.activelyDLing;
                totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            state = download.getState();
        }
        if (state == 9 && (this.maxDownloads == 0 || vars.numWaitingOrDLing < maxDLs)) {
            try {
                if (this.bDebugLog) {
                    s = "   restart: QUEUED && numWaitingOrDLing (" + vars.numWaitingOrDLing + ") < maxDLS (" + maxDLs + ")";
                    this.log.log(1, s);
                    dlData.sTrace = dlData.sTrace + s + "\n";
                }
                download.restart();
                ++totals.waitingToDL;
                totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            state = download.getState();
        }
        if (state == 4 && dlData.getActivelyDownloading() || state == 3 || state == 1 || state == 2) {
            ++vars.numWaitingOrDLing;
        }
        if (this.bDebugLog) {
            s = "<< state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + vars.numWaitingOrDLing + ";maxCDrs=" + totals.maxSeeders + ";forced=" + this.boolDebug(download.isForceStart()) + ";actvDLs=" + totals.activelyDLing + ";ActDLing=" + this.boolDebug(dlData.getActivelyDownloading());
            this.log.log((Object)download.getTorrent(), 1, s);
            dlData.sTrace = dlData.sTrace + s + "\n";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCompletedDownload(DefaultRankCalculator[] dlDataArray, DefaultRankCalculator dlData, ProcessVars vars, TotalsStats totals) {
        String sDebugLine;
        String[] debugEntries;
        Download download;
        block57: {
            block56: {
                download = dlData.dl;
                int state = download.getState();
                debugEntries = null;
                sDebugLine = "";
                if (!totals.bOkToStartSeeding) {
                    return;
                }
                int numPeers = this.calcPeersNoUs(download);
                if (this.bDebugLog) {
                    debugEntries = new String[]{"state=" + sStates.charAt(state), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherQueued), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(dlData.isFirstPriority()), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding())};
                }
                try {
                    int rank;
                    block58: {
                        boolean okToStop;
                        boolean bActivelySeeding;
                        block61: {
                            block59: {
                                boolean bSeeding;
                                boolean bOverLimit;
                                block60: {
                                    block62: {
                                        boolean bScrapeOk = this.scrapeResultOk(download);
                                        if (this.bAutoStart0Peers && numPeers == 0 && bScrapeOk) {
                                            if (state == 9) {
                                                try {
                                                    if (this.bDebugLog) {
                                                        sDebugLine = sDebugLine + "\nrestart() 0Peers";
                                                    }
                                                    download.restart();
                                                    ++totals.waitingToSeed;
                                                    ++vars.numWaitingOrSeeding;
                                                    state = download.getState();
                                                    if (state == 3) {
                                                        if (this.bDebugLog) {
                                                            sDebugLine = sDebugLine + "\nstart(); 0Peers";
                                                        }
                                                        download.start();
                                                        ++totals.activelyCDing;
                                                    }
                                                }
                                                catch (Exception ignore) {
                                                    // empty catch block
                                                }
                                            }
                                            if (state == 3) {
                                                try {
                                                    if (this.bDebugLog) {
                                                        sDebugLine = sDebugLine + "\nstart(); 0Peers";
                                                    }
                                                    download.start();
                                                    ++totals.activelyCDing;
                                                    ++vars.numWaitingOrSeeding;
                                                }
                                                catch (Exception ignore) {
                                                }
                                            }
                                            Object var20_14 = null;
                                            if (!this.bDebugLog) return;
                                            break block56;
                                        }
                                        if (this.bDebugLog && this.bAutoStart0Peers && numPeers == 0 && !bScrapeOk && (state == 9 || state == 3)) {
                                            sDebugLine = sDebugLine + "\n  NOT starting 0 Peer torrent because scrape isn't ok";
                                        }
                                        boolean isFP = dlData.isFirstPriority();
                                        bActivelySeeding = dlData.getActivelySeeding();
                                        boolean okToQueue = (state == 3 || state == 5) && (!isFP || isFP && totals.maxActive != 0 && vars.numWaitingOrSeeding >= totals.maxSeeders) && !download.isForceStart();
                                        rank = download.getSeedingRank();
                                        if (okToQueue && state == 5 && this.iRankType != 3) {
                                            long timeAlive = SystemTime.getCurrentTime() - download.getStats().getTimeStarted();
                                            boolean bl = okToQueue = timeAlive >= this.minTimeAlive;
                                            if (!okToQueue && this.bDebugLog) {
                                                sDebugLine = sDebugLine + "\n  Torrent can't be stopped yet, timeAlive(" + timeAlive + ") < minTimeAlive(" + this.minTimeAlive + ")";
                                            }
                                        }
                                        if (state != 9 && (state == 3 || state == 1 || state == 2 || state == 5 && bActivelySeeding && !download.isForceStart())) {
                                            ++vars.numWaitingOrSeeding;
                                            if (this.bDebugLog) {
                                                sDebugLine = sDebugLine + "\n  Torrent is waiting or seeding";
                                            }
                                        }
                                        if (!(okToQueue || state != 9 || totals.maxActive != 0 && vars.numWaitingOrSeeding >= totals.maxSeeders || rank < -1 || vars.higherQueued)) {
                                            try {
                                                if (this.bDebugLog) {
                                                    sDebugLine = sDebugLine + "\n  restart: ok2Q=" + okToQueue + "; QUEUED && numWaitingOrSeeding( " + vars.numWaitingOrSeeding + ") < maxSeeders (" + totals.maxSeeders + ")";
                                                }
                                                download.restart();
                                                okToQueue = false;
                                                ++totals.waitingToSeed;
                                                ++vars.numWaitingOrSeeding;
                                                if (this.iRankType == 3) {
                                                    dlData.recalcSeedingRank();
                                                }
                                            }
                                            catch (Exception ignore) {
                                                // empty catch block
                                            }
                                            state = download.getState();
                                        } else if (this.bDebugLog && state == 9) {
                                            sDebugLine = sDebugLine + "\n  NOT restarting:";
                                            if (rank < -1) {
                                                sDebugLine = sDebugLine + " torrent is being ignored";
                                            } else if (vars.higherQueued) {
                                                sDebugLine = sDebugLine + " a torrent with a higher rank is queued";
                                            } else {
                                                if (okToQueue) {
                                                    sDebugLine = sDebugLine + " no starting of okToQueue'd;";
                                                }
                                                if (vars.numWaitingOrSeeding >= totals.maxSeeders) {
                                                    sDebugLine = sDebugLine + " at limit, numWaitingOrSeeding(" + vars.numWaitingOrSeeding + ") >= maxSeeders(" + totals.maxSeeders + ")";
                                                }
                                            }
                                        }
                                        boolean bForceStop = false;
                                        if (state == 3 && totals.activelyCDing < totals.maxSeeders) {
                                            if (rank >= -1 || download.isForceStart()) {
                                                try {
                                                    if (this.bDebugLog) {
                                                        sDebugLine = sDebugLine + "\n  start: READY && total activelyCDing(" + totals.activelyCDing + ") < maxSeeders(" + totals.maxSeeders + ")";
                                                    }
                                                    download.start();
                                                    okToQueue = false;
                                                }
                                                catch (Exception ignore) {
                                                    // empty catch block
                                                }
                                                state = download.getState();
                                                ++totals.activelyCDing;
                                                bActivelySeeding = true;
                                                ++vars.numWaitingOrSeeding;
                                            } else if (okToQueue) {
                                                bForceStop = true;
                                            }
                                        }
                                        if (!okToQueue && !bForceStop) break block58;
                                        okToStop = bForceStop;
                                        if (okToStop) break block59;
                                        bOverLimit = vars.numWaitingOrSeeding > totals.maxSeeders || vars.numWaitingOrSeeding >= totals.maxSeeders && vars.higherQueued;
                                        bSeeding = state == 5;
                                        boolean bl = okToStop = !download.isChecking() && (bOverLimit || rank < -1) && (bActivelySeeding || !bSeeding || !bActivelySeeding && bSeeding);
                                        if (!this.bDebugLog) break block60;
                                        if (!okToStop) break block61;
                                        sDebugLine = sDebugLine + "\n  stopAndQueue: ";
                                        if (bOverLimit) {
                                            sDebugLine = vars.higherQueued ? sDebugLine + "higherQueued (it should be seeding instead of this one)" : sDebugLine + "over limit";
                                        } else if (rank < -1) {
                                            sDebugLine = sDebugLine + "ignoreRule met";
                                        }
                                        sDebugLine = sDebugLine + " && ";
                                        if (!bActivelySeeding) break block62;
                                        sDebugLine = sDebugLine + "activelySeeding";
                                        break block61;
                                    }
                                    if (!bSeeding) {
                                        sDebugLine = sDebugLine + "not SEEDING";
                                        break block61;
                                    } else if (!bActivelySeeding && bSeeding) {
                                        sDebugLine = sDebugLine + "SEEDING, but not actively";
                                    }
                                    break block61;
                                }
                                sDebugLine = sDebugLine + "\n  NOT queuing: ";
                                sDebugLine = download.isChecking() ? sDebugLine + "can't auto-queue a checking torrent" : (!bOverLimit ? sDebugLine + "not over limit.  numWaitingOrSeeding(" + vars.numWaitingOrSeeding + ") <= maxSeeders(" + totals.maxSeeders + ")" : sDebugLine + "bActivelySeeding=" + bActivelySeeding + ";bSeeding" + bSeeding);
                                break block61;
                            }
                            if (this.bDebugLog) {
                                sDebugLine = sDebugLine + "\n  Forcing a stop..";
                            }
                        }
                        if (okToStop) {
                            try {
                                if (state == 3) {
                                    --totals.waitingToSeed;
                                }
                                download.stopAndQueue();
                                vars.bStopAndQueued = true;
                                if (bActivelySeeding) {
                                    --totals.activelyCDing;
                                    bActivelySeeding = false;
                                    --vars.numWaitingOrSeeding;
                                }
                                if (state == 3) {
                                    --totals.waitingToSeed;
                                }
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                            state = download.getState();
                        }
                    }
                    if (vars.bStopAndQueued && this.iRankType == 3) {
                        for (int j = 0; j < dlDataArray.length; ++j) {
                            Download dl = dlDataArray[j].getDownloadObject();
                            int sr = dl.getSeedingRank();
                            if (sr <= 0 || sr >= 999999) continue;
                            dl.setSeedingRank(sr + 1);
                        }
                        rank = 999999 - totals.complete;
                        download.setSeedingRank(rank);
                    }
                    if (download.getState() == 9 && rank >= 0) {
                        vars.higherQueued = true;
                    }
                    break block57;
                }
                catch (Throwable throwable) {
                    Object var20_16 = null;
                    if (!this.bDebugLog) throw throwable;
                    String[] debugEntries2 = new String[]{"state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherQueued), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(dlData.isFirstPriority()), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding())};
                    this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
                    throw throwable;
                }
            }
            String[] debugEntries2 = new String[]{"state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherQueued), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(dlData.isFirstPriority()), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding())};
            this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
            return;
        }
        Object var20_15 = null;
        if (!this.bDebugLog) return;
        String[] debugEntries2 = new String[]{"state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherQueued), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(dlData.isFirstPriority()), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding())};
        this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
    }

    private String boolDebug(boolean b) {
        return b ? "Y" : "N";
    }

    private void printDebugChanges(String sPrefixFirstLine, String[] oldEntries, String[] newEntries, String sDebugLine, String sPrefix, boolean bAlwaysPrintNoChangeLine, DefaultRankCalculator dlData) {
        boolean bAnyChanged = false;
        String sDebugLineNoChange = sPrefixFirstLine;
        String sDebugLineOld = "";
        String sDebugLineNew = "";
        for (int j = 0; j < oldEntries.length; ++j) {
            if (oldEntries[j].equals(newEntries[j])) {
                sDebugLineNoChange = sDebugLineNoChange + oldEntries[j] + ";";
                continue;
            }
            sDebugLineOld = sDebugLineOld + oldEntries[j] + ";";
            sDebugLineNew = sDebugLineNew + newEntries[j] + ";";
            bAnyChanged = true;
        }
        String sDebugLineOut = (bAlwaysPrintNoChangeLine || bAnyChanged ? sDebugLineNoChange : "") + (bAnyChanged ? "\nOld:" + sDebugLineOld + "\nNew:" + sDebugLineNew : "") + sDebugLine;
        if (!sDebugLineOut.equals("")) {
            String[] lines = sDebugLineOut.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String s = sPrefix + (i > 0 ? "  " : "") + lines[i];
                if (dlData == null) {
                    this.log.log(1, s);
                    continue;
                }
                this.log.log((Object)dlData.dl.getTorrent(), 1, s);
                dlData.sTrace = dlData.sTrace + s + "\n";
            }
        }
    }

    public int calcPeersNoUs(Download download) {
        DownloadAnnounceResult ar;
        int numPeers = 0;
        DownloadScrapeResult sr = download.getLastScrapeResult();
        if (sr.getScrapeStartTime() > 0L && (numPeers = sr.getNonSeedCount()) > 0 && download.getState() == 4 && sr.getScrapeStartTime() > download.getStats().getTimeStarted()) {
            --numPeers;
        }
        if (numPeers == 0 && (ar = download.getLastAnnounceResult()) != null && ar.getResponseType() == 1) {
            numPeers = ar.getNonSeedCount();
        }
        return numPeers;
    }

    private boolean scrapeResultOk(Download download) {
        DownloadScrapeResult sr = download.getLastScrapeResult();
        return sr.getResponseType() == 1;
    }

    public int calcSeedsNoUs(Download download) {
        return this.calcSeedsNoUs(download, this.calcPeersNoUs(download));
    }

    public int calcSeedsNoUs(Download download, int numPeers) {
        DownloadAnnounceResult ar;
        int numSeeds = 0;
        DownloadScrapeResult sr = download.getLastScrapeResult();
        if (sr.getScrapeStartTime() > 0L) {
            long seedingStartedOn = download.getStats().getTimeStartedSeeding();
            numSeeds = sr.getSeedCount();
            if (numSeeds > 0 && seedingStartedOn > 0L && download.getState() == 5 && sr.getScrapeStartTime() > seedingStartedOn) {
                --numSeeds;
            }
        }
        if (numSeeds == 0 && (ar = download.getLastAnnounceResult()) != null && ar.getResponseType() == 1) {
            numSeeds = ar.getSeedCount();
        }
        if (this.numPeersAsFullCopy != 0 && numSeeds >= this.iFakeFullCopySeedStart) {
            numSeeds += numPeers / this.numPeersAsFullCopy;
        }
        return numSeeds;
    }

    public void requestProcessCycle() {
        this.somethingChanged = true;
    }

    public class ProcessVars {
        int numWaitingOrSeeding;
        int numWaitingOrDLing;
        boolean higherQueued;
        int posComplete;
        boolean bStopAndQueued;
    }

    private class TotalsStats {
        int forcedSeeding = 0;
        int forcedSeedingNonFP = 0;
        int waitingToSeed = 0;
        int waitingToDL = 0;
        int downloading = 0;
        int activelyDLing = 0;
        int activelyCDing = 0;
        int complete = 0;
        int incompleteQueued = 0;
        int firstPriority = 0;
        int stalledSeeders = 0;
        int stalledFPSeeders = 0;
        boolean bOkToStartSeeding;
        int maxSeeders;
        int maxActive;
        int maxTorrents;

        public TotalsStats(DefaultRankCalculator[] dlDataArray) {
            this.bOkToStartSeeding = StartStopRulesDefaultPlugin.this.iRankType == 0 || StartStopRulesDefaultPlugin.this.iRankType == 3 || SystemTime.getCurrentTime() - StartStopRulesDefaultPlugin.this.startedOn > 90000L;
            int totalOKScrapes = 0;
            for (int i = 0; i < dlDataArray.length; ++i) {
                DefaultRankCalculator dlData = dlDataArray[i];
                Download download = dlData.getDownloadObject();
                DownloadStats stats = download.getStats();
                int completionLevel = stats.getDownloadCompleted(false);
                boolean bIsFirstP = false;
                if (completionLevel < 1000 && download.isForceStart()) continue;
                int state = download.getState();
                if (completionLevel == 1000) {
                    boolean bScrapeOk = true;
                    if (!this.bOkToStartSeeding) {
                        bScrapeOk = StartStopRulesDefaultPlugin.this.scrapeResultOk(download);
                        if (StartStopRulesDefaultPlugin.this.calcSeedsNoUs(download) == 0 && bScrapeOk) {
                            this.bOkToStartSeeding = true;
                        } else if (download.getSeedingRank() > 0 && (state == 9 || state == 3) && SystemTime.getCurrentTime() - StartStopRulesDefaultPlugin.this.startedOn > 20000L) {
                            this.bOkToStartSeeding = true;
                        }
                    }
                    if (state == 8 || state == 7) continue;
                    ++this.complete;
                    if (!this.bOkToStartSeeding && bScrapeOk) {
                        ++totalOKScrapes;
                    }
                    if (dlData.isFirstPriority()) {
                        if (!this.bOkToStartSeeding) {
                            this.bOkToStartSeeding = true;
                        }
                        ++this.firstPriority;
                        bIsFirstP = true;
                    }
                    if (dlData.getActivelySeeding()) {
                        ++this.activelyCDing;
                        if (download.isForceStart()) {
                            ++this.forcedSeeding;
                            if (!bIsFirstP) {
                                ++this.forcedSeedingNonFP;
                            }
                        }
                    } else if (state == 5) {
                        if (bIsFirstP) {
                            ++this.stalledFPSeeders;
                        }
                        ++this.stalledSeeders;
                    }
                    if (state != 3 && state != 1 && state != 2) continue;
                    ++this.waitingToSeed;
                    continue;
                }
                if (state == 4) {
                    ++this.downloading;
                }
                if (dlData.getActivelyDownloading()) {
                    ++this.activelyDLing;
                }
                if (state == 3 || state == 1 || state == 2) {
                    ++this.waitingToDL;
                    continue;
                }
                if (state != 9) continue;
                ++this.incompleteQueued;
            }
            if (!this.bOkToStartSeeding && totalOKScrapes == this.complete) {
                this.bOkToStartSeeding = true;
            }
            this.maxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(this.activelyDLing + this.waitingToDL);
            this.maxActive = StartStopRulesDefaultPlugin.this.getMaxActive();
            if (this.maxActive == 0) {
                this.maxTorrents = 9999;
            } else if (StartStopRulesDefaultPlugin.this.iMaxUploadSpeed == 0) {
                this.maxTorrents = this.maxActive + 4;
            } else {
                int minSpeedPerActive = StartStopRulesDefaultPlugin.this.minSpeedForActiveSeeding * 2 / 1024;
                if (minSpeedPerActive < 3) {
                    minSpeedPerActive = 3;
                }
                this.maxTorrents = StartStopRulesDefaultPlugin.this.iMaxUploadSpeed / minSpeedPerActive;
                if (this.maxTorrents < this.maxActive) {
                    this.maxTorrents = this.maxActive;
                }
            }
        }
    }

    private class ChangeCheckerTimerTask
    extends TimerTask {
        private ChangeCheckerTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                StartStopRulesDefaultPlugin.this.this_mon.enter();
                DefaultRankCalculator[] dlDataArray = downloadDataMap.values().toArray(new DefaultRankCalculator[0]);
                int iNumDLing = 0;
                int iNumCDing = 0;
                for (int i = 0; i < dlDataArray.length; ++i) {
                    if (dlDataArray[i].changeChecker()) {
                        StartStopRulesDefaultPlugin.this.somethingChanged = true;
                        return;
                    }
                    if (dlDataArray[i].getActivelyDownloading()) {
                        ++iNumDLing;
                    }
                    if (!dlDataArray[i].getActivelySeeding()) continue;
                    ++iNumCDing;
                }
                int iMaxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(iNumDLing);
                if (iNumCDing > iMaxSeeders) {
                    StartStopRulesDefaultPlugin.this.somethingChanged = true;
                    if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                        StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: More Seeding than limit");
                    }
                }
            }
            finally {
                StartStopRulesDefaultPlugin.this.this_mon.exit();
            }
        }
    }

    private class StartStopDMListener
    implements DownloadManagerListener {
        private DownloadTrackerListener download_tracker_listener;
        private DownloadListener download_listener;

        public StartStopDMListener() {
            this.download_tracker_listener = new StartStopDMTrackerListener();
            this.download_listener = new StartStopDownloadListener();
        }

        public void downloadAdded(Download download) {
            DefaultRankCalculator dlData = null;
            if (downloadDataMap.containsKey(download)) {
                dlData = (DefaultRankCalculator)downloadDataMap.get(download);
            } else {
                dlData = new DefaultRankCalculator(StartStopRulesDefaultPlugin.this, download);
                downloadDataMap.put(download, dlData);
                download.addListener(this.download_listener);
                download.addTrackerListener(this.download_tracker_listener);
            }
            if (dlData != null) {
                dlData.recalcSeedingRank();
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadAdded");
                }
            }
        }

        public void downloadRemoved(Download download) {
            download.removeListener(this.download_listener);
            download.removeTrackerListener(this.download_tracker_listener);
            if (downloadDataMap.containsKey(download)) {
                downloadDataMap.remove(download);
            }
            StartStopRulesDefaultPlugin.this.somethingChanged = true;
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadRemoved");
            }
        }
    }

    private class StartStopDMTrackerListener
    implements DownloadTrackerListener {
        private StartStopDMTrackerListener() {
        }

        public void scrapeResult(DownloadScrapeResult result) {
            Download dl = result.getDownload();
            if (result.getResponseType() == 2) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dl.getTorrent(), 1, "Ignored somethingChanged: new scrapeResult (RT_ERROR)");
                }
                return;
            }
            DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(dl);
            if (dlData != null) {
                dlData.recalcSeedingRank();
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dl.getTorrent(), 1, "somethingChanged: new scrapeResult S:" + result.getSeedCount() + ";P:" + result.getNonSeedCount());
                }
            }
        }

        public void announceResult(DownloadAnnounceResult result) {
        }
    }

    private class StartStopDownloadListener
    implements DownloadListener {
        private StartStopDownloadListener() {
        }

        public void stateChanged(Download download, int old_state, int new_state) {
            DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(download);
            if (dlData != null) {
                dlData.recalcSeedingRank();
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dlData.dl.getTorrent(), 1, "somethingChanged: stateChange from " + StartStopRulesDefaultPlugin.sStates.charAt(old_state) + " (" + old_state + ") to " + StartStopRulesDefaultPlugin.sStates.charAt(new_state) + " (" + new_state + ")");
                }
            }
        }

        public void positionChanged(Download download, int oldPosition, int newPosition) {
            DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(download);
            if (dlData != null) {
                dlData.recalcSeedingRank();
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dlData.dl.getTorrent(), 1, "somethingChanged: positionChanged from " + oldPosition + " to " + newPosition);
                }
            }
        }
    }

    private class ChangeFlagCheckerTask
    extends TimerTask {
        long last_process_time = 0L;

        private ChangeFlagCheckerTask() {
        }

        public void run() {
            if (StartStopRulesDefaultPlugin.this.closingDown) {
                return;
            }
            long now = SystemTime.getCurrentTime();
            if (now < this.last_process_time || now - this.last_process_time >= 30000L) {
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
            }
            if (StartStopRulesDefaultPlugin.this.somethingChanged) {
                try {
                    this.last_process_time = now;
                    StartStopRulesDefaultPlugin.this.process();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private class RecalcSeedingRanksTask
    extends TimerTask {
        private RecalcSeedingRanksTask() {
        }

        public void run() {
            StartStopRulesDefaultPlugin.this.recalcAllSeedingRanks(false);
        }
    }
}

