/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet;

import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerException;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class MagnetPlugin
implements Plugin {
    private PluginInterface plugin_interface;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Magnet URI Handler");
        MenuItemListener listener = new MenuItemListener(){

            public void selected(MenuItem _menu, Object _target) {
                Download download = (Download)((TableRow)_target).getDataSource();
                if (download == null || download.getTorrent() == null) {
                    return;
                }
                Torrent torrent = download.getTorrent();
                String cb_data = "magnet:?xt=urn:btih:" + Base32.encode(torrent.getHash());
                TorrentAttribute ta_peer_sources = MagnetPlugin.this.plugin_interface.getTorrentManager().getAttribute("PeerSources");
                if (torrent.isPrivate()) {
                    cb_data = "<private torrent>";
                } else if (!torrent.isDecentralised()) {
                    if (torrent.isDecentralisedBackupEnabled()) {
                        String[] sources = download.getListAttribute(ta_peer_sources);
                        boolean ok = false;
                        for (int i = 0; i < sources.length; ++i) {
                            if (!sources[i].equalsIgnoreCase("DHT")) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            cb_data = "<decentralised tracking disabled>";
                        }
                    } else {
                        cb_data = "<decentralised backup disabled>";
                    }
                }
                try {
                    MagnetPlugin.this.plugin_interface.getUIManager().copyToClipBoard(cb_data);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        final TableContextMenuItem menu1 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MyTorrents", "MagnetPlugin.contextmenu.exporturi");
        final TableContextMenuItem menu2 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MySeeders", "MagnetPlugin.contextmenu.exporturi");
        menu1.addListener(listener);
        menu2.addListener(listener);
        MagnetURIHandler.getSingleton().addListener(new MagnetURIHandlerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] badge() {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/azureus/plugins/magnet/Magnet.gif");
                if (is == null) {
                    return null;
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = is.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                    }
                    finally {
                        is.close();
                    }
                    return baos.toByteArray();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }

            public byte[] download(MagnetURIHandlerProgressListener muh_listener, byte[] hash, long timeout) throws MagnetURIHandlerException {
                return MagnetPlugin.this.download(new MagnetPluginProgressListener(this, muh_listener){
                    private final /* synthetic */ MagnetURIHandlerProgressListener val$muh_listener;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$muh_listener = val$muh_listener;
                    }

                    public void reportSize(long size) {
                        this.val$muh_listener.reportSize(size);
                    }

                    public void reportActivity(String str) {
                        this.val$muh_listener.reportActivity(str);
                    }

                    public void reportCompleteness(int percent) {
                        this.val$muh_listener.reportCompleteness(percent);
                    }
                }, hash, timeout);
            }

            public boolean download(URL url) throws MagnetURIHandlerException {
                try {
                    MagnetPlugin.this.plugin_interface.getDownloadManager().addDownload(url);
                    return true;
                }
                catch (DownloadException e) {
                    throw new MagnetURIHandlerException("Operation failed", e);
                }
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                AEThread t = new AEThread(this, "MagnetPlugin:init"){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public void runSupport() {
                        MagnetPlugin.access$000(4.access$100(this.this$1)).getDistributedDatabase();
                    }
                };
                t.setDaemon(true);
                t.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }

            static /* synthetic */ MagnetPlugin access$100(4 x0) {
                return x0.MagnetPlugin.this;
            }
        });
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UISWTInstance swt = (UISWTInstance)instance;
                    Image image = swt.loadImage("com/aelitis/azureus/plugins/magnet/icons/magnet.gif");
                    menu1.setGraphic(swt.createGraphic(image));
                    menu2.setGraphic(swt.createGraphic(image));
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    public URL getMagnetURL(Download d) {
        Torrent torrent = d.getTorrent();
        if (torrent == null) {
            return null;
        }
        return this.getMagnetURL(torrent.getHash());
    }

    public URL getMagnetURL(byte[] hash) {
        try {
            return new URL("magnet:?xt=urn:btih:" + Base32.encode(hash));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public byte[] badge() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] download(final MagnetPluginProgressListener listener, byte[] hash, long timeout) throws MagnetURIHandlerException {
        try {
            DistributedDatabase db = this.plugin_interface.getDistributedDatabase();
            final ArrayList potential_contacts = new ArrayList();
            final AESemaphore potential_contacts_sem = new AESemaphore("MagnetPlugin:liveones");
            final AEMonitor potential_contacts_mon = new AEMonitor("MagnetPlugin:liveones");
            final int[] outstanding = new int[]{0};
            listener.reportActivity("searching...");
            db.read(new DistributedDatabaseListener(){

                public void event(DistributedDatabaseEvent event) {
                    int type = event.getType();
                    if (type == 2) {
                        DistributedDatabaseValue value = event.getValue();
                        listener.reportActivity("found " + value.getContact().getName());
                        outstanding[0] = outstanding[0] + 1;
                        AEThread t = new AEThread(this, "MagnetPlugin:HitHandler", value){
                            private final /* synthetic */ DistributedDatabaseValue val$value;
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$value = val$value;
                                super(x0);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void runSupport() {
                                try {
                                    boolean alive = this.val$value.getContact().isAlive(20000L);
                                    7.access$200(this.this$1).reportActivity(this.val$value.getContact().getName() + " is " + (alive ? "" : "not ") + "alive");
                                    try {
                                        7.access$300(this.this$1).enter();
                                        Object[] entry2 = new Object[]{new Boolean(alive), this.val$value.getContact()};
                                        boolean added = false;
                                        if (alive) {
                                            for (int i = 0; i < 7.access$400(this.this$1).size(); ++i) {
                                                if (((Boolean)((Object[])7.access$400(this.this$1).get(i))[0]).booleanValue()) continue;
                                                7.access$400(this.this$1).add(i, entry2);
                                                added = true;
                                                break;
                                            }
                                        }
                                        if (!added) {
                                            7.access$400(this.this$1).add(entry2);
                                        }
                                        7.access$500(this.this$1).release();
                                    }
                                    finally {
                                        7.access$300(this.this$1).exit();
                                    }
                                    Object var7_6 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var7_7 = null;
                                    try {
                                        7.access$300(this.this$1).enter();
                                        int[] nArray = 7.access$600(this.this$1);
                                        nArray[0] = nArray[0] - 1;
                                    }
                                    finally {
                                        7.access$300(this.this$1).exit();
                                    }
                                    throw throwable;
                                }
                                try {
                                    7.access$300(this.this$1).enter();
                                    int[] nArray = 7.access$600(this.this$1);
                                    nArray[0] = nArray[0] - 1;
                                }
                                finally {
                                    7.access$300(this.this$1).exit();
                                }
                            }
                        };
                        t.setDaemon(true);
                        t.start();
                    } else if (type == 4 || type == 5) {
                        potential_contacts_sem.release();
                    }
                }

                static /* synthetic */ MagnetPluginProgressListener access$200(7 x0) {
                    return x0.listener;
                }

                static /* synthetic */ AEMonitor access$300(7 x0) {
                    return x0.potential_contacts_mon;
                }

                static /* synthetic */ List access$400(7 x0) {
                    return x0.potential_contacts;
                }

                static /* synthetic */ AESemaphore access$500(7 x0) {
                    return x0.potential_contacts_sem;
                }

                static /* synthetic */ int[] access$600(7 x0) {
                    return x0.outstanding;
                }
            }, db.createKey(hash, "Torrent download lookup for '" + ByteFormatter.encodeString(hash) + "'"), timeout);
            long remaining = timeout;
            while (remaining > 0L) {
                DistributedDatabaseContact contact;
                boolean live_contact;
                long start = SystemTime.getCurrentTime();
                potential_contacts_sem.reserve(remaining);
                remaining -= SystemTime.getCurrentTime() - start;
                try {
                    potential_contacts_mon.enter();
                    if (potential_contacts.size() == 0) {
                        if (outstanding[0] != 0) continue;
                        break;
                    }
                    Object[] entry2 = (Object[])potential_contacts.remove(0);
                    live_contact = (Boolean)entry2[0];
                    contact = (DistributedDatabaseContact)entry2[1];
                }
                finally {
                    potential_contacts_mon.exit();
                    continue;
                }
                if (!live_contact) {
                    contact.openTunnel();
                }
                try {
                    listener.reportActivity("downloading data from " + contact.getName());
                    DistributedDatabaseValue value = contact.read(new DistributedDatabaseProgressListener(){

                        public void reportSize(long size) {
                            listener.reportSize(size);
                        }

                        public void reportActivity(String str) {
                            listener.reportActivity(str);
                        }

                        public void reportCompleteness(int percent) {
                            listener.reportCompleteness(percent);
                        }
                    }, db.getStandardTransferType(1), db.createKey(hash, "Torrent download content for '" + ByteFormatter.encodeString(hash) + "'"), timeout);
                    if (value == null) continue;
                    return (byte[])value.getValue([B.class);
                }
                catch (Throwable e) {
                    listener.reportActivity("Failed: " + Debug.getNestedExceptionMessage(e));
                    Debug.printStackTrace(e);
                }
            }
            return null;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            listener.reportActivity("Failed: " + Debug.getNestedExceptionMessage(e));
            throw new MagnetURIHandlerException("MagnetURIHandler failed", e);
        }
    }
}

