/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCActiveAck;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCBye;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCDownloaded;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCError;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCLicenseReply;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCPiece;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCRawMessageImpl;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCReply;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCRequest;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.network.RawMessage;

public class JPCMessageFactory {
    private static final byte ID_REQUEST_DOWN = 30;
    private static final byte ID_CANCEL = 31;
    private static final byte ID_HELLO_DOWN = 32;
    private static final byte ID_INVALIDATE = 33;
    private static final byte ID_PIECE_DOWN = 34;
    private static final byte ID_LICENSE_REQUEST = 30;
    private static final byte ID_LICENSE_REPLY = 35;
    private static final byte ID_REPLY_DOWN = 36;
    private static final byte ID_BYE_DOWN = 37;
    private static final byte ID_REQUEST_UP = 40;
    private static final byte ID_DOWNLOADED = 41;
    private static final byte ID_REPLY_UP = 42;
    private static final byte ID_BYE_UP = 43;
    private static final byte ID_PIECE_UP = 44;
    private static final byte ID_HELLO_UP = 45;
    private static final byte ID_ACTIVE = 46;
    private static final byte ID_ACTIVE_ACK = 47;
    private static final byte ID_ERROR = 50;
    private static final HashMap message_map = new HashMap();
    private static final HashMap id_map;

    public static Message createJPCMessage(ByteBuffer stream_payload) throws MessageException {
        byte id = stream_payload.get();
        Message msg = (Message)message_map.get(new Byte(id));
        if (msg == null) {
            throw new MessageException("unknown JPC message id [" + id + "]");
        }
        return msg.create(stream_payload);
    }

    public static RawMessage createJPCRawMessage(Message base_message) {
        Byte id = (Byte)id_map.get(base_message.getID());
        if (id == null) {
            System.out.println("ERROR: could not find id for base message [" + base_message.getID() + "]");
            return null;
        }
        return new JPCRawMessageImpl(base_message, id);
    }

    static {
        message_map.put(new Byte(34), new JPCPiece(-1, new byte[20], -1, -1, ByteBuffer.allocate(0)));
        message_map.put(new Byte(35), new JPCLicenseReply(new byte[20]));
        message_map.put(new Byte(36), new JPCReply(-1, -1, -1));
        message_map.put(new Byte(37), new JPCBye(""));
        message_map.put(new Byte(40), new JPCRequest(-1, new byte[20], -1, -1, -1));
        message_map.put(new Byte(41), new JPCDownloaded(-1, new byte[20], -1, -1, -1));
        message_map.put(new Byte(42), new JPCReply(-1, -1, -1));
        message_map.put(new Byte(43), new JPCBye(""));
        message_map.put(new Byte(50), new JPCError(-1, -1));
        message_map.put(new Byte(47), new JPCActiveAck(-1, -1));
        id_map = new HashMap();
        id_map.put("JPC_LICENSE_REQUEST", new Byte(30));
        id_map.put("JPC_REQUEST", new Byte(30));
        id_map.put("JPC_CANCEL", new Byte(31));
        id_map.put("JPC_HELLO_DOWN", new Byte(32));
        id_map.put("JPC_INVALIDATE", new Byte(33));
        id_map.put("JPC_PIECE", new Byte(44));
        id_map.put("JPC_HELLO_UP", new Byte(45));
        id_map.put("JPC_ACTIVE", new Byte(46));
    }
}

