/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl;

import com.aelitis.azureus.plugins.jpc.JPCException;
import com.aelitis.azureus.plugins.jpc.JPCPlugin;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheAdapter;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheDownloader;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheDownloaderAdapter;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheUploader;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheUploaderAdapter;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCActive;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCActiveAck;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCBye;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCacheMessage;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCancel;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCDownloaded;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCError;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCHelloDown;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCHelloUp;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCInvalidate;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCLicenseReply;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCLicenseRequest;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCMessageDecoder;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCMessageEncoder;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCPiece;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCReply;
import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCRequest;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.ConnectionListener;
import org.gudy.azureus2.plugins.network.IncomingMessageQueueListener;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueueListener;
import org.gudy.azureus2.plugins.utils.Semaphore;

public class JPCCacheImpl
implements JPCCacheDownloader,
JPCCacheUploader {
    private final JPCPlugin jpc_plugin;
    private final InetSocketAddress address;
    private final boolean uploader;
    private Connection connection = null;
    private int session_id;
    private int bytes_sent = 1;
    private long last_time = 0L;
    private boolean is_connected = false;

    public JPCCacheImpl(JPCPlugin plugin, InetSocketAddress address, boolean uploader) {
        this.jpc_plugin = plugin;
        this.address = address;
        this.uploader = uploader;
    }

    public void connect(final JPCCacheAdapter adapter) throws JPCException {
        final Semaphore connect_sem = this.jpc_plugin.getPluginInterface().getUtilities().getSemaphore();
        final Throwable[] connect_error = new Throwable[1];
        if (this.connection != null) {
            throw new JPCException("connection != null :: connect called on already-connected connection", connect_error[0]);
        }
        this.connection = this.jpc_plugin.getPluginInterface().getConnectionManager().createConnection(this.address, new JPCMessageEncoder(), new JPCMessageDecoder());
        this.connection.connect(new ConnectionListener(){

            public void connectStarted() {
            }

            public void connectSuccess() {
                connect_sem.release();
            }

            public void connectFailure(Throwable failure_msg) {
                JPCCacheImpl.this.jpc_plugin.log("connect failure" + failure_msg.getMessage(), 2);
                connect_error[0] = failure_msg;
                connect_sem.release();
            }

            public void exceptionThrown(Throwable error) {
                JPCCacheImpl.this.jpc_plugin.log("cache connection error: " + error.getMessage(), 2);
                adapter.connectionError(new JPCException("cache connection exception: " + error.getMessage(), error));
                connect_sem.release();
            }
        });
        connect_sem.reserve();
        if (connect_error[0] != null) {
            throw new JPCException("cache connection connect failure", connect_error[0]);
        }
        if (this.connection == null) {
            return;
        }
        this.is_connected = true;
        this.connection.getOutgoingMessageQueue().registerListener(new OutgoingMessageQueueListener(){

            public boolean messageAdded(Message message) {
                return true;
            }

            public void messageSent(Message message) {
                JPCCacheImpl.this.jpc_plugin.log("Sent [" + message.getDescription() + "] message to " + (JPCCacheImpl.this.uploader ? "upload" : "download") + " cache server [" + JPCCacheImpl.this.address + "]", 2);
                if (message.getID().equals("JPC_PIECE")) {
                    JPCPiece piece = (JPCPiece)message;
                    JPCCacheUploaderAdapter up_adapt = (JPCCacheUploaderAdapter)adapter;
                    up_adapt.receivedDownloaded(piece.getSessionID(), piece.getInfohash(), piece.getPieceNumber(), piece.getPieceOffset(), piece.getPieceData().limit());
                }
            }

            public void bytesSent(int byte_count) {
                JPCCacheImpl.this.bytes_sent += byte_count;
                long diff = SystemTime.getCurrentTime() - JPCCacheImpl.this.last_time;
                long rate = (long)(JPCCacheImpl.this.bytes_sent * 1000) / (diff + 1L);
                if (diff > 2000L) {
                    if (rate > 0L) {
                        JPCCacheImpl.this.jpc_plugin.log((JPCCacheImpl.this.uploader ? "upload" : "download") + " cache server send-to rate: " + rate + " bps", 2);
                    }
                    JPCCacheImpl.this.bytes_sent = 1;
                    JPCCacheImpl.this.last_time = SystemTime.getCurrentTime();
                }
            }
        });
        this.connection.getIncomingMessageQueue().registerListener(new IncomingMessageQueueListener(){

            public boolean messageReceived(Message message) {
                JPCCacheImpl.this.jpc_plugin.log("Received [" + message.getDescription() + "] message from " + (JPCCacheImpl.this.uploader ? "upload" : "download") + " cache server [" + JPCCacheImpl.this.address + "]", 2);
                String id = message.getID();
                if (id.equals("JPC_PIECE")) {
                    JPCPiece piece = (JPCPiece)message;
                    JPCCacheDownloaderAdapter down_adapt = (JPCCacheDownloaderAdapter)adapter;
                    down_adapt.receivedBlock(piece.getSessionID(), piece.getInfohash(), piece.getPieceNumber(), piece.getPieceOffset(), piece.getPieceData());
                    return true;
                }
                if (id.equals("JPC_LICENSE_REPLY")) {
                    JPCLicenseReply reply = (JPCLicenseReply)message;
                    JPCCacheDownloaderAdapter down_adapt = (JPCCacheDownloaderAdapter)adapter;
                    down_adapt.receivedLicense(reply.getLicense());
                    return true;
                }
                if (id.equals("JPC_REPLY")) {
                    JPCReply reply = (JPCReply)message;
                    JPCCacheImpl.this.session_id = reply.getSessionID();
                    adapter.receivedReply(JPCCacheImpl.this.session_id, reply.getSessionIdleTime(), reply.getSessionDropTime());
                    return true;
                }
                if (id.equals("JPC_ACTIVE_ACK")) {
                    JPCActiveAck ack = (JPCActiveAck)message;
                    adapter.receivedActiveAck(ack.getSessionIdleTime(), ack.getSessionDropTime());
                    return true;
                }
                if (id.equals("JPC_BYE")) {
                    JPCBye bye = (JPCBye)message;
                    adapter.receivedBye(bye.getReason());
                    return true;
                }
                if (id.equals("JPC_ERROR")) {
                    JPCError error = (JPCError)message;
                    String reason = error.getErrorCode() == 0 ? "connection dropped" : (error.getErrorCode() == 1 ? "invalid response" : (error.getErrorCode() == 2 ? "unknown peer id" : "unknown error code: " + error.getErrorCode()));
                    adapter.receivedError(error.getSessionID(), reason);
                    return true;
                }
                if (id.equals("JPC_REQUEST")) {
                    JPCRequest req = (JPCRequest)message;
                    JPCCacheUploaderAdapter up_adapt = (JPCCacheUploaderAdapter)adapter;
                    up_adapt.receivedRequest(req.getSessionID(), req.getInfohash(), req.getPieceNumber(), req.getPieceOffset(), req.getPieceLength());
                    return true;
                }
                if (id.equals("JPC_DOWNLOADED")) {
                    JPCDownloaded down = (JPCDownloaded)message;
                    JPCCacheUploaderAdapter up_adapt = (JPCCacheUploaderAdapter)adapter;
                    up_adapt.receivedDownloaded(down.getSessionID(), down.getInfohash(), down.getPieceNumber(), down.getPieceOffset(), down.getPieceLength());
                    return true;
                }
                JPCCacheImpl.this.jpc_plugin.log("ERROR: received unknown message id from cache server: " + id, 2);
                return false;
            }

            public void bytesReceived(int byte_count) {
            }
        });
        this.connection.startMessageProcessing();
        adapter.connectSuccess(this, true);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getSessionID() {
        return this.session_id;
    }

    public void sendHello(String client_and_version) {
        JPCCacheMessage hello = this.uploader ? new JPCHelloUp(client_and_version) : new JPCHelloDown(client_and_version);
        if (!this.is_connected) {
            this.jpc_plugin.log("ERROR: cache connection not connected!", 2);
        }
        this.connection.getOutgoingMessageQueue().sendMessage(hello);
    }

    public void sendActive() {
        if (!this.is_connected) {
            this.jpc_plugin.log("ERROR: cache connection not connected!", 2);
        }
        this.connection.getOutgoingMessageQueue().sendMessage(new JPCActive(this.getSessionID()));
    }

    public void requestLicense() {
        if (!this.is_connected) {
            this.jpc_plugin.log("ERROR: cache connection not connected!", 2);
        }
        this.connection.getOutgoingMessageQueue().sendMessage(new JPCLicenseRequest());
    }

    public void requestBlock(int peer_id, byte[] hash, int piece_index, int start_offset, int length) {
        if (!this.is_connected) {
            this.jpc_plugin.log("ERROR: cache connection not connected!", 2);
        }
        this.connection.getOutgoingMessageQueue().sendMessage(new JPCRequest(peer_id, hash, piece_index, start_offset, length));
    }

    public void sendBlock(int peer_id, byte[] hash, int piece_index, int start_offset, ByteBuffer data) {
        if (!this.is_connected) {
            this.jpc_plugin.log("ERROR: cache connection not connected!", 2);
        }
        this.connection.getOutgoingMessageQueue().sendMessage(new JPCPiece(peer_id, hash, piece_index, start_offset, data));
    }

    public void sendCancel(int peer_id, byte[] hash, int piece_index, int start_offset, int length) {
        if (!this.is_connected) {
            this.jpc_plugin.log("ERROR: cache connection not connected!", 2);
        }
        this.connection.getOutgoingMessageQueue().sendMessage(new JPCCancel(peer_id, hash, piece_index, start_offset, length));
    }

    public void sendInvalidate(int peer_id, byte[] hash, int piece_index, int start_offset, int length) {
        if (!this.is_connected) {
            this.jpc_plugin.log("ERROR: cache connection not connected!", 2);
        }
        this.connection.getOutgoingMessageQueue().sendMessage(new JPCInvalidate(peer_id, hash, piece_index, start_offset, length));
    }

    public void closeConnection() {
        this.is_connected = false;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public boolean isConnected() {
        return this.is_connected;
    }
}

