/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus.session;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZSessionEnd
implements AZMessage {
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] infohash;
    private final String reason;

    public AZSessionEnd(byte[] infohash, String reason) {
        this.infohash = infohash;
        this.reason = reason;
    }

    public byte[] getInfoHash() {
        return this.infohash;
    }

    public String getEndReason() {
        return this.reason;
    }

    public String getID() {
        return "AZ_SESSION_END";
    }

    public String getFeatureID() {
        throw new RuntimeException("not implemented");
    }

    public int getFeatureSubID() {
        throw new RuntimeException("not implemented");
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getID() + " for infohash " + ByteFormatter.nicePrint(this.infohash, true) + " because " + this.reason;
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Object> payload_map = new HashMap<String, Object>();
            payload_map.put("infohash", this.infohash);
            payload_map.put("reason", this.reason);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(payload_map, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        Map root = MessagingUtil.convertBencodedByteStreamToPayload(data, 20, this.getID());
        byte[] hash = (byte[])root.get("infohash");
        if (hash == null) {
            throw new MessageException("hash == null");
        }
        if (hash.length != 20) {
            throw new MessageException("hash.length != 20: " + hash.length);
        }
        byte[] reason_raw = (byte[])root.get("reason");
        if (reason_raw == null) {
            throw new MessageException("reason_raw == null");
        }
        String res = new String(reason_raw);
        return new AZSessionEnd(hash, res);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

