/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.download.TorrentDownload;
import com.aelitis.azureus.core.peermanager.download.TorrentDownloadFactory;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.util.Debug;

public class PeerManager {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final PeerManager instance = new PeerManager();
    private final HashMap legacy_managers = new HashMap();
    private final ByteBuffer legacy_handshake_header = ByteBuffer.allocate(20);

    private PeerManager() {
        this.legacy_handshake_header.put((byte)"BitTorrent protocol".length());
        this.legacy_handshake_header.put("BitTorrent protocol".getBytes());
        this.legacy_handshake_header.flip();
        MessageManager.getSingleton().initialize();
    }

    public static PeerManager getSingleton() {
        return instance;
    }

    public void registerLegacyManager(final PEPeerControl manager) {
        NetworkManager.ByteMatcher matcher = new NetworkManager.ByteMatcher(){

            public int size() {
                return 48;
            }

            public int minSize() {
                return 20;
            }

            public boolean matches(ByteBuffer to_compare) {
                boolean matches = false;
                int old_limit = to_compare.limit();
                int old_position = to_compare.position();
                to_compare.limit(old_position + 20);
                if (to_compare.equals(PeerManager.this.legacy_handshake_header)) {
                    to_compare.limit(old_position + 48);
                    to_compare.position(old_position + 28);
                    if (to_compare.equals(ByteBuffer.wrap(manager.getHash()))) {
                        matches = true;
                    }
                }
                to_compare.limit(old_limit);
                to_compare.position(old_position);
                return matches;
            }

            public boolean minMatches(ByteBuffer to_compare) {
                boolean matches = false;
                int old_limit = to_compare.limit();
                int old_position = to_compare.position();
                to_compare.limit(old_position + 20);
                if (to_compare.equals(PeerManager.this.legacy_handshake_header)) {
                    matches = true;
                }
                to_compare.limit(old_limit);
                to_compare.position(old_position);
                return matches;
            }

            public byte[] getSharedSecret() {
                byte[] hash = manager.getTorrentHash();
                return hash;
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(matcher, new NetworkManager.RoutingListener(){

            public void connectionRouted(NetworkConnection connection) {
                boolean same_allowed;
                String address = connection.getAddress().getAddress().getHostAddress();
                boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || address.equals("127.0.0.1");
                if (!same_allowed && PeerIdentityManager.containsIPAddress(manager.getPeerIdentityDataID(), address)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Incoming TCP connection from [" + connection + "] dropped as IP address already " + "connected for [" + manager.getDisplayName() + "]"));
                    }
                    connection.close();
                    return;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Incoming TCP connection from [" + connection + "] routed to legacy download [" + manager.getDisplayName() + "]"));
                }
                manager.addPeerTransport(PEPeerTransportFactory.createTransport(manager, "Incoming", connection));
            }

            public boolean autoCryptoFallback() {
                return false;
            }
        }, new MessageStreamFactory(){

            public MessageStreamEncoder createEncoder() {
                return new BTMessageEncoder();
            }

            public MessageStreamDecoder createDecoder() {
                return new BTMessageDecoder();
            }
        });
        TorrentDownload download = TorrentDownloadFactory.getSingleton().createDownload(manager);
        LegacyRegistration leg_reg = new LegacyRegistration(download, matcher);
        this.legacy_managers.put(manager, leg_reg);
    }

    public void deregisterLegacyManager(PEPeerControl manager) {
        LegacyRegistration leg_reg = (LegacyRegistration)this.legacy_managers.remove(manager);
        if (leg_reg != null) {
            NetworkManager.getSingleton().cancelIncomingConnectionRouting(leg_reg.byte_matcher);
            leg_reg.download.destroy();
        } else {
            Debug.out("matcher == null");
        }
    }

    private static class LegacyRegistration {
        private final TorrentDownload download;
        private final NetworkManager.ByteMatcher byte_matcher;

        private LegacyRegistration(TorrentDownload d, NetworkManager.ByteMatcher m) {
            this.download = d;
            this.byte_matcher = m;
        }
    }
}

