/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilterStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TCPTransportHelperFilterStreamXOR
extends TCPTransportHelperFilterStream {
    private byte[] mask;
    private int read_position;
    private int write_position;

    protected TCPTransportHelperFilterStreamXOR(TCPTransportHelper _transport, byte[] _mask) {
        super(_transport);
        this.mask = _mask;
    }

    protected void cryptoOut(ByteBuffer source_buffer, ByteBuffer target_buffer) throws IOException {
        int rem = source_buffer.remaining();
        for (int i = 0; i < rem; ++i) {
            byte b = source_buffer.get();
            b = (byte)(b ^ this.mask[this.write_position++]);
            target_buffer.put(b);
            if (this.write_position != this.mask.length) continue;
            this.write_position = 0;
        }
    }

    protected void cryptoIn(ByteBuffer source_buffer, ByteBuffer target_buffer) throws IOException {
        int rem = source_buffer.remaining();
        for (int i = 0; i < rem; ++i) {
            byte b = source_buffer.get();
            b = (byte)(b ^ this.mask[this.read_position++]);
            target_buffer.put(b);
            if (this.read_position != this.mask.length) continue;
            this.read_position = 0;
        }
    }

    public String getName() {
        return "XOR-" + this.mask.length * 8;
    }
}

