/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerFactory;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.download.session.TorrentSessionManager;
import com.aelitis.azureus.core.update.AzureusRestarterFactory;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerFactory;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class AzureusCoreImpl
implements AzureusCore,
AzureusCoreListener {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static AzureusCore singleton;
    protected static AEMonitor class_mon;
    private PluginInitializer pi;
    private GlobalManager global_manager;
    private AZInstanceManager instance_manager;
    private boolean started;
    private boolean stopped;
    private List listeners = new ArrayList();
    private List lifecycle_listeners = new ArrayList();
    private AESemaphore stopping_sem = new AESemaphore("AzureusCore::stopping");
    private AEMonitor this_mon = new AEMonitor("AzureusCore");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AzureusCore create() throws AzureusCoreException {
        try {
            class_mon.enter();
            if (singleton != null) {
                throw new AzureusCoreException("Azureus core already instantiated");
            }
            AzureusCore azureusCore = singleton = new AzureusCoreImpl();
            return azureusCore;
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean isCoreAvailable() {
        return singleton != null;
    }

    public static AzureusCore getSingleton() throws AzureusCoreException {
        if (singleton == null) {
            throw new AzureusCoreException("core not instantiated");
        }
        return singleton;
    }

    protected AzureusCoreImpl() {
        COConfigurationManager.initialise();
        AEDiagnostics.startup();
        AETemporaryFileHandler.startup();
        PlatformManagerFactory.getPlatformManager().addListener(new PlatformManagerListener(){

            public void eventOccurred(int type) {
                if (type == 1) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Platform manager requested shutdown"));
                    }
                    AzureusCoreImpl.this.stop();
                }
            }
        });
        NetworkManager.getSingleton();
        PeerManager.getSingleton();
        TorrentSessionManager.getSingleton().init();
        this.pi = PluginInitializer.getSingleton(this, this);
        this.instance_manager = AZInstanceManagerFactory.getSingleton(this);
    }

    public LocaleUtil getLocaleUtil() {
        return LocaleUtil.getSingleton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws AzureusCoreException {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new AzureusCoreException("Core: already started");
            }
            if (this.stopped) {
                throw new AzureusCoreException("Core: already stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading of Plugins starts"));
        }
        this.pi.loadPlugins(this);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading of Plugins complete"));
        }
        this.global_manager = GlobalManagerFactory.create(this);
        for (int i = 0; i < this.lifecycle_listeners.size(); ++i) {
            try {
                ((AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i)).componentCreated(this, this.global_manager);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        this.pi.initialisePlugins();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Initializing Plugins complete"));
        }
        new AEThread("Plugin Init Complete"){

            public void runSupport() {
                AzureusCoreImpl.this.pi.initialisationComplete();
                for (int i = 0; i < AzureusCoreImpl.this.lifecycle_listeners.size(); ++i) {
                    try {
                        ((AzureusCoreLifecycleListener)AzureusCoreImpl.this.lifecycle_listeners.get(i)).started(AzureusCoreImpl.this);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
        NetworkManager.getSingleton().initialize();
        this.instance_manager.initialize();
        Runtime.getRuntime().addShutdownHook(new AEThread("Shutdown Hook"){

            public void runSupport() {
                Logger.log(new LogEvent(LOGID, "Shutdown hook triggered"));
                AzureusCoreImpl.this.stop();
            }
        });
    }

    private void runNonDaemon(final Runnable r) throws AzureusCoreException {
        if (!Thread.currentThread().isDaemon()) {
            r.run();
        } else {
            final AESemaphore sem = new AESemaphore("AzureusCore:runNonDaemon");
            final Throwable[] error = new Throwable[]{null};
            new AEThread("AzureusCore:runNonDaemon"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        error[0] = e;
                    }
                    finally {
                        sem.release();
                    }
                }
            }.start();
            sem.reserve();
            if (error[0] != null) {
                if (error[0] instanceof AzureusCoreException) {
                    throw (AzureusCoreException)error[0];
                }
                throw new AzureusCoreException("Operation failed", error[0]);
            }
        }
    }

    public void stop() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Stop operation starts"));
                }
                AzureusCoreImpl.this.stopSupport(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSupport(boolean apply_updates) throws AzureusCoreException {
        try {
            this.this_mon.enter();
            if (this.stopped) {
                if (COConfigurationManager.isInitialized()) {
                    COConfigurationManager.save();
                }
                Logger.log(new LogEvent(LOGID, "Waiting for stop to complete"));
                this.stopping_sem.reserve();
                return;
            }
            this.stopped = true;
            if (!this.started) {
                Logger.log(new LogEvent(LOGID, "Core not started"));
                this.stopping_sem.releaseForever();
                return;
            }
        }
        finally {
            this.this_mon.exit();
        }
        try {
            int i;
            for (i = 0; i < this.lifecycle_listeners.size(); ++i) {
                try {
                    ((AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i)).stopping(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            this.global_manager.stopGlobalManager();
            for (i = 0; i < this.lifecycle_listeners.size(); ++i) {
                try {
                    ((AzureusCoreLifecycleListener)this.lifecycle_listeners.get(i)).stopped(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            NonDaemonTaskRunner.waitUntilIdle();
            AEDiagnostics.shutdown();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stop operation completes"));
            }
            if (apply_updates && this.getPluginManager().getDefaultPluginInterface().getUpdateManager().getInstallers().length > 0) {
                AzureusRestarterFactory.create(this).restart(true);
            }
        }
        finally {
            this.stopping_sem.releaseForever();
        }
    }

    public void requestStop() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                for (int i = 0; i < AzureusCoreImpl.this.lifecycle_listeners.size(); ++i) {
                    if (((AzureusCoreLifecycleListener)AzureusCoreImpl.this.lifecycle_listeners.get(i)).stopRequested(AzureusCoreImpl.this)) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to stop the core has been denied"));
                    }
                    return;
                }
                AzureusCoreImpl.this.stop();
            }
        });
    }

    public void restart() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation starts"));
                }
                AzureusCoreImpl.this.checkRestartSupported();
                AzureusCoreImpl.this.stopSupport(false);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation: stop complete,restart initiated"));
                }
                AzureusRestarterFactory.create(AzureusCoreImpl.this).restart(false);
            }
        });
    }

    public void requestRestart() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                AzureusCoreImpl.this.checkRestartSupported();
                for (int i = 0; i < AzureusCoreImpl.this.lifecycle_listeners.size(); ++i) {
                    AzureusCoreLifecycleListener l = (AzureusCoreLifecycleListener)AzureusCoreImpl.this.lifecycle_listeners.get(i);
                    if (l.restartRequested(AzureusCoreImpl.this)) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to restart the core has been denied"));
                    }
                    return;
                }
                AzureusCoreImpl.this.restart();
            }
        });
    }

    public void checkRestartSupported() throws AzureusCoreException {
        if (this.getPluginManager().getPluginInterfaceByClass("org.gudy.azureus2.update.UpdaterPatcher") == null) {
            Logger.log(new LogAlert(true, 3, "Can't restart without the 'azupdater' plugin installed"));
            throw new AzureusCoreException("Can't restart without the 'azupdater' plugin installed");
        }
    }

    public GlobalManager getGlobalManager() throws AzureusCoreException {
        if (this.global_manager == null) {
            throw new AzureusCoreException("Core not running");
        }
        return this.global_manager;
    }

    public TRHost getTrackerHost() throws AzureusCoreException {
        return TRHostFactory.getSingleton();
    }

    public PluginManagerDefaults getPluginManagerDefaults() throws AzureusCoreException {
        return PluginManager.getDefaults();
    }

    public PluginManager getPluginManager() throws AzureusCoreException {
        return PluginInitializer.getDefaultInterface().getPluginManager();
    }

    public IpFilterManager getIpFilterManager() throws AzureusCoreException {
        return IpFilterManagerFactory.getSingleton();
    }

    public AZInstanceManager getInstanceManager() {
        return this.instance_manager;
    }

    public void reportCurrentTask(String currentTask) {
        PluginInitializer.fireEvent(3, currentTask);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AzureusCoreListener)this.listeners.get(i)).reportCurrentTask(currentTask);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void reportPercent(int percent) {
        PluginInitializer.fireEvent(4, new Integer(percent));
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AzureusCoreListener)this.listeners.get(i)).reportPercent(percent);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addLifecycleListener(AzureusCoreLifecycleListener l) {
        this.lifecycle_listeners.add(l);
    }

    public void removeLifecycleListener(AzureusCoreLifecycleListener l) {
        this.lifecycle_listeners.remove(l);
    }

    public void addListener(AzureusCoreListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AzureusCoreListener l) {
        this.listeners.remove(l);
    }

    static {
        class_mon = new AEMonitor("AzureusCore:class");
    }
}

